/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import io.airlift.units.DataSize;
import javax.validation.constraints.NotNull;

public class NodeMemoryConfig {
    public static final long AVAILABLE_HEAP_MEMORY = Runtime.getRuntime().maxMemory();
    public static final String QUERY_MAX_BROADCAST_MEMORY_CONFIG = "query.max-broadcast-memory";
    public static final String QUERY_MAX_MEMORY_PER_NODE_CONFIG = "query.max-memory-per-node";
    public static final String QUERY_SOFT_MAX_MEMORY_PER_NODE_CONFIG = "query.soft-max-memory-per-node";
    public static final String QUERY_MAX_TOTAL_MEMORY_PER_NODE_CONFIG = "query.max-total-memory-per-node";
    public static final String QUERY_SOFT_MAX_TOTAL_MEMORY_PER_NODE_CONFIG = "query.soft-max-total-memory-per-node";
    private boolean isReservedPoolEnabled = true;
    private DataSize maxQueryBroadcastMemory;
    private DataSize maxQueryMemoryPerNode = new DataSize((double)AVAILABLE_HEAP_MEMORY * 0.1, DataSize.Unit.BYTE);
    private DataSize softMaxQueryMemoryPerNode;
    private DataSize maxQueryTotalMemoryPerNode;
    private DataSize softMaxQueryTotalMemoryPerNode;
    private DataSize heapHeadroom = new DataSize((double)AVAILABLE_HEAP_MEMORY * 0.3, DataSize.Unit.BYTE);
    private boolean verboseExceededMemoryLimitErrorsEnabled = true;

    @NotNull
    public DataSize getMaxQueryBroadcastMemory() {
        if (this.maxQueryBroadcastMemory == null) {
            return this.getMaxQueryMemoryPerNode();
        }
        return this.maxQueryBroadcastMemory;
    }

    @Config(value="query.max-broadcast-memory")
    public NodeMemoryConfig setMaxQueryBroadcastMemory(DataSize maxQueryBroadcastMemory) {
        if (maxQueryBroadcastMemory.toBytes() < this.getMaxQueryMemoryPerNode().toBytes()) {
            this.maxQueryBroadcastMemory = maxQueryBroadcastMemory;
        }
        return this;
    }

    @NotNull
    public DataSize getMaxQueryMemoryPerNode() {
        return this.maxQueryMemoryPerNode;
    }

    @Config(value="query.max-memory-per-node")
    public NodeMemoryConfig setMaxQueryMemoryPerNode(DataSize maxQueryMemoryPerNode) {
        this.maxQueryMemoryPerNode = maxQueryMemoryPerNode;
        return this;
    }

    @NotNull
    public DataSize getSoftMaxQueryMemoryPerNode() {
        if (this.softMaxQueryMemoryPerNode == null) {
            return this.getMaxQueryMemoryPerNode();
        }
        return this.softMaxQueryMemoryPerNode;
    }

    @Config(value="query.soft-max-memory-per-node")
    public NodeMemoryConfig setSoftMaxQueryMemoryPerNode(DataSize softMaxQueryMemoryPerNode) {
        this.softMaxQueryMemoryPerNode = softMaxQueryMemoryPerNode;
        return this;
    }

    public boolean isReservedPoolEnabled() {
        return this.isReservedPoolEnabled;
    }

    @Config(value="experimental.reserved-pool-enabled")
    public NodeMemoryConfig setReservedPoolEnabled(boolean reservedPoolEnabled) {
        this.isReservedPoolEnabled = reservedPoolEnabled;
        return this;
    }

    @NotNull
    public DataSize getMaxQueryTotalMemoryPerNode() {
        if (this.maxQueryTotalMemoryPerNode == null) {
            DataSize maxQueryMemoryPerNode = this.getMaxQueryMemoryPerNode();
            return new DataSize(maxQueryMemoryPerNode.getValue() * 2.0, maxQueryMemoryPerNode.getUnit());
        }
        return this.maxQueryTotalMemoryPerNode;
    }

    @Config(value="query.max-total-memory-per-node")
    public NodeMemoryConfig setMaxQueryTotalMemoryPerNode(DataSize maxQueryTotalMemoryPerNode) {
        this.maxQueryTotalMemoryPerNode = maxQueryTotalMemoryPerNode;
        return this;
    }

    @NotNull
    public DataSize getSoftMaxQueryTotalMemoryPerNode() {
        if (this.softMaxQueryTotalMemoryPerNode == null) {
            return this.getMaxQueryTotalMemoryPerNode();
        }
        return this.softMaxQueryTotalMemoryPerNode;
    }

    @Config(value="query.soft-max-total-memory-per-node")
    public NodeMemoryConfig setSoftMaxQueryTotalMemoryPerNode(DataSize softMaxQueryTotalMemoryPerNode) {
        this.softMaxQueryTotalMemoryPerNode = softMaxQueryTotalMemoryPerNode;
        return this;
    }

    public DataSize getHeapHeadroom() {
        return this.heapHeadroom;
    }

    @NotNull
    @Config(value="memory.heap-headroom-per-node")
    @ConfigDescription(value="The amount of heap memory to set aside as headroom/buffer (e.g., for untracked allocations)")
    public NodeMemoryConfig setHeapHeadroom(DataSize heapHeadroom) {
        this.heapHeadroom = heapHeadroom;
        return this;
    }

    public boolean isVerboseExceededMemoryLimitErrorsEnabled() {
        return this.verboseExceededMemoryLimitErrorsEnabled;
    }

    @Config(value="memory.verbose-exceeded-memory-limit-errors-enabled")
    @ConfigDescription(value="When enabled the error message for exceeded memory limit errors will contain additional operator memory allocation details")
    public NodeMemoryConfig setVerboseExceededMemoryLimitErrorsEnabled(boolean verboseExceededMemoryLimitErrorsEnabled) {
        this.verboseExceededMemoryLimitErrorsEnabled = verboseExceededMemoryLimitErrorsEnabled;
        return this;
    }
}

