/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.warnings;

import com.facebook.airlift.configuration.Config;
import com.facebook.presto.common.WarningHandlingLevel;
import com.google.common.base.Preconditions;

public class WarningCollectorConfig {
    private int maxWarnings = Integer.MAX_VALUE;
    private WarningHandlingLevel warningHandlingLevel = WarningHandlingLevel.NORMAL;

    @Config(value="warning-collector.max-warnings")
    public WarningCollectorConfig setMaxWarnings(int maxWarnings) {
        Preconditions.checkArgument((maxWarnings >= 0 ? 1 : 0) != 0, (Object)"maxWarnings must be >= 0");
        this.maxWarnings = maxWarnings;
        return this;
    }

    public int getMaxWarnings() {
        return this.maxWarnings;
    }

    @Config(value="warning-collector.warning-handling")
    public WarningCollectorConfig setWarningHandlingLevel(WarningHandlingLevel warningHandlingLevel) {
        this.warningHandlingLevel = warningHandlingLevel;
        return this;
    }

    public WarningHandlingLevel getWarningHandlingLevel() {
        return this.warningHandlingLevel;
    }
}

