/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler.nodeSelection;

import com.facebook.airlift.log.Logger;
import com.facebook.airlift.stats.CounterStat;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.scheduler.BucketNodeMap;
import com.facebook.presto.execution.scheduler.NetworkLocation;
import com.facebook.presto.execution.scheduler.NetworkLocationCache;
import com.facebook.presto.execution.scheduler.NodeAssignmentStats;
import com.facebook.presto.execution.scheduler.NodeMap;
import com.facebook.presto.execution.scheduler.NodeScheduler;
import com.facebook.presto.execution.scheduler.ResettableRandomizedIterator;
import com.facebook.presto.execution.scheduler.SplitPlacementResult;
import com.facebook.presto.execution.scheduler.nodeSelection.NodeSelectionStats;
import com.facebook.presto.execution.scheduler.nodeSelection.NodeSelector;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.NodeProvider;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SplitWeight;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public class TopologyAwareNodeSelector
implements NodeSelector {
    private static final Logger log = Logger.get(TopologyAwareNodeSelector.class);
    private final InternalNodeManager nodeManager;
    private final NodeSelectionStats nodeSelectionStats;
    private final NodeTaskMap nodeTaskMap;
    private final boolean includeCoordinator;
    private final AtomicReference<Supplier<NodeMap>> nodeMap;
    private final int minCandidates;
    private final long maxSplitsWeightPerNode;
    private final long maxPendingSplitsWeightPerTask;
    private final int maxUnacknowledgedSplitsPerTask;
    private final List<CounterStat> topologicalSplitCounters;
    private final List<String> networkLocationSegmentNames;
    private final NetworkLocationCache networkLocationCache;
    private final int maxPreferredNodes;

    public TopologyAwareNodeSelector(InternalNodeManager nodeManager, NodeSelectionStats nodeSelectionStats, NodeTaskMap nodeTaskMap, boolean includeCoordinator, Supplier<NodeMap> nodeMap, int minCandidates, long maxSplitsWeightPerNode, long maxPendingSplitsWeightPerTask, int maxUnacknowledgedSplitsPerTask, List<CounterStat> topologicalSplitCounters, List<String> networkLocationSegmentNames, NetworkLocationCache networkLocationCache, int maxPreferredNodes) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.nodeSelectionStats = Objects.requireNonNull(nodeSelectionStats, "nodeSelectionStats is null");
        this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
        this.includeCoordinator = includeCoordinator;
        this.nodeMap = new AtomicReference<Supplier<NodeMap>>(nodeMap);
        this.minCandidates = minCandidates;
        this.maxSplitsWeightPerNode = maxSplitsWeightPerNode;
        this.maxPendingSplitsWeightPerTask = maxPendingSplitsWeightPerTask;
        this.maxUnacknowledgedSplitsPerTask = maxUnacknowledgedSplitsPerTask;
        Preconditions.checkArgument((maxUnacknowledgedSplitsPerTask > 0 ? 1 : 0) != 0, (String)"maxUnacknowledgedSplitsPerTask must be > 0, found: %s", (int)maxUnacknowledgedSplitsPerTask);
        this.topologicalSplitCounters = Objects.requireNonNull(topologicalSplitCounters, "topologicalSplitCounters is null");
        this.networkLocationSegmentNames = Objects.requireNonNull(networkLocationSegmentNames, "networkLocationSegmentNames is null");
        this.networkLocationCache = Objects.requireNonNull(networkLocationCache, "networkLocationCache is null");
        this.maxPreferredNodes = maxPreferredNodes;
    }

    @Override
    public void lockDownNodes() {
        this.nodeMap.set((Supplier<NodeMap>)Suppliers.ofInstance((Object)((NodeMap)this.nodeMap.get().get())));
    }

    @Override
    public List<InternalNode> getActiveNodes() {
        return ImmutableList.copyOf(((NodeMap)this.nodeMap.get().get()).getActiveNodes());
    }

    @Override
    public List<InternalNode> getAllNodes() {
        return ImmutableList.copyOf(((NodeMap)this.nodeMap.get().get()).getAllNodes());
    }

    @Override
    public InternalNode selectCurrentNode() {
        return this.nodeManager.getCurrentNode();
    }

    @Override
    public List<InternalNode> selectRandomNodes(int limit, Set<InternalNode> excludedNodes) {
        return NodeScheduler.selectNodes(limit, NodeScheduler.randomizedNodes((NodeMap)this.nodeMap.get().get(), this.includeCoordinator, excludedNodes));
    }

    @Override
    public SplitPlacementResult computeAssignments(Set<Split> splits, List<RemoteTask> existingTasks) {
        NodeMap nodeMap = (NodeMap)this.nodeMap.get().get();
        HashMultimap assignment = HashMultimap.create();
        NodeAssignmentStats assignmentStats = new NodeAssignmentStats(this.nodeTaskMap, nodeMap, existingTasks);
        int[] topologicCounters = new int[this.topologicalSplitCounters.size()];
        HashSet<NetworkLocation> filledLocations = new HashSet<NetworkLocation>();
        HashSet<InternalNode> blockedExactNodes = new HashSet<InternalNode>();
        boolean splitWaitingForAnyNode = false;
        NodeProvider nodeProvider = nodeMap.getNodeProvider(this.maxPreferredNodes);
        for (Split split : splits) {
            SplitWeight splitWeight = split.getSplitWeight();
            if (split.getNodeSelectionStrategy() == NodeSelectionStrategy.HARD_AFFINITY) {
                List<InternalNode> candidateNodes = NodeScheduler.selectExactNodes(nodeMap, split.getPreferredNodes(nodeProvider), this.includeCoordinator);
                if (candidateNodes.isEmpty()) {
                    log.debug("No nodes available to schedule %s. Available nodes %s", new Object[]{split, nodeMap.getActiveNodes()});
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No nodes available to run query");
                }
                InternalNode chosenNode = this.bestNodeSplitCount(splitWeight, candidateNodes.iterator(), this.minCandidates, this.maxPendingSplitsWeightPerTask, assignmentStats);
                if (chosenNode != null) {
                    assignment.put((Object)chosenNode, (Object)split);
                    assignmentStats.addAssignedSplit(chosenNode, splitWeight);
                    continue;
                }
                if (splitWaitingForAnyNode) continue;
                blockedExactNodes.addAll(candidateNodes);
                continue;
            }
            InternalNode chosenNode = null;
            int depth = this.networkLocationSegmentNames.size();
            int chosenDepth = 0;
            HashSet<NetworkLocation> locations = new HashSet<NetworkLocation>();
            for (HostAddress host : split.getPreferredNodes(nodeProvider)) {
                locations.add(this.networkLocationCache.get(host));
            }
            if (locations.isEmpty()) {
                locations.add(NetworkLocation.ROOT_LOCATION);
                depth = 0;
            }
            block2: for (int i = depth; i >= 0 && chosenNode == null; --i) {
                for (NetworkLocation location : locations) {
                    if (location.getSegments().size() < i || filledLocations.contains(location = location.subLocation(0, i))) continue;
                    Set nodes = nodeMap.getActiveWorkersByNetworkPath().get((Object)location);
                    chosenNode = this.bestNodeSplitCount(splitWeight, new ResettableRandomizedIterator<InternalNode>(nodes), this.minCandidates, this.calculateMaxPendingSplitsWeightPerTask(i, depth), assignmentStats);
                    if (chosenNode != null) {
                        chosenDepth = i;
                        continue block2;
                    }
                    filledLocations.add(location);
                }
            }
            if (chosenNode != null) {
                assignment.put(chosenNode, (Object)split);
                assignmentStats.addAssignedSplit(chosenNode, splitWeight);
                int n = chosenDepth;
                topologicCounters[n] = topologicCounters[n] + 1;
                continue;
            }
            splitWaitingForAnyNode = true;
        }
        for (int i = 0; i < topologicCounters.length; ++i) {
            if (topologicCounters[i] <= 0) continue;
            this.topologicalSplitCounters.get(i).update((long)topologicCounters[i]);
        }
        long maxPendingForWildcardNetworkAffinity = this.calculateMaxPendingSplitsWeightPerTask(0, this.networkLocationSegmentNames.size());
        ListenableFuture<?> blocked = splitWaitingForAnyNode ? NodeScheduler.toWhenHasSplitQueueSpaceFuture(existingTasks, NodeScheduler.calculateLowWatermark(maxPendingForWildcardNetworkAffinity)) : NodeScheduler.toWhenHasSplitQueueSpaceFuture(blockedExactNodes, existingTasks, NodeScheduler.calculateLowWatermark(maxPendingForWildcardNetworkAffinity));
        return new SplitPlacementResult(blocked, (Multimap<InternalNode, Split>)assignment);
    }

    private long calculateMaxPendingSplitsWeightPerTask(int splitAffinity, int totalDepth) {
        if (totalDepth == 0) {
            return this.maxPendingSplitsWeightPerTask;
        }
        double queueFraction = 0.5 * (1.0 + (double)splitAffinity / (double)totalDepth);
        return (long)Math.ceil((double)this.maxPendingSplitsWeightPerTask * queueFraction);
    }

    @Override
    public SplitPlacementResult computeAssignments(Set<Split> splits, List<RemoteTask> existingTasks, BucketNodeMap bucketNodeMap) {
        return NodeScheduler.selectDistributionNodes((NodeMap)this.nodeMap.get().get(), this.nodeTaskMap, this.maxSplitsWeightPerNode, this.maxPendingSplitsWeightPerTask, this.maxUnacknowledgedSplitsPerTask, splits, existingTasks, bucketNodeMap, this.nodeSelectionStats);
    }

    @Nullable
    private InternalNode bestNodeSplitCount(SplitWeight splitWeight, Iterator<InternalNode> candidates, int minCandidatesWhenFull, long maxPendingSplitsWeightPerTask, NodeAssignmentStats assignmentStats) {
        InternalNode bestQueueNotFull = null;
        long minWeight = Long.MAX_VALUE;
        int fullCandidatesConsidered = 0;
        while (candidates.hasNext() && (fullCandidatesConsidered < minCandidatesWhenFull || bestQueueNotFull == null)) {
            InternalNode node = candidates.next();
            if (assignmentStats.getUnacknowledgedSplitCountForStage(node) >= this.maxUnacknowledgedSplitsPerTask) {
                ++fullCandidatesConsidered;
                continue;
            }
            if (NodeScheduler.canAssignSplitBasedOnWeight(assignmentStats.getTotalSplitsWeight(node), this.maxSplitsWeightPerNode, splitWeight)) {
                return node;
            }
            ++fullCandidatesConsidered;
            long taskQueuedWeight = assignmentStats.getQueuedSplitsWeightForStage(node);
            if (taskQueuedWeight >= minWeight || !NodeScheduler.canAssignSplitBasedOnWeight(taskQueuedWeight, maxPendingSplitsWeightPerTask, splitWeight)) continue;
            minWeight = taskQueuedWeight;
            bestQueueNotFull = node;
        }
        return bestQueueNotFull;
    }
}

