/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler.nodeSelection;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.scheduler.BucketNodeMap;
import com.facebook.presto.execution.scheduler.InternalNodeInfo;
import com.facebook.presto.execution.scheduler.NodeAssignmentStats;
import com.facebook.presto.execution.scheduler.NodeMap;
import com.facebook.presto.execution.scheduler.NodeScheduler;
import com.facebook.presto.execution.scheduler.ResettableRandomizedIterator;
import com.facebook.presto.execution.scheduler.SplitPlacementResult;
import com.facebook.presto.execution.scheduler.nodeSelection.NodeSelector;
import com.facebook.presto.execution.scheduler.nodeSelection.RandomNodeSelection;
import com.facebook.presto.execution.scheduler.nodeSelection.SimpleNodeSelector;
import com.facebook.presto.execution.scheduler.nodeSelection.SimpleTtlNodeSelectorConfig;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SplitContext;
import com.facebook.presto.spi.SplitWeight;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.facebook.presto.spi.ttl.ConfidenceBasedTtlInfo;
import com.facebook.presto.spi.ttl.NodeTtl;
import com.facebook.presto.ttl.nodettlfetchermanagers.NodeTtlFetcherManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class SimpleTtlNodeSelector
implements NodeSelector {
    private static final Logger log = Logger.get(SimpleTtlNodeSelector.class);
    private final NodeTtlFetcherManager nodeTtlFetcherManager;
    private final Session session;
    private final AtomicReference<Supplier<NodeMap>> nodeMap;
    private final NodeTaskMap nodeTaskMap;
    private final int minCandidates;
    private final boolean includeCoordinator;
    private final long maxSplitsWeightPerNode;
    private final long maxPendingSplitsWeightPerTask;
    private final int maxTasksPerStage;
    private final SimpleNodeSelector simpleNodeSelector;
    private final QueryManager queryManager;
    private final Duration estimatedExecutionTime;
    private final boolean fallbackToSimpleNodeSelection;

    public SimpleTtlNodeSelector(SimpleNodeSelector simpleNodeSelector, SimpleTtlNodeSelectorConfig config, NodeTaskMap nodeTaskMap, Supplier<NodeMap> nodeMap, int minCandidates, boolean includeCoordinator, long maxSplitsWeightPerNode, long maxPendingSplitsWeightPerTask, int maxTasksPerStage, NodeTtlFetcherManager ttlFetcherManager, QueryManager queryManager, Session session) {
        this.simpleNodeSelector = Objects.requireNonNull(simpleNodeSelector, "simpleNodeSelector is null");
        this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
        this.nodeMap = new AtomicReference<Supplier<NodeMap>>(Objects.requireNonNull(nodeMap, "nodeMap is null"));
        this.minCandidates = minCandidates;
        this.includeCoordinator = includeCoordinator;
        this.maxSplitsWeightPerNode = maxSplitsWeightPerNode;
        this.maxPendingSplitsWeightPerTask = maxPendingSplitsWeightPerTask;
        this.maxTasksPerStage = maxTasksPerStage;
        this.nodeTtlFetcherManager = Objects.requireNonNull(ttlFetcherManager, "ttlFetcherManager is null");
        this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
        this.session = Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(config, "config is null");
        Preconditions.checkArgument((session.getResourceEstimates().getExecutionTime().isPresent() || config.getUseDefaultExecutionTimeEstimateAsFallback() ? 1 : 0) != 0, (Object)"Estimated execution time is not present");
        this.estimatedExecutionTime = session.getResourceEstimates().getExecutionTime().orElse(config.getDefaultExecutionTimeEstimate());
        this.fallbackToSimpleNodeSelection = config.getFallbackToSimpleNodeSelection();
    }

    @Override
    public void lockDownNodes() {
        this.nodeMap.set((Supplier<NodeMap>)Suppliers.ofInstance((Object)((NodeMap)this.nodeMap.get().get())));
        this.simpleNodeSelector.lockDownNodes();
    }

    @Override
    public List<InternalNode> getActiveNodes() {
        return this.simpleNodeSelector.getActiveNodes();
    }

    @Override
    public List<InternalNode> getAllNodes() {
        return this.simpleNodeSelector.getAllNodes();
    }

    @Override
    public InternalNode selectCurrentNode() {
        return this.simpleNodeSelector.selectCurrentNode();
    }

    @Override
    public List<InternalNode> selectRandomNodes(int limit, Set<InternalNode> excludedNodes) {
        Duration estimatedExecutionTimeRemaining;
        Map<InternalNode, NodeTtl> nodeTtlInfo = this.nodeTtlFetcherManager.getAllTtls();
        Map ttlInfo = (Map)nodeTtlInfo.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ((NodeTtl)e.getValue()).getTtlInfo().stream().min(Comparator.comparing(ConfidenceBasedTtlInfo::getExpiryInstant))));
        NodeMap nodeMap = (NodeMap)this.nodeMap.get().get();
        List<InternalNode> activeNodes = nodeMap.getActiveNodes();
        List<InternalNode> eligibleNodes = this.filterNodesByTtl(activeNodes, excludedNodes, ttlInfo, estimatedExecutionTimeRemaining = this.getEstimatedExecutionTimeRemaining());
        List<InternalNode> selectedNodes = NodeScheduler.selectNodes(limit, new ResettableRandomizedIterator<InternalNode>(eligibleNodes));
        if (selectedNodes.isEmpty() && this.fallbackToSimpleNodeSelection) {
            log.warn("No nodes available with enough TTL (%s), falling back to simple node selection.", new Object[]{estimatedExecutionTimeRemaining});
            return this.simpleNodeSelector.selectRandomNodes(limit, excludedNodes);
        }
        return selectedNodes;
    }

    @Override
    public SplitPlacementResult computeAssignments(Set<Split> splits, List<RemoteTask> existingTasks) {
        boolean isNodeSelectionStrategyNoPreference = splits.stream().allMatch(split -> split.getNodeSelectionStrategy() == NodeSelectionStrategy.NO_PREFERENCE);
        if (!isNodeSelectionStrategyNoPreference) {
            return this.simpleNodeSelector.computeAssignments(splits, existingTasks);
        }
        ImmutableMultimap.Builder assignment = ImmutableMultimap.builder();
        NodeMap nodeMap = (NodeMap)this.nodeMap.get().get();
        NodeAssignmentStats assignmentStats = new NodeAssignmentStats(this.nodeTaskMap, nodeMap, existingTasks);
        List<InternalNode> eligibleNodes = this.getEligibleNodes(this.maxTasksPerStage, nodeMap, existingTasks);
        RandomNodeSelection randomNodeSelection = new RandomNodeSelection(eligibleNodes, this.minCandidates);
        boolean splitWaitingForAnyNode = false;
        OptionalInt preferredNodeCount = OptionalInt.empty();
        for (Split split2 : splits) {
            if (split2.getNodeSelectionStrategy() != NodeSelectionStrategy.NO_PREFERENCE) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NODE_SELECTION_NOT_SUPPORTED, String.format("Unsupported node selection strategy for TTL scheduling: %s", split2.getNodeSelectionStrategy()));
            }
            List<InternalNode> candidateNodes = randomNodeSelection.pickNodes(split2);
            if (candidateNodes.isEmpty()) {
                Duration remainingTime = this.getEstimatedExecutionTimeRemaining();
                if (this.fallbackToSimpleNodeSelection) {
                    log.warn("No nodes available with enough TTL (%s) to schedule %s. Active nodes %s, falling back to simple node selection.", new Object[]{remainingTime, split2, nodeMap.getActiveNodes()});
                    return this.simpleNodeSelector.computeAssignments(splits, existingTasks);
                }
                log.warn("No nodes available with enough TTL (%s) to schedule %s. Active nodes %s", new Object[]{remainingTime, split2, nodeMap.getActiveNodes()});
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No nodes available to run query");
            }
            SplitWeight splitWeight = split2.getSplitWeight();
            Optional<InternalNodeInfo> chosenNodeInfo = this.simpleNodeSelector.chooseLeastBusyNode(splitWeight, candidateNodes, assignmentStats::getTotalSplitsWeight, preferredNodeCount, this.maxSplitsWeightPerNode, assignmentStats);
            if (!chosenNodeInfo.isPresent()) {
                chosenNodeInfo = this.simpleNodeSelector.chooseLeastBusyNode(splitWeight, candidateNodes, assignmentStats::getQueuedSplitsWeightForStage, preferredNodeCount, this.maxPendingSplitsWeightPerTask, assignmentStats);
            }
            if (chosenNodeInfo.isPresent()) {
                split2 = new Split(split2.getConnectorId(), split2.getTransactionHandle(), split2.getConnectorSplit(), split2.getLifespan(), new SplitContext(chosenNodeInfo.get().isCacheable()));
                InternalNode chosenNode = chosenNodeInfo.get().getInternalNode();
                assignment.put((Object)chosenNode, (Object)split2);
                assignmentStats.addAssignedSplit(chosenNode, splitWeight);
                continue;
            }
            splitWaitingForAnyNode = true;
        }
        ListenableFuture<?> blocked = splitWaitingForAnyNode ? NodeScheduler.toWhenHasSplitQueueSpaceFuture(existingTasks, NodeScheduler.calculateLowWatermark(this.maxPendingSplitsWeightPerTask)) : Futures.immediateFuture(null);
        return new SplitPlacementResult(blocked, (Multimap<InternalNode, Split>)assignment.build());
    }

    @Override
    public SplitPlacementResult computeAssignments(Set<Split> splits, List<RemoteTask> existingTasks, BucketNodeMap bucketNodeMap) {
        return this.simpleNodeSelector.computeAssignments(splits, existingTasks, bucketNodeMap);
    }

    @VisibleForTesting
    public static boolean isTtlEnough(ConfidenceBasedTtlInfo ttlInfo, Duration estimatedExecutionTime) {
        Instant expiryTime = ttlInfo.getExpiryInstant();
        long timeRemainingInSeconds = ChronoUnit.SECONDS.between(Instant.now(), expiryTime);
        return new Duration((double)Math.max(timeRemainingInSeconds, 0L), TimeUnit.SECONDS).compareTo(estimatedExecutionTime) >= 0;
    }

    private Duration getEstimatedExecutionTimeRemaining() {
        double totalEstimatedExecutionTime = this.estimatedExecutionTime.getValue(TimeUnit.MILLISECONDS);
        double elapsedExecutionTime = this.queryManager.getQueryInfo(this.session.getQueryId()).getQueryStats().getExecutionTime().getValue(TimeUnit.MILLISECONDS);
        double estimatedExecutionTimeRemaining = Math.max(totalEstimatedExecutionTime - elapsedExecutionTime, 0.0);
        return new Duration(estimatedExecutionTimeRemaining, TimeUnit.MILLISECONDS);
    }

    private List<InternalNode> getEligibleNodes(int limit, NodeMap nodeMap, List<RemoteTask> existingTasks) {
        Map<InternalNode, NodeTtl> nodeTtlInfo = this.nodeTtlFetcherManager.getAllTtls();
        Map ttlInfo = (Map)nodeTtlInfo.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ((NodeTtl)e.getValue()).getTtlInfo().stream().min(Comparator.comparing(ConfidenceBasedTtlInfo::getExpiryInstant))));
        Duration estimatedExecutionTimeRemaining = this.getEstimatedExecutionTimeRemaining();
        List<InternalNode> existingEligibleNodes = existingTasks.stream().map(remoteTask -> nodeMap.getActiveNodesByNodeId().get(remoteTask.getNodeId())).filter(Objects::nonNull).filter(ttlInfo::containsKey).filter(node -> ((Optional)ttlInfo.get(node)).isPresent()).filter(node -> SimpleTtlNodeSelector.isTtlEnough((ConfidenceBasedTtlInfo)((Optional)ttlInfo.get(node)).get(), estimatedExecutionTimeRemaining)).collect(Collectors.toList());
        int alreadySelectedNodeCount = existingEligibleNodes.size();
        List<InternalNode> activeNodes = nodeMap.getActiveNodes();
        List<InternalNode> newEligibleNodes = this.filterNodesByTtl(activeNodes, (Set<InternalNode>)ImmutableSet.copyOf(existingEligibleNodes), ttlInfo, estimatedExecutionTimeRemaining);
        if (alreadySelectedNodeCount < limit && newEligibleNodes.size() > 0) {
            List<InternalNode> moreNodes = NodeScheduler.selectNodes(limit - alreadySelectedNodeCount, new ResettableRandomizedIterator<InternalNode>(newEligibleNodes));
            existingEligibleNodes.addAll(moreNodes);
        }
        Verify.verify((boolean)existingEligibleNodes.stream().allMatch(Objects::nonNull), (String)"existingNodes list must not contain any nulls", (Object[])new Object[0]);
        return existingEligibleNodes;
    }

    private List<InternalNode> filterNodesByTtl(List<InternalNode> nodes, Set<InternalNode> excludedNodes, Map<InternalNode, Optional<ConfidenceBasedTtlInfo>> ttlInfo, Duration estimatedExecutionTimeRemaining) {
        return (List)nodes.stream().filter(ttlInfo::containsKey).filter(node -> this.includeCoordinator || !node.isCoordinator()).filter(node -> !excludedNodes.contains(node)).filter(node -> ((Optional)ttlInfo.get(node)).isPresent()).filter(node -> SimpleTtlNodeSelector.isTtlEnough((ConfidenceBasedTtlInfo)((Optional)ttlInfo.get(node)).get(), estimatedExecutionTimeRemaining)).collect(ImmutableList.toImmutableList());
    }
}

