/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler.nodeSelection;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.scheduler.BucketNodeMap;
import com.facebook.presto.execution.scheduler.InternalNodeInfo;
import com.facebook.presto.execution.scheduler.NodeAssignmentStats;
import com.facebook.presto.execution.scheduler.NodeMap;
import com.facebook.presto.execution.scheduler.NodeScheduler;
import com.facebook.presto.execution.scheduler.SplitPlacementResult;
import com.facebook.presto.execution.scheduler.nodeSelection.NodeSelectionStats;
import com.facebook.presto.execution.scheduler.nodeSelection.NodeSelector;
import com.facebook.presto.execution.scheduler.nodeSelection.RandomNodeSelection;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.NodeProvider;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SplitContext;
import com.facebook.presto.spi.SplitWeight;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;

public class SimpleNodeSelector
implements NodeSelector {
    private static final Logger log = Logger.get(SimpleNodeSelector.class);
    private final InternalNodeManager nodeManager;
    private final NodeSelectionStats nodeSelectionStats;
    private final NodeTaskMap nodeTaskMap;
    private final boolean includeCoordinator;
    private final AtomicReference<Supplier<NodeMap>> nodeMap;
    private final int minCandidates;
    private final long maxSplitsWeightPerNode;
    private final long maxPendingSplitsWeightPerTask;
    private final int maxUnacknowledgedSplitsPerTask;
    private final int maxTasksPerStage;
    private final int maxPreferredNodes;

    public SimpleNodeSelector(InternalNodeManager nodeManager, NodeSelectionStats nodeSelectionStats, NodeTaskMap nodeTaskMap, boolean includeCoordinator, Supplier<NodeMap> nodeMap, int minCandidates, long maxSplitsWeightPerNode, long maxPendingSplitsWeightPerTask, int maxUnacknowledgedSplitsPerTask, int maxTasksPerStage, int maxPreferredNodes) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.nodeSelectionStats = Objects.requireNonNull(nodeSelectionStats, "nodeSelectionStats is null");
        this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
        this.includeCoordinator = includeCoordinator;
        this.nodeMap = new AtomicReference<Supplier<NodeMap>>(nodeMap);
        this.minCandidates = minCandidates;
        this.maxSplitsWeightPerNode = maxSplitsWeightPerNode;
        this.maxPendingSplitsWeightPerTask = maxPendingSplitsWeightPerTask;
        this.maxUnacknowledgedSplitsPerTask = maxUnacknowledgedSplitsPerTask;
        Preconditions.checkArgument((maxUnacknowledgedSplitsPerTask > 0 ? 1 : 0) != 0, (String)"maxUnacknowledgedSplitsPerTask must be > 0, found: %s", (int)maxUnacknowledgedSplitsPerTask);
        this.maxTasksPerStage = maxTasksPerStage;
        this.maxPreferredNodes = maxPreferredNodes;
    }

    @Override
    public void lockDownNodes() {
        this.nodeMap.set((Supplier<NodeMap>)Suppliers.ofInstance((Object)((NodeMap)this.nodeMap.get().get())));
    }

    @Override
    public List<InternalNode> getActiveNodes() {
        return ImmutableList.copyOf(((NodeMap)this.nodeMap.get().get()).getActiveNodes());
    }

    @Override
    public List<InternalNode> getAllNodes() {
        return ImmutableList.copyOf(((NodeMap)this.nodeMap.get().get()).getAllNodes());
    }

    @Override
    public InternalNode selectCurrentNode() {
        return this.nodeManager.getCurrentNode();
    }

    @Override
    public List<InternalNode> selectRandomNodes(int limit, Set<InternalNode> excludedNodes) {
        return NodeScheduler.selectNodes(limit, NodeScheduler.randomizedNodes((NodeMap)this.nodeMap.get().get(), this.includeCoordinator, excludedNodes));
    }

    @Override
    public SplitPlacementResult computeAssignments(Set<Split> splits, List<RemoteTask> existingTasks) {
        HashMultimap assignment = HashMultimap.create();
        NodeMap nodeMap = (NodeMap)this.nodeMap.get().get();
        NodeAssignmentStats assignmentStats = new NodeAssignmentStats(this.nodeTaskMap, nodeMap, existingTasks);
        List<InternalNode> eligibleNodes = this.getEligibleNodes(this.maxTasksPerStage, nodeMap, existingTasks);
        RandomNodeSelection randomNodeSelection = new RandomNodeSelection(eligibleNodes, this.minCandidates);
        HashSet<InternalNode> blockedExactNodes = new HashSet<InternalNode>();
        boolean splitWaitingForAnyNode = false;
        NodeProvider nodeProvider = nodeMap.getNodeProvider(this.maxPreferredNodes);
        OptionalInt preferredNodeCount = OptionalInt.empty();
        for (Split split : splits) {
            ImmutableList candidateNodes;
            switch (split.getNodeSelectionStrategy()) {
                case HARD_AFFINITY: {
                    candidateNodes = NodeScheduler.selectExactNodes(nodeMap, split.getPreferredNodes(nodeProvider), this.includeCoordinator);
                    preferredNodeCount = OptionalInt.of(candidateNodes.size());
                    break;
                }
                case SOFT_AFFINITY: {
                    candidateNodes = NodeScheduler.selectExactNodes(nodeMap, split.getPreferredNodes(nodeProvider), this.includeCoordinator);
                    preferredNodeCount = OptionalInt.of(candidateNodes.size());
                    candidateNodes = ImmutableList.builder().addAll(candidateNodes).addAll(randomNodeSelection.pickNodes(split)).build();
                    break;
                }
                case NO_PREFERENCE: {
                    candidateNodes = randomNodeSelection.pickNodes(split);
                    break;
                }
                default: {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NODE_SELECTION_NOT_SUPPORTED, String.format("Unsupported node selection strategy %s", split.getNodeSelectionStrategy()));
                }
            }
            if (candidateNodes.isEmpty()) {
                log.debug("No nodes available to schedule %s. Available nodes %s", new Object[]{split, nodeMap.getActiveNodes()});
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No nodes available to run query");
            }
            SplitWeight splitWeight = split.getSplitWeight();
            Optional<InternalNodeInfo> chosenNodeInfo = this.chooseLeastBusyNode(splitWeight, (List<InternalNode>)candidateNodes, assignmentStats::getTotalSplitsWeight, preferredNodeCount, this.maxSplitsWeightPerNode, assignmentStats);
            if (!chosenNodeInfo.isPresent()) {
                chosenNodeInfo = this.chooseLeastBusyNode(splitWeight, (List<InternalNode>)candidateNodes, assignmentStats::getQueuedSplitsWeightForStage, preferredNodeCount, this.maxPendingSplitsWeightPerTask, assignmentStats);
            }
            if (chosenNodeInfo.isPresent()) {
                split = new Split(split.getConnectorId(), split.getTransactionHandle(), split.getConnectorSplit(), split.getLifespan(), new SplitContext(chosenNodeInfo.get().isCacheable()));
                InternalNode chosenNode = chosenNodeInfo.get().getInternalNode();
                assignment.put((Object)chosenNode, (Object)split);
                assignmentStats.addAssignedSplit(chosenNode, splitWeight);
                continue;
            }
            if (split.getNodeSelectionStrategy() != NodeSelectionStrategy.HARD_AFFINITY) {
                splitWaitingForAnyNode = true;
                continue;
            }
            if (splitWaitingForAnyNode) continue;
            blockedExactNodes.addAll((Collection<InternalNode>)candidateNodes);
        }
        ListenableFuture<?> blocked = splitWaitingForAnyNode ? NodeScheduler.toWhenHasSplitQueueSpaceFuture(existingTasks, NodeScheduler.calculateLowWatermark(this.maxPendingSplitsWeightPerTask)) : NodeScheduler.toWhenHasSplitQueueSpaceFuture(blockedExactNodes, existingTasks, NodeScheduler.calculateLowWatermark(this.maxPendingSplitsWeightPerTask));
        return new SplitPlacementResult(blocked, (Multimap<InternalNode, Split>)assignment);
    }

    @Override
    public SplitPlacementResult computeAssignments(Set<Split> splits, List<RemoteTask> existingTasks, BucketNodeMap bucketNodeMap) {
        return NodeScheduler.selectDistributionNodes((NodeMap)this.nodeMap.get().get(), this.nodeTaskMap, this.maxSplitsWeightPerNode, this.maxPendingSplitsWeightPerTask, this.maxUnacknowledgedSplitsPerTask, splits, existingTasks, bucketNodeMap, this.nodeSelectionStats);
    }

    protected Optional<InternalNodeInfo> chooseLeastBusyNode(SplitWeight splitWeight, List<InternalNode> candidateNodes, ToLongFunction<InternalNode> splitWeightProvider, OptionalInt preferredNodeCount, long maxSplitsWeight, NodeAssignmentStats assignmentStats) {
        long minWeight = Long.MAX_VALUE;
        InternalNode chosenNode = null;
        for (int i = 0; i < candidateNodes.size(); ++i) {
            InternalNode node = candidateNodes.get(i);
            if (node.getNodeStatus() == InternalNode.NodeStatus.DEAD) {
                if (!preferredNodeCount.isPresent() || i >= preferredNodeCount.getAsInt()) continue;
                this.nodeSelectionStats.incrementPreferredNonAliveNodeSkippedCount();
                continue;
            }
            if (assignmentStats.getUnacknowledgedSplitCountForStage(node) >= this.maxUnacknowledgedSplitsPerTask) continue;
            long currentWeight = splitWeightProvider.applyAsLong(node);
            boolean canAssignToNode = NodeScheduler.canAssignSplitBasedOnWeight(currentWeight, maxSplitsWeight, splitWeight);
            if (preferredNodeCount.isPresent() && i < preferredNodeCount.getAsInt() && canAssignToNode) {
                if (i == 0) {
                    this.nodeSelectionStats.incrementPrimaryPreferredNodeSelectedCount();
                } else {
                    this.nodeSelectionStats.incrementNonPrimaryPreferredNodeSelectedCount();
                }
                return Optional.of(new InternalNodeInfo(node, true));
            }
            if (!canAssignToNode || currentWeight >= minWeight) continue;
            chosenNode = node;
            minWeight = currentWeight;
        }
        if (chosenNode == null) {
            return Optional.empty();
        }
        this.nodeSelectionStats.incrementNonPreferredNodeSelectedCount();
        return Optional.of(new InternalNodeInfo(chosenNode, false));
    }

    private List<InternalNode> getEligibleNodes(int limit, NodeMap nodeMap, List<RemoteTask> existingTasks) {
        List<InternalNode> existingNodes = existingTasks.stream().map(remoteTask -> nodeMap.getActiveNodesByNodeId().get(remoteTask.getNodeId())).filter(Objects::nonNull).collect(Collectors.toList());
        int alreadySelectedNodeCount = existingNodes.size();
        int nodeCount = nodeMap.getActiveNodesByNodeId().size();
        if (alreadySelectedNodeCount < limit && alreadySelectedNodeCount < nodeCount) {
            List<InternalNode> moreNodes = NodeScheduler.selectNodes(limit - alreadySelectedNodeCount, NodeScheduler.randomizedNodes(nodeMap, this.includeCoordinator, Sets.newHashSet(existingNodes)));
            existingNodes.addAll(moreNodes);
        }
        Verify.verify((boolean)existingNodes.stream().allMatch(Objects::nonNull), (String)"existingNodes list must not contain any nulls", (Object[])new Object[0]);
        return existingNodes;
    }
}

