/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.SqlStageExecution;
import com.facebook.presto.execution.StageExecutionState;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.scheduler.BroadcastOutputBufferManager;
import com.facebook.presto.execution.scheduler.ExchangeLocationsConsumer;
import com.facebook.presto.execution.scheduler.OutputBufferManager;
import com.facebook.presto.execution.scheduler.PartitionedOutputBufferManager;
import com.facebook.presto.execution.scheduler.ScaledOutputBufferManager;
import com.facebook.presto.spi.plan.PartitioningHandle;
import com.facebook.presto.spi.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import java.util.List;
import java.util.Set;

public class StageLinkage {
    private final PlanFragmentId currentStageFragmentId;
    private final ExchangeLocationsConsumer parent;
    private final Set<OutputBufferManager> childOutputBufferManagers;

    public StageLinkage(PlanFragmentId fragmentId, ExchangeLocationsConsumer parent, Set<SqlStageExecution> children) {
        this.currentStageFragmentId = fragmentId;
        this.parent = parent;
        this.childOutputBufferManagers = (Set)children.stream().map(childStage -> {
            PartitioningHandle partitioningHandle = childStage.getFragment().getPartitioningScheme().getPartitioning().getHandle();
            if (partitioningHandle.equals((Object)SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION)) {
                return new BroadcastOutputBufferManager(childStage::setOutputBuffers);
            }
            if (partitioningHandle.equals((Object)SystemPartitioningHandle.SCALED_WRITER_DISTRIBUTION)) {
                return new ScaledOutputBufferManager(childStage::setOutputBuffers);
            }
            int partitionCount = Ints.max((int[])((int[])childStage.getFragment().getPartitioningScheme().getBucketToPartition().get())) + 1;
            return new PartitionedOutputBufferManager(partitioningHandle, partitionCount, childStage::setOutputBuffers);
        }).collect(ImmutableSet.toImmutableSet());
    }

    public void processScheduleResults(StageExecutionState newState, Set<RemoteTask> newTasks) {
        boolean noMoreTasks = false;
        switch (newState) {
            case PLANNED: 
            case SCHEDULING: {
                break;
            }
            case FINISHED_TASK_SCHEDULING: 
            case SCHEDULING_SPLITS: 
            case SCHEDULED: 
            case RUNNING: 
            case FINISHED: 
            case CANCELED: {
                noMoreTasks = true;
            }
        }
        this.parent.addExchangeLocations(this.currentStageFragmentId, newTasks, noMoreTasks);
        if (!this.childOutputBufferManagers.isEmpty()) {
            List newOutputBuffers = (List)newTasks.stream().map(task -> new OutputBuffers.OutputBufferId(task.getTaskId().getId())).collect(ImmutableList.toImmutableList());
            for (OutputBufferManager child : this.childOutputBufferManagers) {
                child.addOutputBuffers(newOutputBuffers, noMoreTasks);
            }
        }
    }
}

