/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.scheduler.OutputBufferManager;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.concurrent.GuardedBy;

public class ScaledOutputBufferManager
implements OutputBufferManager {
    private final Consumer<OutputBuffers> outputBufferTarget;
    @GuardedBy(value="this")
    private OutputBuffers outputBuffers = OutputBuffers.createInitialEmptyOutputBuffers(OutputBuffers.BufferType.ARBITRARY);

    public ScaledOutputBufferManager(Consumer<OutputBuffers> outputBufferTarget) {
        this.outputBufferTarget = Objects.requireNonNull(outputBufferTarget, "outputBufferTarget is null");
        outputBufferTarget.accept(this.outputBuffers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOutputBuffers(List<OutputBuffers.OutputBufferId> newBuffers, boolean noMoreBuffers) {
        OutputBuffers newOutputBuffers;
        ScaledOutputBufferManager scaledOutputBufferManager = this;
        synchronized (scaledOutputBufferManager) {
            if (this.outputBuffers.isNoMoreBufferIds()) {
                return;
            }
            OutputBuffers originalOutputBuffers = this.outputBuffers;
            for (OutputBuffers.OutputBufferId newBuffer : newBuffers) {
                this.outputBuffers = this.outputBuffers.withBuffer(newBuffer, newBuffer.getId());
            }
            if (noMoreBuffers) {
                this.outputBuffers = this.outputBuffers.withNoMoreBufferIds();
            }
            if (this.outputBuffers == originalOutputBuffers) {
                return;
            }
            newOutputBuffers = this.outputBuffers;
        }
        this.outputBufferTarget.accept(newOutputBuffers);
    }
}

