/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class NetworkLocation {
    public static final NetworkLocation ROOT_LOCATION = new NetworkLocation(new String[0]);
    private final List<String> segments;

    public NetworkLocation(String ... segments) {
        this(Arrays.asList(segments));
    }

    private NetworkLocation(List<String> segments) {
        this.segments = segments;
    }

    public static NetworkLocation create(List<String> segments) {
        Objects.requireNonNull(segments, "segments is null");
        return new NetworkLocation((List<String>)ImmutableList.copyOf(segments));
    }

    public NetworkLocation subLocation(int start, int end) {
        return new NetworkLocation(this.segments.subList(start, end));
    }

    public List<String> getSegments() {
        return this.segments;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NetworkLocation that = (NetworkLocation)obj;
        return this.segments.equals(that.segments);
    }

    public int hashCode() {
        return this.segments.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("location", (Object)("/" + Joiner.on((String)"/").join(this.segments))).toString();
    }
}

