/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.presto.CompressionCodec;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.execution.buffer.AirliftCompressorAdapter;
import com.facebook.presto.execution.buffer.AirliftDecompressorAdapter;
import com.facebook.presto.execution.buffer.GzipCompressor;
import com.facebook.presto.execution.buffer.GzipDecompressor;
import com.facebook.presto.execution.buffer.ZlibCompressor;
import com.facebook.presto.execution.buffer.ZlibDecompressor;
import com.facebook.presto.spi.page.PageCompressor;
import com.facebook.presto.spi.page.PageDecompressor;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.spiller.SpillCipher;
import io.airlift.compress.Compressor;
import io.airlift.compress.Decompressor;
import io.airlift.compress.lz4.Lz4Compressor;
import io.airlift.compress.lz4.Lz4Decompressor;
import io.airlift.compress.lzo.LzoCompressor;
import io.airlift.compress.lzo.LzoDecompressor;
import io.airlift.compress.snappy.SnappyCompressor;
import io.airlift.compress.snappy.SnappyDecompressor;
import io.airlift.compress.zstd.ZstdCompressor;
import io.airlift.compress.zstd.ZstdDecompressor;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class PagesSerdeFactory {
    private final BlockEncodingSerde blockEncodingSerde;
    private final CompressionCodec compressionCodec;
    private final boolean checksumEnabled;

    public PagesSerdeFactory(BlockEncodingSerde blockEncodingSerde, CompressionCodec compressionCodec) {
        this(blockEncodingSerde, compressionCodec, false);
    }

    public PagesSerdeFactory(BlockEncodingSerde blockEncodingSerde, CompressionCodec compressionCodec, boolean checksumEnabled) {
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.compressionCodec = Objects.requireNonNull(compressionCodec, "compressionCodec is null");
        this.checksumEnabled = checksumEnabled;
    }

    public PagesSerde createPagesSerde() {
        return this.createPagesSerdeInternal(Optional.empty());
    }

    public PagesSerde createPagesSerdeForSpill(Optional<SpillCipher> spillCipher) {
        return this.createPagesSerdeInternal(spillCipher);
    }

    private PagesSerde createPagesSerdeInternal(Optional<SpillCipher> spillCipher) {
        return new PagesSerde(this.blockEncodingSerde, this.getPageCompressor(), this.getPageDecompressor(), spillCipher, this.checksumEnabled);
    }

    private Optional<PageCompressor> getPageCompressor() {
        switch (this.compressionCodec) {
            case GZIP: {
                return Optional.of(new AirliftCompressorAdapter(new GzipCompressor()));
            }
            case LZ4: {
                return Optional.of(new AirliftCompressorAdapter((Compressor)new Lz4Compressor()));
            }
            case LZO: {
                return Optional.of(new AirliftCompressorAdapter((Compressor)new LzoCompressor()));
            }
            case SNAPPY: {
                return Optional.of(new AirliftCompressorAdapter((Compressor)new SnappyCompressor()));
            }
            case ZLIB: {
                return Optional.of(new AirliftCompressorAdapter(new ZlibCompressor(OptionalInt.empty())));
            }
            case ZSTD: {
                return Optional.of(new AirliftCompressorAdapter((Compressor)new ZstdCompressor()));
            }
        }
        return Optional.empty();
    }

    private Optional<PageDecompressor> getPageDecompressor() {
        switch (this.compressionCodec) {
            case GZIP: {
                return Optional.of(new AirliftDecompressorAdapter(new GzipDecompressor()));
            }
            case LZ4: {
                return Optional.of(new AirliftDecompressorAdapter((Decompressor)new Lz4Decompressor()));
            }
            case LZO: {
                return Optional.of(new AirliftDecompressorAdapter((Decompressor)new LzoDecompressor()));
            }
            case SNAPPY: {
                return Optional.of(new AirliftDecompressorAdapter((Decompressor)new SnappyDecompressor()));
            }
            case ZLIB: {
                return Optional.of(new AirliftDecompressorAdapter(new ZlibDecompressor()));
            }
            case ZSTD: {
                return Optional.of(new AirliftDecompressorAdapter((Decompressor)new ZstdDecompressor()));
            }
        }
        return Optional.empty();
    }
}

