/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.presto.memory.context.LocalMemoryContext;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class OutputBufferMemoryManager {
    private static final ListenableFuture<?> NOT_BLOCKED = Futures.immediateFuture(null);
    private final long maxBufferedBytes;
    private final AtomicLong bufferedBytes = new AtomicLong();
    private final AtomicLong peakMemoryUsage = new AtomicLong();
    @GuardedBy(value="this")
    private boolean closed;
    @Nullable
    @GuardedBy(value="this")
    private SettableFuture<?> bufferBlockedFuture;
    @GuardedBy(value="this")
    private ListenableFuture<?> blockedOnMemory = NOT_BLOCKED;
    private final AtomicBoolean blockOnFull = new AtomicBoolean(true);
    private final Supplier<LocalMemoryContext> systemMemoryContextSupplier;
    private final Executor notificationExecutor;

    public OutputBufferMemoryManager(long maxBufferedBytes, Supplier<LocalMemoryContext> systemMemoryContextSupplier, Executor notificationExecutor) {
        Objects.requireNonNull(systemMemoryContextSupplier, "systemMemoryContextSupplier is null");
        Preconditions.checkArgument((maxBufferedBytes > 0L ? 1 : 0) != 0, (Object)"maxBufferedBytes must be > 0");
        this.maxBufferedBytes = maxBufferedBytes;
        this.systemMemoryContextSupplier = Suppliers.memoize(systemMemoryContextSupplier::get);
        this.notificationExecutor = Objects.requireNonNull(notificationExecutor, "notificationExecutor is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMemoryUsage(long bytesAdded) {
        long currentBufferedBytes;
        LocalMemoryContext systemMemoryContext = this.getSystemMemoryContextOrNull();
        if (systemMemoryContext == null) {
            return;
        }
        ListenableFuture waitForMemory = null;
        SettableFuture<?> notifyUnblocked = null;
        OutputBufferMemoryManager outputBufferMemoryManager = this;
        synchronized (outputBufferMemoryManager) {
            if (this.closed) {
                return;
            }
            currentBufferedBytes = this.bufferedBytes.addAndGet(bytesAdded);
            ListenableFuture blockedOnMemory = systemMemoryContext.setBytes(currentBufferedBytes);
            if (!blockedOnMemory.isDone()) {
                if (this.blockedOnMemory != blockedOnMemory) {
                    this.blockedOnMemory = blockedOnMemory;
                    waitForMemory = blockedOnMemory;
                }
            } else {
                this.blockedOnMemory = NOT_BLOCKED;
                if (currentBufferedBytes <= this.maxBufferedBytes || !this.blockOnFull.get()) {
                    notifyUnblocked = this.bufferBlockedFuture;
                    this.bufferBlockedFuture = null;
                }
            }
        }
        this.peakMemoryUsage.accumulateAndGet(currentBufferedBytes, Math::max);
        this.notifyListener(notifyUnblocked);
        if (waitForMemory != null) {
            waitForMemory.addListener(this::onMemoryAvailable, this.notificationExecutor);
        }
    }

    public synchronized ListenableFuture<?> getBufferBlockedFuture() {
        if (this.bufferBlockedFuture == null) {
            if (this.blockedOnMemory.isDone() && !this.isBufferFull()) {
                return NOT_BLOCKED;
            }
            this.bufferBlockedFuture = SettableFuture.create();
        }
        return this.bufferBlockedFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNoBlockOnFull() {
        SettableFuture<?> future = null;
        OutputBufferMemoryManager outputBufferMemoryManager = this;
        synchronized (outputBufferMemoryManager) {
            this.blockOnFull.set(false);
            if (this.blockedOnMemory.isDone()) {
                future = this.bufferBlockedFuture;
                this.bufferBlockedFuture = null;
            }
        }
        this.notifyListener(future);
    }

    public long getBufferedBytes() {
        return this.bufferedBytes.get();
    }

    public double getUtilization() {
        return (double)this.bufferedBytes.get() / (double)this.maxBufferedBytes;
    }

    public boolean isOverutilized() {
        return this.isBufferFull();
    }

    private boolean isBufferFull() {
        return this.bufferedBytes.get() > this.maxBufferedBytes && this.blockOnFull.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void onMemoryAvailable() {
        SettableFuture<?> future;
        if (this.isBufferFull()) {
            return;
        }
        OutputBufferMemoryManager outputBufferMemoryManager = this;
        synchronized (outputBufferMemoryManager) {
            if (this.isBufferFull() || !this.blockedOnMemory.isDone()) {
                return;
            }
            future = this.bufferBlockedFuture;
            this.bufferBlockedFuture = null;
        }
        this.notifyListener(future);
    }

    public long getPeakMemoryUsage() {
        return this.peakMemoryUsage.get();
    }

    public synchronized void close() {
        this.updateMemoryUsage(-this.bufferedBytes.get());
        LocalMemoryContext memoryContext = this.getSystemMemoryContextOrNull();
        if (memoryContext != null) {
            memoryContext.close();
        }
        this.closed = true;
    }

    private void notifyListener(@Nullable SettableFuture<?> future) {
        if (future != null) {
            this.notificationExecutor.execute(() -> future.set(null));
        }
    }

    @Nullable
    private LocalMemoryContext getSystemMemoryContextOrNull() {
        try {
            return this.systemMemoryContextSupplier.get();
        }
        catch (RuntimeException ignored) {
            return null;
        }
    }
}

