/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import io.airlift.compress.Decompressor;
import io.airlift.compress.MalformedInputException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;

public class GzipDecompressor
implements Decompressor {
    /*
     * Enabled aggressive exception aggregation
     */
    public int decompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) throws MalformedInputException {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(input, inputOffset, inputLength);){
            int n;
            try (GZIPInputStream gzipInputStream = new GZIPInputStream(byteArrayInputStream);){
                int totalRead;
                int bytesRead;
                for (totalRead = 0; totalRead < maxOutputLength && (bytesRead = gzipInputStream.read(output, outputOffset + totalRead, maxOutputLength - totalRead)) != -1; totalRead += bytesRead) {
                }
                if (totalRead >= maxOutputLength && gzipInputStream.read() != -1) {
                    throw new IllegalArgumentException("maxOutputLength is incorrect, there is more data to be decompressed");
                }
                n = totalRead;
            }
            return n;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void decompress(ByteBuffer input, ByteBuffer output) throws MalformedInputException {
        int inputOffset = input.arrayOffset() + input.position();
        int outputOffset = output.arrayOffset() + output.position();
        int written = this.decompress(input.array(), inputOffset, input.remaining(), output.array(), outputOffset, output.remaining());
        ((Buffer)output).position(output.position() + written);
    }
}

