/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.transaction.TransactionId;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.SessionTransactionControlTask;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.AccessControlContext;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Use;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Set;

public class UseTask
implements SessionTransactionControlTask<Use> {
    @Override
    public String getName() {
        return "USE";
    }

    @Override
    public ListenableFuture<?> execute(Use statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters, String query) {
        Session session = stateMachine.getSession();
        this.checkCatalogAndSessionPresent(statement, session);
        this.checkAndSetCatalog(statement, metadata, stateMachine, session, accessControl);
        this.checkAndSetSchema(statement, metadata, stateMachine, session, accessControl);
        return Futures.immediateFuture(null);
    }

    private void checkCatalogAndSessionPresent(Use statement, Session session) {
        if (!statement.getCatalog().isPresent() && !session.getCatalog().isPresent()) {
            throw new SemanticException(SemanticErrorCode.CATALOG_NOT_SPECIFIED, (Node)statement, "Catalog must be specified when session catalog is not set", new Object[0]);
        }
    }

    private void checkAndSetCatalog(Use statement, Metadata metadata, QueryStateMachine stateMachine, Session session, AccessControl accessControl) {
        String catalog = statement.getCatalog().map(Identifier::getValueLowerCase).orElseGet(() -> session.getCatalog().map(String::toLowerCase).get());
        MetadataUtil.getConnectorIdOrThrow(session, metadata, catalog);
        if (!this.hasCatalogAccess(session.getIdentity(), session.getAccessControlContext(), catalog, accessControl)) {
            AccessDeniedException.denyCatalogAccess((String)catalog);
        }
        stateMachine.setSetCatalog(catalog);
    }

    private void checkAndSetSchema(Use statement, Metadata metadata, QueryStateMachine stateMachine, Session session, AccessControl accessControl) {
        String catalog = statement.getCatalog().map(Identifier::getValueLowerCase).orElseGet(() -> session.getCatalog().map(String::toLowerCase).get());
        Identifier schemaIdentifier = statement.getSchema();
        String schema = metadata.normalizeIdentifier(session, catalog, schemaIdentifier.getValue());
        if (!metadata.getMetadataResolver(session).schemaExists(new CatalogSchemaName(catalog, schema))) {
            throw new SemanticException(SemanticErrorCode.MISSING_SCHEMA, String.format("Schema does not exist: %s.%s", catalog, schema), new Object[0]);
        }
        if (!this.hasSchemaAccess(session.getTransactionId().get(), session.getIdentity(), session.getAccessControlContext(), catalog, schema, accessControl)) {
            throw new AccessDeniedException("Cannot access schema: " + new CatalogSchemaName(catalog, schema));
        }
        stateMachine.setSetSchema(schema);
    }

    private boolean hasCatalogAccess(Identity identity, AccessControlContext context, String catalog, AccessControl accessControl) {
        return !accessControl.filterCatalogs(identity, context, (Set)ImmutableSet.of((Object)catalog)).isEmpty();
    }

    private boolean hasSchemaAccess(TransactionId transactionId, Identity identity, AccessControlContext context, String catalog, String schema, AccessControl accessControl) {
        return !accessControl.filterSchemas(transactionId, identity, context, catalog, (Set)ImmutableSet.of((Object)schema)).isEmpty();
    }
}

