/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;

public class ThreadCountParser {
    private static final String PER_CORE_SUFFIX = "C";

    private ThreadCountParser() {
    }

    public static int parse(String value) {
        return ThreadCountParser.parse(value, Runtime.getRuntime().availableProcessors());
    }

    @VisibleForTesting
    static int parse(String value, int availableProcessors) {
        int threads;
        if (value.endsWith(PER_CORE_SUFFIX)) {
            double multiplier = Double.parseDouble(value.substring(0, value.length() - PER_CORE_SUFFIX.length()).trim());
            Preconditions.checkArgument((multiplier > 0.0 ? 1 : 0) != 0, (String)"Thread multiplier must be positive: %s", (Object)multiplier);
            threads = Math.toIntExact(Math.round(multiplier * (double)availableProcessors));
            threads = Math.max(threads, 1);
        } else {
            threads = Integer.parseInt(value);
        }
        Preconditions.checkArgument((threads > 0 ? 1 : 0) != 0, (String)"Thread count must be positive: %s", (int)threads);
        return threads;
    }
}

