/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskSource;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.TaskStatus;
import com.facebook.presto.execution.buffer.BufferResult;
import com.facebook.presto.execution.buffer.OutputBufferInfo;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.memory.MemoryPoolAssignmentsRequest;
import com.facebook.presto.metadata.MetadataUpdates;
import com.facebook.presto.sql.planner.PlanFragment;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Optional;

public interface TaskManager {
    public List<TaskInfo> getAllTaskInfo();

    public TaskInfo getTaskInfo(TaskId var1);

    public TaskStatus getTaskStatus(TaskId var1);

    public ListenableFuture<TaskInfo> getTaskInfo(TaskId var1, TaskState var2);

    public String getTaskInstanceId(TaskId var1);

    public ListenableFuture<TaskStatus> getTaskStatus(TaskId var1, TaskState var2);

    public void updateMemoryPoolAssignments(MemoryPoolAssignmentsRequest var1);

    public TaskInfo updateTask(Session var1, TaskId var2, Optional<PlanFragment> var3, List<TaskSource> var4, OutputBuffers var5, Optional<TableWriteInfo> var6);

    public TaskInfo cancelTask(TaskId var1);

    public TaskInfo abortTask(TaskId var1);

    public ListenableFuture<BufferResult> getTaskResults(TaskId var1, OutputBuffers.OutputBufferId var2, long var3, long var5);

    public OutputBufferInfo getOutputBufferInfo(TaskId var1);

    public void acknowledgeTaskResults(TaskId var1, OutputBuffers.OutputBufferId var2, long var3);

    public TaskInfo abortTaskResults(TaskId var1, OutputBuffers.OutputBufferId var2);

    public void addStateChangeListener(TaskId var1, StateMachine.StateChangeListener<TaskState> var2);

    public void removeRemoteSource(TaskId var1, TaskId var2);

    public void updateMetadataResults(TaskId var1, MetadataUpdates var2);
}

