/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.stats.Distribution;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.execution.BasicStageExecutionStats;
import com.facebook.presto.execution.StageExecutionState;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.spi.eventlistener.StageGcStatistics;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.Immutable;

@Immutable
public class StageExecutionStats {
    private final long schedulingCompleteInMillis;
    private final Distribution.DistributionSnapshot getSplitDistribution;
    private final int totalTasks;
    private final int runningTasks;
    private final int completedTasks;
    private final int totalLifespans;
    private final int completedLifespans;
    private final int totalDrivers;
    private final int queuedDrivers;
    private final int runningDrivers;
    private final int blockedDrivers;
    private final int completedDrivers;
    private final int totalNewDrivers;
    private final int queuedNewDrivers;
    private final int runningNewDrivers;
    private final int completedNewDrivers;
    private final int totalSplits;
    private final int queuedSplits;
    private final int runningSplits;
    private final int completedSplits;
    private final double cumulativeUserMemory;
    private final double cumulativeTotalMemory;
    private final long userMemoryReservationInBytes;
    private final long totalMemoryReservationInBytes;
    private final long peakUserMemoryReservationInBytes;
    private final long peakNodeTotalMemoryReservationInBytes;
    private final Duration totalScheduledTime;
    private final Duration totalCpuTime;
    private final Duration retriedCpuTime;
    private final Duration totalBlockedTime;
    private final boolean fullyBlocked;
    private final Set<BlockedReason> blockedReasons;
    private final long totalAllocationInBytes;
    private final long rawInputDataSizeInBytes;
    private final long rawInputPositions;
    private final long processedInputDataSizeInBytes;
    private final long processedInputPositions;
    private final long bufferedDataSizeInBytes;
    private final long outputDataSizeInBytes;
    private final long outputPositions;
    private final long physicalWrittenDataSizeInBytes;
    private final StageGcStatistics gcInfo;
    private final List<OperatorStats> operatorSummaries;
    private final RuntimeStats runtimeStats;

    @JsonCreator
    public StageExecutionStats(@JsonProperty(value="schedulingCompleteInMillis") long schedulingCompleteInMillis, @JsonProperty(value="getSplitDistribution") Distribution.DistributionSnapshot getSplitDistribution, @JsonProperty(value="totalTasks") int totalTasks, @JsonProperty(value="runningTasks") int runningTasks, @JsonProperty(value="completedTasks") int completedTasks, @JsonProperty(value="totalLifespans") int totalLifespans, @JsonProperty(value="completedLifespans") int completedLifespans, @JsonProperty(value="totalDrivers") int totalDrivers, @JsonProperty(value="queuedDrivers") int queuedDrivers, @JsonProperty(value="runningDrivers") int runningDrivers, @JsonProperty(value="blockedDrivers") int blockedDrivers, @JsonProperty(value="completedDrivers") int completedDrivers, @JsonProperty(value="totalNewDrivers") int totalNewDrivers, @JsonProperty(value="queuedNewDrivers") int queuedNewDrivers, @JsonProperty(value="runningNewDrivers") int runningNewDrivers, @JsonProperty(value="completedNewDrivers") int completedNewDrivers, @JsonProperty(value="totalSplits") int totalSplits, @JsonProperty(value="queuedSplits") int queuedSplits, @JsonProperty(value="runningSplits") int runningSplits, @JsonProperty(value="completedSplits") int completedSplits, @JsonProperty(value="cumulativeUserMemory") double cumulativeUserMemory, @JsonProperty(value="cumulativeTotalMemory") double cumulativeTotalMemory, @JsonProperty(value="userMemoryReservationInBytes") long userMemoryReservationInBytes, @JsonProperty(value="totalMemoryReservationInBytes") long totalMemoryReservationInBytes, @JsonProperty(value="peakUserMemoryReservationInBytes") long peakUserMemoryReservationInBytes, @JsonProperty(value="peakNodeTotalMemoryReservationInBytes") long peakNodeTotalMemoryReservationInBytes, @JsonProperty(value="totalScheduledTime") Duration totalScheduledTime, @JsonProperty(value="totalCpuTime") Duration totalCpuTime, @JsonProperty(value="retriedCpuTime") Duration retriedCpuTime, @JsonProperty(value="totalBlockedTime") Duration totalBlockedTime, @JsonProperty(value="fullyBlocked") boolean fullyBlocked, @JsonProperty(value="blockedReasons") Set<BlockedReason> blockedReasons, @JsonProperty(value="totalAllocationInBytes") long totalAllocationInBytes, @JsonProperty(value="rawInputDataSizeInBytes") long rawInputDataSizeInBytes, @JsonProperty(value="rawInputPositions") long rawInputPositions, @JsonProperty(value="processedInputDataSizeInBytes") long processedInputDataSizeInBytes, @JsonProperty(value="processedInputPositions") long processedInputPositions, @JsonProperty(value="bufferedDataSizeInBytes") long bufferedDataSizeInBytes, @JsonProperty(value="outputDataSizeInBytes") long outputDataSizeInBytes, @JsonProperty(value="outputPositions") long outputPositions, @JsonProperty(value="physicalWrittenDataSizeInBytes") long physicalWrittenDataSizeInBytes, @JsonProperty(value="gcInfo") StageGcStatistics gcInfo, @JsonProperty(value="operatorSummaries") List<OperatorStats> operatorSummaries, @JsonProperty(value="runtimeStats") RuntimeStats runtimeStats) {
        this.schedulingCompleteInMillis = schedulingCompleteInMillis;
        this.getSplitDistribution = Objects.requireNonNull(getSplitDistribution, "getSplitDistribution is null");
        Preconditions.checkArgument((totalTasks >= 0 ? 1 : 0) != 0, (Object)"totalTasks is negative");
        this.totalTasks = totalTasks;
        Preconditions.checkArgument((runningTasks >= 0 ? 1 : 0) != 0, (Object)"runningTasks is negative");
        this.runningTasks = runningTasks;
        Preconditions.checkArgument((completedTasks >= 0 ? 1 : 0) != 0, (Object)"completedTasks is negative");
        this.completedTasks = completedTasks;
        Preconditions.checkArgument((totalLifespans >= 0 ? 1 : 0) != 0, (Object)"completedLifespans is negative");
        this.totalLifespans = totalLifespans;
        Preconditions.checkArgument((completedLifespans >= 0 ? 1 : 0) != 0, (Object)"completedLifespans is negative");
        this.completedLifespans = completedLifespans;
        Preconditions.checkArgument((totalDrivers >= 0 ? 1 : 0) != 0, (Object)"totalDrivers is negative");
        this.totalDrivers = totalDrivers;
        Preconditions.checkArgument((queuedDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedDrivers is negative");
        this.queuedDrivers = queuedDrivers;
        Preconditions.checkArgument((runningDrivers >= 0 ? 1 : 0) != 0, (Object)"runningDrivers is negative");
        this.runningDrivers = runningDrivers;
        Preconditions.checkArgument((blockedDrivers >= 0 ? 1 : 0) != 0, (Object)"blockedDrivers is negative");
        this.blockedDrivers = blockedDrivers;
        Preconditions.checkArgument((completedDrivers >= 0 ? 1 : 0) != 0, (Object)"completedDrivers is negative");
        this.completedDrivers = completedDrivers;
        Preconditions.checkArgument((totalNewDrivers >= 0 ? 1 : 0) != 0, (Object)"totalNewDrivers is negative");
        this.totalNewDrivers = totalNewDrivers;
        Preconditions.checkArgument((queuedNewDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedNewDrivers is negative");
        this.queuedNewDrivers = queuedNewDrivers;
        Preconditions.checkArgument((runningNewDrivers >= 0 ? 1 : 0) != 0, (Object)"runningNewDrivers is negative");
        this.runningNewDrivers = runningNewDrivers;
        Preconditions.checkArgument((completedNewDrivers >= 0 ? 1 : 0) != 0, (Object)"completedNewDrivers is negative");
        this.completedNewDrivers = completedNewDrivers;
        Preconditions.checkArgument((totalSplits >= 0 ? 1 : 0) != 0, (Object)"totalSplits is negative");
        this.totalSplits = totalSplits;
        Preconditions.checkArgument((queuedSplits >= 0 ? 1 : 0) != 0, (Object)"queuedSplits is negative");
        this.queuedSplits = queuedSplits;
        Preconditions.checkArgument((runningSplits >= 0 ? 1 : 0) != 0, (Object)"runningSplits is negative");
        this.runningSplits = runningSplits;
        Preconditions.checkArgument((completedSplits >= 0 ? 1 : 0) != 0, (Object)"completedSplits is negative");
        this.completedSplits = completedSplits;
        Preconditions.checkArgument((cumulativeUserMemory >= 0.0 ? 1 : 0) != 0, (Object)"cumulativeUserMemory is negative");
        this.cumulativeUserMemory = cumulativeUserMemory;
        Preconditions.checkArgument((cumulativeTotalMemory >= 0.0 ? 1 : 0) != 0, (Object)"cumulativeTotalMemory is negative");
        this.cumulativeTotalMemory = cumulativeTotalMemory;
        Preconditions.checkArgument((userMemoryReservationInBytes >= 0L ? 1 : 0) != 0, (Object)"userMemoryReservationInBytes is negative");
        this.userMemoryReservationInBytes = userMemoryReservationInBytes;
        Preconditions.checkArgument((totalMemoryReservationInBytes >= 0L ? 1 : 0) != 0, (Object)"totalMemoryReservationInBytes is negative");
        this.totalMemoryReservationInBytes = totalMemoryReservationInBytes;
        Preconditions.checkArgument((peakUserMemoryReservationInBytes >= 0L ? 1 : 0) != 0, (Object)"peakUserMemoryReservationInBytes is negative");
        this.peakUserMemoryReservationInBytes = peakUserMemoryReservationInBytes;
        Preconditions.checkArgument((peakNodeTotalMemoryReservationInBytes >= 0L ? 1 : 0) != 0, (Object)"peakNodeTotalMemoryReservationInBytes is negative");
        this.peakNodeTotalMemoryReservationInBytes = peakNodeTotalMemoryReservationInBytes;
        this.totalScheduledTime = Objects.requireNonNull(totalScheduledTime, "totalScheduledTime is null");
        this.totalCpuTime = Objects.requireNonNull(totalCpuTime, "totalCpuTime is null");
        this.retriedCpuTime = Objects.requireNonNull(retriedCpuTime, "retriedCpuTime is null");
        this.totalBlockedTime = Objects.requireNonNull(totalBlockedTime, "totalBlockedTime is null");
        this.fullyBlocked = fullyBlocked;
        this.blockedReasons = ImmutableSet.copyOf((Collection)Objects.requireNonNull(blockedReasons, "blockedReasons is null"));
        Preconditions.checkArgument((totalAllocationInBytes >= 0L ? 1 : 0) != 0, (Object)"totalAllocationInBytes is negative");
        this.totalAllocationInBytes = totalAllocationInBytes;
        Preconditions.checkArgument((rawInputDataSizeInBytes >= 0L ? 1 : 0) != 0, (Object)"rawInputDataSizeInBytes is negative");
        this.rawInputDataSizeInBytes = rawInputDataSizeInBytes;
        Preconditions.checkArgument((rawInputPositions >= 0L ? 1 : 0) != 0, (Object)"rawInputPositions is negative");
        this.rawInputPositions = rawInputPositions;
        Preconditions.checkArgument((processedInputDataSizeInBytes >= 0L ? 1 : 0) != 0, (Object)"processedInputDataSizeInBytes is negative");
        this.processedInputDataSizeInBytes = processedInputDataSizeInBytes;
        Preconditions.checkArgument((processedInputPositions >= 0L ? 1 : 0) != 0, (Object)"processedInputPositions is negative");
        this.processedInputPositions = processedInputPositions;
        Preconditions.checkArgument((bufferedDataSizeInBytes >= 0L ? 1 : 0) != 0, (Object)"bufferedDataSizeInBytes is negative");
        this.bufferedDataSizeInBytes = bufferedDataSizeInBytes;
        this.outputDataSizeInBytes = outputDataSizeInBytes >= 0L ? outputDataSizeInBytes : Long.MAX_VALUE;
        Preconditions.checkArgument((outputPositions >= 0L ? 1 : 0) != 0, (Object)"outputPositions is negative");
        this.outputPositions = outputPositions;
        Preconditions.checkArgument((physicalWrittenDataSizeInBytes >= 0L ? 1 : 0) != 0, (Object)"writtenDataSizeInBytes is negative");
        this.physicalWrittenDataSizeInBytes = physicalWrittenDataSizeInBytes;
        this.gcInfo = Objects.requireNonNull(gcInfo, "gcInfo is null");
        this.operatorSummaries = ImmutableList.copyOf((Collection)Objects.requireNonNull(operatorSummaries, "operatorSummaries is null"));
        this.runtimeStats = runtimeStats == null ? new RuntimeStats() : runtimeStats;
    }

    @JsonProperty
    public long getSchedulingCompleteInMillis() {
        return this.schedulingCompleteInMillis;
    }

    @JsonProperty
    public Distribution.DistributionSnapshot getGetSplitDistribution() {
        return this.getSplitDistribution;
    }

    @JsonProperty
    public int getTotalTasks() {
        return this.totalTasks;
    }

    @JsonProperty
    public int getRunningTasks() {
        return this.runningTasks;
    }

    @JsonProperty
    public int getCompletedTasks() {
        return this.completedTasks;
    }

    @JsonProperty
    public int getTotalLifespans() {
        return this.totalLifespans;
    }

    @JsonProperty
    public int getCompletedLifespans() {
        return this.completedLifespans;
    }

    @JsonProperty
    public int getTotalDrivers() {
        return this.totalDrivers;
    }

    @JsonProperty
    public int getQueuedDrivers() {
        return this.queuedDrivers;
    }

    @JsonProperty
    public int getRunningDrivers() {
        return this.runningDrivers;
    }

    @JsonProperty
    public int getBlockedDrivers() {
        return this.blockedDrivers;
    }

    @JsonProperty
    public int getCompletedDrivers() {
        return this.completedDrivers;
    }

    @JsonProperty
    public int getTotalNewDrivers() {
        return this.totalNewDrivers;
    }

    @JsonProperty
    public int getQueuedNewDrivers() {
        return this.queuedNewDrivers;
    }

    @JsonProperty
    public int getRunningNewDrivers() {
        return this.runningNewDrivers;
    }

    @JsonProperty
    public int getCompletedNewDrivers() {
        return this.completedNewDrivers;
    }

    @JsonProperty
    public int getTotalSplits() {
        return this.totalSplits;
    }

    @JsonProperty
    public int getQueuedSplits() {
        return this.queuedSplits;
    }

    @JsonProperty
    public int getRunningSplits() {
        return this.runningSplits;
    }

    @JsonProperty
    public int getCompletedSplits() {
        return this.completedSplits;
    }

    @JsonProperty
    public double getCumulativeUserMemory() {
        return this.cumulativeUserMemory;
    }

    @JsonProperty
    public double getCumulativeTotalMemory() {
        return this.cumulativeTotalMemory;
    }

    @JsonProperty
    public long getUserMemoryReservationInBytes() {
        return this.userMemoryReservationInBytes;
    }

    @JsonProperty
    public long getTotalMemoryReservationInBytes() {
        return this.totalMemoryReservationInBytes;
    }

    @JsonProperty
    public long getPeakUserMemoryReservationInBytes() {
        return this.peakUserMemoryReservationInBytes;
    }

    @JsonProperty
    public long getPeakNodeTotalMemoryReservationInBytes() {
        return this.peakNodeTotalMemoryReservationInBytes;
    }

    @JsonProperty
    public Duration getTotalScheduledTime() {
        return this.totalScheduledTime;
    }

    @JsonProperty
    public Duration getTotalCpuTime() {
        return this.totalCpuTime;
    }

    @JsonProperty
    public Duration getRetriedCpuTime() {
        return this.retriedCpuTime;
    }

    @JsonProperty
    public Duration getTotalBlockedTime() {
        return this.totalBlockedTime;
    }

    @JsonProperty
    public boolean isFullyBlocked() {
        return this.fullyBlocked;
    }

    @JsonProperty
    public Set<BlockedReason> getBlockedReasons() {
        return this.blockedReasons;
    }

    @JsonProperty
    public long getTotalAllocationInBytes() {
        return this.totalAllocationInBytes;
    }

    @JsonProperty
    public long getRawInputDataSizeInBytes() {
        return this.rawInputDataSizeInBytes;
    }

    @JsonProperty
    public long getRawInputPositions() {
        return this.rawInputPositions;
    }

    @JsonProperty
    public long getProcessedInputDataSizeInBytes() {
        return this.processedInputDataSizeInBytes;
    }

    @JsonProperty
    public long getProcessedInputPositions() {
        return this.processedInputPositions;
    }

    @JsonProperty
    public long getBufferedDataSizeInBytes() {
        return this.bufferedDataSizeInBytes;
    }

    @JsonProperty
    public long getOutputDataSizeInBytes() {
        return this.outputDataSizeInBytes;
    }

    @JsonProperty
    public long getOutputPositions() {
        return this.outputPositions;
    }

    @JsonProperty
    public long getPhysicalWrittenDataSizeInBytes() {
        return this.physicalWrittenDataSizeInBytes;
    }

    @JsonProperty
    public StageGcStatistics getGcInfo() {
        return this.gcInfo;
    }

    @JsonProperty
    public List<OperatorStats> getOperatorSummaries() {
        return this.operatorSummaries;
    }

    @JsonProperty
    public RuntimeStats getRuntimeStats() {
        return this.runtimeStats;
    }

    public BasicStageExecutionStats toBasicStageStats(StageExecutionState stageExecutionState) {
        boolean isScheduled = stageExecutionState == StageExecutionState.RUNNING || stageExecutionState.isDone();
        OptionalDouble progressPercentage = OptionalDouble.empty();
        if (isScheduled && this.totalDrivers != 0) {
            progressPercentage = OptionalDouble.of(Math.min(100.0, (double)this.completedDrivers * 100.0 / (double)this.totalDrivers));
        }
        return new BasicStageExecutionStats(isScheduled, this.totalDrivers, this.queuedDrivers, this.runningDrivers, this.completedDrivers, this.totalNewDrivers, this.queuedNewDrivers, this.runningNewDrivers, this.completedNewDrivers, this.totalSplits, this.queuedSplits, this.runningSplits, this.completedSplits, this.rawInputDataSizeInBytes, this.rawInputPositions, this.cumulativeUserMemory, this.cumulativeTotalMemory, this.userMemoryReservationInBytes, this.totalMemoryReservationInBytes, this.totalCpuTime, this.totalScheduledTime, this.fullyBlocked, this.blockedReasons, this.totalAllocationInBytes, progressPercentage);
    }

    public static StageExecutionStats zero(int stageId) {
        return new StageExecutionStats(0L, new Distribution().snapshot(), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0, 0.0, 0L, 0L, 0L, 0L, new Duration(0.0, TimeUnit.NANOSECONDS), new Duration(0.0, TimeUnit.NANOSECONDS), new Duration(0.0, TimeUnit.NANOSECONDS), new Duration(0.0, TimeUnit.NANOSECONDS), false, (Set<BlockedReason>)ImmutableSet.of(), 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, new StageGcStatistics(stageId, 0, 0, 0, 0, 0, 0, 0), (List<OperatorStats>)ImmutableList.of(), new RuntimeStats());
    }
}

