/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.stats.Distribution;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.RuntimeUnit;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.StageExecutionId;
import com.facebook.presto.execution.StageExecutionState;
import com.facebook.presto.execution.StageExecutionStats;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.PipelineStats;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.spi.eventlistener.StageGcStatistics;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class StageExecutionInfo {
    private final StageExecutionState state;
    private final StageExecutionStats stats;
    private final List<TaskInfo> tasks;
    private final Optional<ExecutionFailureInfo> failureCause;

    public static StageExecutionInfo create(StageExecutionId stageExecutionId, StageExecutionState state, Optional<ExecutionFailureInfo> failureInfo, List<TaskInfo> taskInfos, long schedulingCompleteInMillis, Distribution.DistributionSnapshot getSplitDistribution, RuntimeStats stageRuntimeStats, long peakUserMemoryReservation, long peakNodeTotalMemoryReservation, int finishedLifespans, int totalLifespans) {
        TaskStatsAggregator taskStatsAggregator = new TaskStatsAggregator(taskInfos.size(), stageRuntimeStats);
        for (TaskInfo taskInfo : taskInfos) {
            TaskState taskState = taskInfo.getTaskStatus().getState();
            if (taskState.isDone()) {
                taskStatsAggregator.increaseCompleteTaskCount(1);
            } else {
                taskStatsAggregator.increaseRunningTaskCount(1);
            }
            TaskStats taskStats = taskInfo.getStats();
            if (state == StageExecutionState.FINISHED && taskInfo.getTaskStatus().getState() == TaskState.FAILED) {
                taskStatsAggregator.increaseRetriedCpuTime(taskStats.getTotalCpuTimeInNanos());
            }
            if (!taskState.isDone()) {
                taskStatsAggregator.updateFullyBlocked(taskStats.isFullyBlocked());
                taskStatsAggregator.addNewBlockedReasons(taskStats.getBlockedReasons());
            }
            taskStatsAggregator.increaseBufferedDataSize(taskInfo.getOutputBuffers().getTotalBufferedBytes());
            taskStatsAggregator.processTaskStats(taskStats);
        }
        StageExecutionStats stageExecutionStats = new StageExecutionStats(schedulingCompleteInMillis, getSplitDistribution, taskStatsAggregator.totalTaskCount, taskStatsAggregator.runningTaskCount, taskStatsAggregator.completedTaskCount, totalLifespans, finishedLifespans, taskStatsAggregator.totalDrivers, taskStatsAggregator.queuedDrivers, taskStatsAggregator.runningDrivers, taskStatsAggregator.blockedDrivers, taskStatsAggregator.completedDrivers, taskStatsAggregator.totalNewDrivers, taskStatsAggregator.queuedNewDrivers, taskStatsAggregator.runningNewDrivers, taskStatsAggregator.completedNewDrivers, taskStatsAggregator.totalSplits, taskStatsAggregator.queuedSplits, taskStatsAggregator.runningSplits, taskStatsAggregator.completedSplits, taskStatsAggregator.cumulativeUserMemory, taskStatsAggregator.cumulativeTotalMemory, taskStatsAggregator.userMemoryReservation, taskStatsAggregator.totalMemoryReservation, peakUserMemoryReservation, peakNodeTotalMemoryReservation, Duration.succinctDuration((double)taskStatsAggregator.totalScheduledTime, (TimeUnit)TimeUnit.NANOSECONDS), Duration.succinctDuration((double)taskStatsAggregator.totalCpuTime, (TimeUnit)TimeUnit.NANOSECONDS), Duration.succinctDuration((double)taskStatsAggregator.retriedCpuTime, (TimeUnit)TimeUnit.NANOSECONDS), Duration.succinctDuration((double)taskStatsAggregator.totalBlockedTime, (TimeUnit)TimeUnit.NANOSECONDS), taskStatsAggregator.fullyBlocked && taskStatsAggregator.runningTaskCount > 0, taskStatsAggregator.blockedReasons, taskStatsAggregator.totalAllocation, taskStatsAggregator.rawInputDataSize, taskStatsAggregator.rawInputPositions, taskStatsAggregator.processedInputDataSize, taskStatsAggregator.processedInputPositions, taskStatsAggregator.bufferedDataSize, taskStatsAggregator.outputDataSize, taskStatsAggregator.outputPositions, taskStatsAggregator.physicalWrittenDataSize, new StageGcStatistics(stageExecutionId.getStageId().getId(), stageExecutionId.getId(), taskStatsAggregator.totalTaskCount, taskStatsAggregator.fullGcTaskCount, taskStatsAggregator.minFullGcSec, taskStatsAggregator.maxFullGcSec, taskStatsAggregator.totalFullGcSec, (int)(1.0 * (double)taskStatsAggregator.totalFullGcSec / (double)taskStatsAggregator.fullGcCount)), taskStatsAggregator.getOperatorSummaries(), taskStatsAggregator.getMergedRuntimeStats());
        return new StageExecutionInfo(state, stageExecutionStats, taskInfos, failureInfo);
    }

    @JsonCreator
    public StageExecutionInfo(@JsonProperty(value="state") StageExecutionState state, @JsonProperty(value="stats") StageExecutionStats stats, @JsonProperty(value="tasks") List<TaskInfo> tasks, @JsonProperty(value="failureCause") Optional<ExecutionFailureInfo> failureCause) {
        this.state = Objects.requireNonNull(state, "state is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.tasks = ImmutableList.copyOf((Collection)Objects.requireNonNull(tasks, "tasks is null"));
        this.failureCause = Objects.requireNonNull(failureCause, "failureCause is null");
    }

    @JsonProperty
    public StageExecutionState getState() {
        return this.state;
    }

    @JsonProperty
    public StageExecutionStats getStats() {
        return this.stats;
    }

    @JsonProperty
    public List<TaskInfo> getTasks() {
        return this.tasks;
    }

    @JsonProperty
    public Optional<ExecutionFailureInfo> getFailureCause() {
        return this.failureCause;
    }

    public boolean isFinal() {
        return this.state.isDone() && this.tasks.stream().allMatch(taskInfo -> taskInfo.getTaskStatus().getState().isDone());
    }

    private static class TaskStatsAggregator {
        private final int totalTaskCount;
        private int runningTaskCount;
        private int completedTaskCount;
        private long retriedCpuTime;
        private long bufferedDataSize;
        private boolean fullyBlocked = true;
        private final Set<BlockedReason> blockedReasons = new HashSet<BlockedReason>();
        private int totalDrivers;
        private int queuedDrivers;
        private int runningDrivers;
        private int blockedDrivers;
        private int completedDrivers;
        private int totalNewDrivers;
        private int queuedNewDrivers;
        private int runningNewDrivers;
        private int completedNewDrivers;
        private int totalSplits;
        private int queuedSplits;
        private int runningSplits;
        private int completedSplits;
        private double cumulativeUserMemory;
        private double cumulativeTotalMemory;
        private long userMemoryReservation;
        private long totalMemoryReservation;
        private long totalScheduledTime;
        private long totalCpuTime;
        private long totalBlockedTime;
        private long totalAllocation;
        private long rawInputDataSize;
        private long rawInputPositions;
        private long processedInputDataSize;
        private long processedInputPositions;
        private long outputDataSize;
        private long outputPositions;
        private long physicalWrittenDataSize;
        private int fullGcCount;
        private int fullGcTaskCount;
        private int minFullGcSec;
        private int maxFullGcSec;
        private int totalFullGcSec;
        private final RuntimeStats mergedRuntimeStats = new RuntimeStats();
        private final Map<OperatorKey, List<OperatorStats>> operatorStatsByKey = new HashMap<OperatorKey, List<OperatorStats>>();

        public TaskStatsAggregator(int totalTaskCount, RuntimeStats stageRuntimeStats) {
            this.totalTaskCount = totalTaskCount;
            this.mergedRuntimeStats.mergeWith(stageRuntimeStats);
        }

        public void processTaskStats(TaskStats taskStats) {
            this.totalDrivers += taskStats.getTotalDrivers();
            this.queuedDrivers += taskStats.getQueuedDrivers();
            this.runningDrivers += taskStats.getRunningDrivers();
            this.blockedDrivers += taskStats.getBlockedDrivers();
            this.completedDrivers += taskStats.getCompletedDrivers();
            this.totalNewDrivers += taskStats.getTotalNewDrivers();
            this.queuedNewDrivers += taskStats.getQueuedNewDrivers();
            this.runningNewDrivers += taskStats.getRunningNewDrivers();
            this.completedNewDrivers += taskStats.getCompletedNewDrivers();
            this.totalSplits += taskStats.getTotalSplits();
            this.queuedSplits += taskStats.getQueuedSplits();
            this.runningSplits += taskStats.getRunningSplits();
            this.completedSplits += taskStats.getCompletedSplits();
            this.cumulativeUserMemory += taskStats.getCumulativeUserMemory();
            this.cumulativeTotalMemory += taskStats.getCumulativeTotalMemory();
            long taskUserMemory = taskStats.getUserMemoryReservationInBytes();
            long taskSystemMemory = taskStats.getSystemMemoryReservationInBytes();
            this.userMemoryReservation += taskUserMemory;
            this.totalMemoryReservation += taskUserMemory + taskSystemMemory;
            this.totalScheduledTime += taskStats.getTotalScheduledTimeInNanos();
            this.totalCpuTime += taskStats.getTotalCpuTimeInNanos();
            this.totalBlockedTime += taskStats.getTotalBlockedTimeInNanos();
            this.totalAllocation += taskStats.getTotalAllocationInBytes();
            this.rawInputDataSize += taskStats.getRawInputDataSizeInBytes();
            this.rawInputPositions += taskStats.getRawInputPositions();
            this.processedInputDataSize += taskStats.getProcessedInputDataSizeInBytes();
            this.processedInputPositions += taskStats.getProcessedInputPositions();
            this.outputDataSize += taskStats.getOutputDataSizeInBytes();
            this.outputPositions += taskStats.getOutputPositions();
            this.physicalWrittenDataSize += taskStats.getPhysicalWrittenDataSizeInBytes();
            this.fullGcCount += taskStats.getFullGcCount();
            this.fullGcTaskCount += taskStats.getFullGcCount() > 0 ? 1 : 0;
            int gcSec = Math.toIntExact(TimeUnit.MILLISECONDS.toSeconds(taskStats.getFullGcTimeInMillis()));
            this.totalFullGcSec += gcSec;
            this.minFullGcSec = Math.min(this.minFullGcSec, gcSec);
            this.maxFullGcSec = Math.max(this.maxFullGcSec, gcSec);
            this.updateOperatorStats(taskStats);
            this.updateRuntimeStats(taskStats);
        }

        private void updateOperatorStats(TaskStats taskStats) {
            for (PipelineStats pipeline : taskStats.getPipelines()) {
                for (OperatorStats operatorStats : pipeline.getOperatorSummaries()) {
                    this.operatorStatsByKey.computeIfAbsent(new OperatorKey(pipeline.getPipelineId(), operatorStats.getOperatorId()), k -> new ArrayList()).add(operatorStats);
                }
            }
        }

        private void updateRuntimeStats(TaskStats taskStats) {
            this.mergedRuntimeStats.mergeWith(taskStats.getRuntimeStats());
            this.mergedRuntimeStats.addMetricValue("driverCountPerTask", RuntimeUnit.NONE, (long)taskStats.getTotalDrivers());
            this.mergedRuntimeStats.addMetricValue("taskElapsedTimeNanos", RuntimeUnit.NANO, taskStats.getElapsedTimeInNanos());
            this.mergedRuntimeStats.addMetricValueIgnoreZero("taskQueuedTimeNanos", RuntimeUnit.NANO, taskStats.getQueuedTimeInNanos());
            this.mergedRuntimeStats.addMetricValue("taskScheduledTimeNanos", RuntimeUnit.NANO, taskStats.getTotalScheduledTimeInNanos());
            this.mergedRuntimeStats.addMetricValueIgnoreZero("taskBlockedTimeNanos", RuntimeUnit.NANO, taskStats.getTotalBlockedTimeInNanos());
        }

        public RuntimeStats getMergedRuntimeStats() {
            return this.mergedRuntimeStats;
        }

        public List<OperatorStats> getOperatorSummaries() {
            return (List)this.operatorStatsByKey.values().stream().map(OperatorStats::merge).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
        }

        public void increaseRunningTaskCount(int count) {
            this.runningTaskCount += count;
        }

        public void increaseCompleteTaskCount(int count) {
            this.completedTaskCount += count;
        }

        public void increaseRetriedCpuTime(long time) {
            this.retriedCpuTime += time;
        }

        public void updateFullyBlocked(boolean blocked) {
            this.fullyBlocked &= blocked;
        }

        public void addNewBlockedReasons(Set<BlockedReason> reasons) {
            this.blockedReasons.addAll(reasons);
        }

        public void increaseBufferedDataSize(long bytes) {
            this.bufferedDataSize += bytes;
        }
    }

    private static class OperatorKey {
        private final int pipelineId;
        private final int operatorId;

        public OperatorKey(int pipelineId, int operatorId) {
            this.pipelineId = pipelineId;
            this.operatorId = operatorId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OperatorKey that = (OperatorKey)o;
            return this.pipelineId == that.pipelineId && this.operatorId == that.operatorId;
        }

        public int hashCode() {
            return Objects.hash(this.pipelineId, this.operatorId);
        }
    }
}

