/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.concurrent.SetThreadName;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.event.SplitMonitor;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.ScheduledSplit;
import com.facebook.presto.execution.SplitRunner;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskSource;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.execution.buffer.BufferState;
import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.execution.executor.TaskExecutor;
import com.facebook.presto.execution.executor.TaskHandle;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.DriverStats;
import com.facebook.presto.operator.PipelineContext;
import com.facebook.presto.operator.PipelineExecutionStrategy;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.SplitWeight;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.StageExecutionDescriptor;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.Duration;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

public class SqlTaskExecution {
    private final TaskId taskId;
    private final TaskStateMachine taskStateMachine;
    private final TaskContext taskContext;
    private final OutputBuffer outputBuffer;
    private final TaskHandle taskHandle;
    private final TaskExecutor taskExecutor;
    private final Executor notificationExecutor;
    private final SplitMonitor splitMonitor;
    private final List<WeakReference<Driver>> drivers = new CopyOnWriteArrayList<WeakReference<Driver>>();
    private final Map<PlanNodeId, DriverSplitRunnerFactory> driverRunnerFactoriesWithSplitLifeCycle;
    private final List<DriverSplitRunnerFactory> driverRunnerFactoriesWithDriverGroupLifeCycle;
    private final List<DriverSplitRunnerFactory> driverRunnerFactoriesWithTaskLifeCycle;
    @GuardedBy(value="this")
    private final ConcurrentMap<PlanNodeId, TaskSource> remoteSources = new ConcurrentHashMap<PlanNodeId, TaskSource>();
    @GuardedBy(value="this")
    private long maxAcknowledgedSplit = Long.MIN_VALUE;
    @GuardedBy(value="this")
    private final SchedulingLifespanManager schedulingLifespanManager;
    @GuardedBy(value="this")
    private final Map<PlanNodeId, PendingSplitsForPlanNode> pendingSplitsByPlanNode;
    private final Status status;

    static SqlTaskExecution createSqlTaskExecution(TaskStateMachine taskStateMachine, TaskContext taskContext, OutputBuffer outputBuffer, List<TaskSource> sources, LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan, TaskExecutor taskExecutor, Executor notificationExecutor, SplitMonitor queryMonitor) {
        SqlTaskExecution task = new SqlTaskExecution(taskStateMachine, taskContext, outputBuffer, localExecutionPlan, taskExecutor, queryMonitor, notificationExecutor);
        try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{task.getTaskId()});){
            task.scheduleDriversForTaskLifeCycle();
            task.addSources(sources);
            SqlTaskExecution sqlTaskExecution = task;
            return sqlTaskExecution;
        }
    }

    private SqlTaskExecution(TaskStateMachine taskStateMachine, TaskContext taskContext, OutputBuffer outputBuffer, LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan, TaskExecutor taskExecutor, SplitMonitor splitMonitor, Executor notificationExecutor) {
        this.taskStateMachine = Objects.requireNonNull(taskStateMachine, "taskStateMachine is null");
        this.taskId = taskStateMachine.getTaskId();
        this.taskContext = Objects.requireNonNull(taskContext, "taskContext is null");
        this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
        this.taskExecutor = Objects.requireNonNull(taskExecutor, "driverExecutor is null");
        this.notificationExecutor = Objects.requireNonNull(notificationExecutor, "notificationExecutor is null");
        this.splitMonitor = Objects.requireNonNull(splitMonitor, "splitMonitor is null");
        try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{this.taskId});){
            ImmutableSet tableScanSources = ImmutableSet.copyOf(localExecutionPlan.getTableScanSourceOrder());
            ImmutableMap.Builder driverRunnerFactoriesWithSplitLifeCycle = ImmutableMap.builder();
            ImmutableList.Builder driverRunnerFactoriesWithTaskLifeCycle = ImmutableList.builder();
            ImmutableList.Builder driverRunnerFactoriesWithDriverGroupLifeCycle = ImmutableList.builder();
            block9: for (DriverFactory driverFactory : localExecutionPlan.getDriverFactories()) {
                Optional<PlanNodeId> sourceId = driverFactory.getSourceId();
                if (sourceId.isPresent() && tableScanSources.contains(sourceId.get())) {
                    driverRunnerFactoriesWithSplitLifeCycle.put((Object)sourceId.get(), (Object)new DriverSplitRunnerFactory(driverFactory, true));
                    continue;
                }
                switch (driverFactory.getPipelineExecutionStrategy()) {
                    case GROUPED_EXECUTION: {
                        driverRunnerFactoriesWithDriverGroupLifeCycle.add((Object)new DriverSplitRunnerFactory(driverFactory, false));
                        continue block9;
                    }
                    case UNGROUPED_EXECUTION: {
                        driverRunnerFactoriesWithTaskLifeCycle.add((Object)new DriverSplitRunnerFactory(driverFactory, false));
                        continue block9;
                    }
                }
                throw new UnsupportedOperationException();
            }
            this.driverRunnerFactoriesWithSplitLifeCycle = driverRunnerFactoriesWithSplitLifeCycle.build();
            this.driverRunnerFactoriesWithDriverGroupLifeCycle = driverRunnerFactoriesWithDriverGroupLifeCycle.build();
            this.driverRunnerFactoriesWithTaskLifeCycle = driverRunnerFactoriesWithTaskLifeCycle.build();
            this.pendingSplitsByPlanNode = (Map)this.driverRunnerFactoriesWithSplitLifeCycle.keySet().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), ignore -> new PendingSplitsForPlanNode()));
            this.status = new Status(taskContext, outputBuffer, (Map)localExecutionPlan.getDriverFactories().stream().collect(ImmutableMap.toImmutableMap(DriverFactory::getPipelineId, DriverFactory::getPipelineExecutionStrategy)));
            this.schedulingLifespanManager = new SchedulingLifespanManager(localExecutionPlan.getTableScanSourceOrder(), localExecutionPlan.getStageExecutionDescriptor(), this.status);
            Preconditions.checkArgument((boolean)this.driverRunnerFactoriesWithSplitLifeCycle.keySet().equals(tableScanSources), (Object)"Fragment is partitioned, but not all partitioned drivers were found");
            for (Map.Entry entry : this.driverRunnerFactoriesWithSplitLifeCycle.entrySet()) {
                PlanNodeId planNodeId = (PlanNodeId)entry.getKey();
                DriverSplitRunnerFactory driverSplitRunnerFactory = (DriverSplitRunnerFactory)entry.getValue();
                if (driverSplitRunnerFactory.getPipelineExecutionStrategy() != PipelineExecutionStrategy.UNGROUPED_EXECUTION) continue;
                this.schedulingLifespanManager.addLifespanIfAbsent(Lifespan.taskWide());
                this.pendingSplitsByPlanNode.get(planNodeId).getLifespan(Lifespan.taskWide());
            }
            this.taskHandle = !taskStateMachine.getState().isDone() ? SqlTaskExecution.createTaskHandle(taskStateMachine, taskContext, outputBuffer, localExecutionPlan, taskExecutor) : null;
            outputBuffer.addStateChangeListener(new CheckTaskCompletionOnBufferFinish(this));
            outputBuffer.registerLifespanCompletionCallback(x$0 -> this.status.checkLifespanCompletion(x$0));
        }
    }

    private static TaskHandle createTaskHandle(TaskStateMachine taskStateMachine, TaskContext taskContext, OutputBuffer outputBuffer, LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan, TaskExecutor taskExecutor) {
        TaskHandle taskHandle = taskExecutor.addTask(taskStateMachine.getTaskId(), outputBuffer::getUtilization, SystemSessionProperties.getInitialSplitsPerNode(taskContext.getSession()), SystemSessionProperties.getSplitConcurrencyAdjustmentInterval(taskContext.getSession()), SystemSessionProperties.getMaxDriversPerTask(taskContext.getSession()));
        taskStateMachine.addStateChangeListener(state -> {
            if (state.isDone()) {
                taskExecutor.removeTask(taskHandle);
                for (DriverFactory factory : localExecutionPlan.getDriverFactories()) {
                    factory.noMoreDrivers();
                }
            }
        });
        return taskHandle;
    }

    public TaskId getTaskId() {
        return this.taskId;
    }

    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    public void addSources(List<TaskSource> sources) {
        Objects.requireNonNull(sources, "sources is null");
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (String)"Can not add sources while holding a lock on the %s", (Object)this.getClass().getSimpleName());
        try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{this.taskId});){
            Map<PlanNodeId, TaskSource> updatedRemoteSources = this.updateSources(sources);
            for (WeakReference<Driver> driverReference : this.drivers) {
                TaskSource sourceUpdate;
                Driver driver = (Driver)driverReference.get();
                if (driver == null) {
                    this.drivers.remove(driverReference);
                    continue;
                }
                Optional<PlanNodeId> sourceId = driver.getSourceId();
                if (!sourceId.isPresent() || (sourceUpdate = updatedRemoteSources.get(sourceId.get())) == null) continue;
                driver.updateSource(sourceUpdate);
            }
            this.checkTaskCompletion();
        }
    }

    private synchronized Map<PlanNodeId, TaskSource> updateSources(List<TaskSource> sources) {
        HashMap<PlanNodeId, TaskSource> updatedRemoteSources = new HashMap<PlanNodeId, TaskSource>();
        long currentMaxAcknowledgedSplit = this.maxAcknowledgedSplit;
        sources = sources.stream().map(source -> new TaskSource(source.getPlanNodeId(), source.getSplits().stream().filter(scheduledSplit -> scheduledSplit.getSequenceId() > currentMaxAcknowledgedSplit).collect(Collectors.toSet()), source.getNoMoreSplitsForLifespan(), source.isNoMoreSplits())).collect(Collectors.toList());
        for (TaskSource source2 : sources) {
            if (this.driverRunnerFactoriesWithSplitLifeCycle.containsKey(source2.getPlanNodeId())) {
                this.scheduleTableScanSource(source2);
                continue;
            }
            this.scheduleRemoteSource(source2, updatedRemoteSources);
        }
        for (DriverSplitRunnerFactory driverSplitRunnerFactory : Iterables.concat(this.driverRunnerFactoriesWithSplitLifeCycle.values(), this.driverRunnerFactoriesWithTaskLifeCycle, this.driverRunnerFactoriesWithDriverGroupLifeCycle)) {
            driverSplitRunnerFactory.closeDriverFactoryIfFullyCreated();
        }
        this.maxAcknowledgedSplit = sources.stream().flatMap(source -> source.getSplits().stream()).mapToLong(ScheduledSplit::getSequenceId).max().orElse(this.maxAcknowledgedSplit);
        return updatedRemoteSources;
    }

    @GuardedBy(value="this")
    private void mergeIntoPendingSplits(PlanNodeId planNodeId, Set<ScheduledSplit> scheduledSplits, Set<Lifespan> noMoreSplitsForLifespan, boolean noMoreSplits) {
        this.checkHoldsLock();
        DriverSplitRunnerFactory partitionedDriverFactory = this.driverRunnerFactoriesWithSplitLifeCycle.get(planNodeId);
        PendingSplitsForPlanNode pendingSplitsForPlanNode = this.pendingSplitsByPlanNode.get(planNodeId);
        partitionedDriverFactory.splitsAdded(scheduledSplits.size(), SplitWeight.rawValueSum(scheduledSplits, scheduledSplit -> scheduledSplit.getSplit().getSplitWeight()));
        for (ScheduledSplit scheduledSplit2 : scheduledSplits) {
            Lifespan lifespan = scheduledSplit2.getSplit().getLifespan();
            this.checkLifespan(partitionedDriverFactory.getPipelineExecutionStrategy(), lifespan);
            pendingSplitsForPlanNode.getLifespan(lifespan).addSplit(scheduledSplit2);
            this.schedulingLifespanManager.addLifespanIfAbsent(lifespan);
        }
        for (Lifespan lifespanWithNoMoreSplits : noMoreSplitsForLifespan) {
            this.checkLifespan(partitionedDriverFactory.getPipelineExecutionStrategy(), lifespanWithNoMoreSplits);
            pendingSplitsForPlanNode.getLifespan(lifespanWithNoMoreSplits).noMoreSplits();
            this.schedulingLifespanManager.addLifespanIfAbsent(lifespanWithNoMoreSplits);
        }
        if (noMoreSplits) {
            pendingSplitsForPlanNode.setNoMoreSplits();
        }
    }

    private synchronized void scheduleTableScanSource(TaskSource sourceUpdate) {
        boolean madeProgress;
        this.mergeIntoPendingSplits(sourceUpdate.getPlanNodeId(), sourceUpdate.getSplits(), sourceUpdate.getNoMoreSplitsForLifespan(), sourceUpdate.isNoMoreSplits());
        do {
            Iterator<SchedulingLifespan> activeLifespans = this.schedulingLifespanManager.getActiveLifespans();
            madeProgress = false;
            block1: while (activeLifespans.hasNext()) {
                Optional<PlanNodeId> optionalSchedulingPlanNode;
                SchedulingLifespan schedulingLifespan = activeLifespans.next();
                Lifespan lifespan = schedulingLifespan.getLifespan();
                while ((optionalSchedulingPlanNode = schedulingLifespan.getSchedulingPlanNode()).isPresent()) {
                    PlanNodeId schedulingPlanNode = optionalSchedulingPlanNode.get();
                    DriverSplitRunnerFactory partitionedDriverRunnerFactory = this.driverRunnerFactoriesWithSplitLifeCycle.get(schedulingPlanNode);
                    PendingSplits pendingSplits = this.pendingSplitsByPlanNode.get(schedulingPlanNode).getLifespan(lifespan);
                    if (!lifespan.isTaskWide() && !schedulingLifespan.getAndSetDriversForDriverGroupLifeCycleScheduled()) {
                        this.scheduleDriversForDriverGroupLifeCycle(lifespan);
                    }
                    ImmutableList.Builder runners = ImmutableList.builder();
                    for (ScheduledSplit scheduledSplit : pendingSplits.removeAllSplits()) {
                        runners.add((Object)partitionedDriverRunnerFactory.createDriverRunner(scheduledSplit, lifespan));
                    }
                    this.enqueueDriverSplitRunner(false, (List<DriverSplitRunner>)runners.build());
                    if (pendingSplits.getState() != SplitsState.NO_MORE_SPLITS) continue block1;
                    partitionedDriverRunnerFactory.noMoreDriverRunner((Iterable<Lifespan>)ImmutableList.of((Object)lifespan));
                    pendingSplits.markAsCleanedUp();
                    schedulingLifespan.nextPlanNode();
                    madeProgress = true;
                    if (!schedulingLifespan.isDone()) continue;
                    continue block1;
                }
            }
        } while (madeProgress);
        if (sourceUpdate.isNoMoreSplits()) {
            this.schedulingLifespanManager.noMoreSplits(sourceUpdate.getPlanNodeId());
        }
    }

    private synchronized void scheduleRemoteSource(TaskSource sourceUpdate, Map<PlanNodeId, TaskSource> updatedRemoteSources) {
        TaskSource currentSource = (TaskSource)this.remoteSources.get(sourceUpdate.getPlanNodeId());
        TaskSource newSource = currentSource == null ? sourceUpdate : currentSource.update(sourceUpdate);
        if (newSource != currentSource) {
            this.remoteSources.put(sourceUpdate.getPlanNodeId(), newSource);
            updatedRemoteSources.put(sourceUpdate.getPlanNodeId(), newSource);
        }
    }

    private void scheduleDriversForTaskLifeCycle() {
        ArrayList<DriverSplitRunner> runners = new ArrayList<DriverSplitRunner>();
        for (DriverSplitRunnerFactory driverRunnerFactory : this.driverRunnerFactoriesWithTaskLifeCycle) {
            for (int i = 0; i < driverRunnerFactory.getDriverInstances().orElse(1); ++i) {
                runners.add(driverRunnerFactory.createDriverRunner(null, Lifespan.taskWide()));
            }
        }
        this.enqueueDriverSplitRunner(true, runners);
        for (DriverSplitRunnerFactory driverRunnerFactory : this.driverRunnerFactoriesWithTaskLifeCycle) {
            driverRunnerFactory.noMoreDriverRunner((Iterable<Lifespan>)ImmutableList.of((Object)Lifespan.taskWide()));
            Verify.verify((boolean)driverRunnerFactory.isNoMoreDriverRunner());
        }
    }

    private void scheduleDriversForDriverGroupLifeCycle(Lifespan lifespan) {
        if (lifespan.isTaskWide()) {
            Preconditions.checkArgument((boolean)this.driverRunnerFactoriesWithDriverGroupLifeCycle.isEmpty(), (Object)"Instantiating pipeline of driver group lifecycle at task level is not allowed");
            return;
        }
        ArrayList<DriverSplitRunner> runners = new ArrayList<DriverSplitRunner>();
        for (DriverSplitRunnerFactory driverSplitRunnerFactory : this.driverRunnerFactoriesWithDriverGroupLifeCycle) {
            for (int i = 0; i < driverSplitRunnerFactory.getDriverInstances().orElse(1); ++i) {
                runners.add(driverSplitRunnerFactory.createDriverRunner(null, lifespan));
            }
        }
        this.enqueueDriverSplitRunner(true, runners);
        for (DriverSplitRunnerFactory driverRunnerFactory : this.driverRunnerFactoriesWithDriverGroupLifeCycle) {
            driverRunnerFactory.noMoreDriverRunner((Iterable<Lifespan>)ImmutableList.of((Object)lifespan));
        }
    }

    private synchronized void enqueueDriverSplitRunner(boolean forceRunSplit, List<DriverSplitRunner> runners) {
        List<ListenableFuture<?>> finishedFutures = this.taskExecutor.enqueueSplits(this.taskHandle, forceRunSplit, runners);
        Preconditions.checkState((finishedFutures.size() == runners.size() ? 1 : 0) != 0, (String)"Expected %s futures but got %s", (int)runners.size(), (int)finishedFutures.size());
        for (int i = 0; i < finishedFutures.size(); ++i) {
            ListenableFuture<?> finishedFuture = finishedFutures.get(i);
            final DriverSplitRunner splitRunner = runners.get(i);
            this.status.incrementRemainingDriver(splitRunner.getLifespan());
            Futures.addCallback(finishedFuture, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(Object result) {
                    try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{SqlTaskExecution.this.taskId});){
                        SqlTaskExecution.this.status.decrementRemainingDriver(splitRunner.getLifespan());
                        SqlTaskExecution.this.checkTaskCompletion();
                        SqlTaskExecution.this.splitMonitor.splitCompletedEvent(SqlTaskExecution.this.taskId, this.getDriverStats());
                    }
                }

                public void onFailure(Throwable cause) {
                    try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{SqlTaskExecution.this.taskId});){
                        SqlTaskExecution.this.taskStateMachine.failed(cause);
                        SqlTaskExecution.this.status.decrementRemainingDriver(splitRunner.getLifespan());
                        SqlTaskExecution.this.splitMonitor.splitFailedEvent(SqlTaskExecution.this.taskId, this.getDriverStats(), cause);
                    }
                }

                private DriverStats getDriverStats() {
                    DriverContext driverContext = splitRunner.getDriverContext();
                    DriverStats driverStats = driverContext != null ? driverContext.getDriverStats() : new DriverStats();
                    return driverStats;
                }
            }, (Executor)this.notificationExecutor);
        }
    }

    public synchronized Set<PlanNodeId> getNoMoreSplits() {
        ImmutableSet.Builder noMoreSplits = ImmutableSet.builder();
        for (Map.Entry<PlanNodeId, DriverSplitRunnerFactory> entry : this.driverRunnerFactoriesWithSplitLifeCycle.entrySet()) {
            if (!entry.getValue().isNoMoreDriverRunner()) continue;
            noMoreSplits.add((Object)entry.getKey());
        }
        for (TaskSource taskSource : this.remoteSources.values()) {
            if (!taskSource.isNoMoreSplits()) continue;
            noMoreSplits.add((Object)taskSource.getPlanNodeId());
        }
        return noMoreSplits.build();
    }

    private synchronized void checkTaskCompletion() {
        if (this.taskStateMachine.getState().isDone()) {
            return;
        }
        for (DriverSplitRunnerFactory driverSplitRunnerFactory : this.driverRunnerFactoriesWithSplitLifeCycle.values()) {
            if (driverSplitRunnerFactory.isNoMoreDriverRunner()) continue;
            return;
        }
        if (this.status.getRemainingDriver() != 0) {
            return;
        }
        this.outputBuffer.setNoMorePages();
        if (!this.outputBuffer.isFinished()) {
            return;
        }
        this.taskStateMachine.finished();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("taskId", (Object)this.taskId).add("remainingDrivers", this.status.getRemainingDriver()).add("remoteSources", this.remoteSources).toString();
    }

    private void checkLifespan(PipelineExecutionStrategy executionStrategy, Lifespan lifespan) {
        switch (executionStrategy) {
            case GROUPED_EXECUTION: {
                Preconditions.checkArgument((!lifespan.isTaskWide() ? 1 : 0) != 0, (Object)"Expect driver-group life cycle for grouped ExecutionStrategy. Got task-wide life cycle.");
                break;
            }
            case UNGROUPED_EXECUTION: {
                Preconditions.checkArgument((boolean)lifespan.isTaskWide(), (Object)"Expect task-wide life cycle for ungrouped ExecutionStrategy. Got driver-group life cycle.");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown executionStrategy: " + (Object)((Object)executionStrategy));
            }
        }
    }

    private void checkHoldsLock() {
        if (!Thread.holdsLock(this)) {
            throw new IllegalStateException(String.format("Thread must hold a lock on the %s", this.getClass().getSimpleName()));
        }
    }

    @ThreadSafe
    private static class Status {
        private final TaskContext taskContext;
        private final OutputBuffer outputBuffer;
        @GuardedBy(value="this")
        private final int pipelineWithTaskLifeCycleCount;
        @GuardedBy(value="this")
        private final int pipelineWithDriverGroupLifeCycleCount;
        @GuardedBy(value="this")
        private final Map<Integer, Map<Lifespan, PerPipelineAndLifespanStatus>> perPipelineAndLifespan;
        @GuardedBy(value="this")
        private final Map<Integer, PerPipelineStatus> perPipeline;
        @GuardedBy(value="this")
        private final Map<Lifespan, PerLifespanStatus> perLifespan = new HashMap<Lifespan, PerLifespanStatus>();
        @GuardedBy(value="this")
        private int overallRemainingDriver;
        @GuardedBy(value="this")
        private boolean noMoreLifespans;

        public Status(TaskContext taskContext, OutputBuffer outputBuffer, Map<Integer, PipelineExecutionStrategy> pipelineToExecutionStrategy) {
            this.taskContext = Objects.requireNonNull(taskContext, "taskContext is null");
            this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
            int pipelineWithTaskLifeCycleCount = 0;
            int pipelineWithDriverGroupLifeCycleCount = 0;
            ImmutableMap.Builder perPipelineAndLifespan = ImmutableMap.builder();
            ImmutableMap.Builder perPipeline = ImmutableMap.builder();
            block4: for (Map.Entry<Integer, PipelineExecutionStrategy> entry : pipelineToExecutionStrategy.entrySet()) {
                int pipelineId = entry.getKey();
                PipelineExecutionStrategy executionStrategy = entry.getValue();
                perPipelineAndLifespan.put((Object)pipelineId, new HashMap());
                perPipeline.put((Object)pipelineId, (Object)new PerPipelineStatus(executionStrategy));
                switch (executionStrategy) {
                    case UNGROUPED_EXECUTION: {
                        ++pipelineWithTaskLifeCycleCount;
                        continue block4;
                    }
                    case GROUPED_EXECUTION: {
                        ++pipelineWithDriverGroupLifeCycleCount;
                        continue block4;
                    }
                }
                throw new IllegalArgumentException(String.format("Unknown ExecutionStrategy (%s) for pipeline %s.", new Object[]{executionStrategy, pipelineId}));
            }
            this.pipelineWithTaskLifeCycleCount = pipelineWithTaskLifeCycleCount;
            this.pipelineWithDriverGroupLifeCycleCount = pipelineWithDriverGroupLifeCycleCount;
            this.perPipelineAndLifespan = perPipelineAndLifespan.build();
            this.perPipeline = perPipeline.build();
        }

        public synchronized void setNoMoreLifespans() {
            if (this.noMoreLifespans) {
                return;
            }
            this.noMoreLifespans = true;
        }

        public synchronized void setNoMoreDriverRunner(int pipelineId, Lifespan lifespan) {
            if (this.per((int)pipelineId, (Lifespan)lifespan).noMoreDriverRunner) {
                return;
            }
            this.per((int)pipelineId, (Lifespan)lifespan).noMoreDriverRunner = true;
            if (this.per((int)pipelineId, (Lifespan)lifespan).pendingCreation == 0) {
                this.per((int)pipelineId).unacknowledgedLifespansWithNoMoreDrivers.add(lifespan);
            }
            ++this.per((int)pipelineId).lifespansWithNoMoreDriverRunners;
            ++this.per((Lifespan)lifespan).pipelinesWithNoMoreDriverRunners;
            this.checkLifespanCompletion(lifespan);
        }

        public synchronized void incrementPendingCreation(int pipelineId, Lifespan lifespan) {
            Preconditions.checkState((!this.per((int)pipelineId, (Lifespan)lifespan).noMoreDriverRunner ? 1 : 0) != 0, (String)"Cannot increment pendingCreation for Pipeline %s Lifespan %s. NoMoreSplits is set.", (int)pipelineId, (Object)lifespan);
            ++this.per((int)pipelineId, (Lifespan)lifespan).pendingCreation;
            ++this.per((int)pipelineId).pendingCreation;
        }

        public synchronized void decrementPendingCreation(int pipelineId, Lifespan lifespan) {
            Preconditions.checkState((this.per((int)pipelineId, (Lifespan)lifespan).pendingCreation > 0 ? 1 : 0) != 0, (String)"Cannot decrement pendingCreation for Pipeline %s Lifespan %s. Value is 0.", (int)pipelineId, (Object)lifespan);
            --this.per((int)pipelineId, (Lifespan)lifespan).pendingCreation;
            if (this.per((int)pipelineId, (Lifespan)lifespan).pendingCreation == 0 && this.per((int)pipelineId, (Lifespan)lifespan).noMoreDriverRunner) {
                this.per((int)pipelineId).unacknowledgedLifespansWithNoMoreDrivers.add(lifespan);
            }
            --this.per((int)pipelineId).pendingCreation;
        }

        public synchronized void incrementRemainingDriver(Lifespan lifespan) {
            Preconditions.checkState((!this.isNoMoreDriverRunners(lifespan) ? 1 : 0) != 0, (String)"Cannot increment remainingDriver for Lifespan %s. NoMoreSplits is set.", (Object)lifespan);
            ++this.per((Lifespan)lifespan).remainingDriver;
            ++this.overallRemainingDriver;
        }

        public synchronized void decrementRemainingDriver(Lifespan lifespan) {
            Preconditions.checkState((this.per((Lifespan)lifespan).remainingDriver > 0 ? 1 : 0) != 0, (String)"Cannot decrement remainingDriver for Lifespan %s. Value is 0.", (Object)lifespan);
            --this.per((Lifespan)lifespan).remainingDriver;
            --this.overallRemainingDriver;
            this.checkLifespanCompletion(lifespan);
        }

        public synchronized boolean isNoMoreLifespans() {
            return this.noMoreLifespans;
        }

        public synchronized int getPendingCreation(int pipelineId) {
            return this.per((int)pipelineId).pendingCreation;
        }

        public synchronized int getRemainingDriver(Lifespan lifespan) {
            return this.per((Lifespan)lifespan).remainingDriver;
        }

        public synchronized int getRemainingDriver() {
            return this.overallRemainingDriver;
        }

        public synchronized boolean isNoMoreDriverRunners(int pipelineId) {
            int driverGroupCount;
            switch (this.per((int)pipelineId).executionStrategy) {
                case UNGROUPED_EXECUTION: {
                    driverGroupCount = 1;
                    break;
                }
                case GROUPED_EXECUTION: {
                    if (!this.noMoreLifespans) {
                        return false;
                    }
                    driverGroupCount = this.perLifespan.size();
                    if (!this.perLifespan.containsKey(Lifespan.taskWide())) break;
                    --driverGroupCount;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            return this.per((int)pipelineId).lifespansWithNoMoreDriverRunners == driverGroupCount;
        }

        public synchronized boolean isNoMoreDriverRunners(Lifespan lifespan) {
            if (!lifespan.isTaskWide()) {
                return this.per((Lifespan)lifespan).pipelinesWithNoMoreDriverRunners == this.pipelineWithDriverGroupLifeCycleCount;
            }
            return this.per((Lifespan)lifespan).pipelinesWithNoMoreDriverRunners == this.pipelineWithTaskLifeCycleCount;
        }

        public synchronized List<Lifespan> getAndAcknowledgeLifespansWithNoMoreDrivers(int pipelineId) {
            ImmutableList result = ImmutableList.copyOf(this.per((int)pipelineId).unacknowledgedLifespansWithNoMoreDrivers);
            this.per((int)pipelineId).unacknowledgedLifespansWithNoMoreDrivers.clear();
            return result;
        }

        private void checkLifespanCompletion(Lifespan lifespan) {
            if (lifespan.isTaskWide()) {
                return;
            }
            if (!this.isNoMoreDriverRunners(lifespan)) {
                return;
            }
            if (this.getRemainingDriver(lifespan) != 0) {
                return;
            }
            this.outputBuffer.setNoMorePagesForLifespan(lifespan);
            if (!this.taskContext.isLegacyLifespanCompletionCondition() && !this.outputBuffer.isFinishedForLifespan(lifespan)) {
                return;
            }
            this.taskContext.addCompletedDriverGroup(lifespan);
        }

        @GuardedBy(value="this")
        private PerPipelineAndLifespanStatus per(int pipelineId, Lifespan lifespan) {
            return this.perPipelineAndLifespan.get(pipelineId).computeIfAbsent(lifespan, ignored -> new PerPipelineAndLifespanStatus());
        }

        @GuardedBy(value="this")
        private PerPipelineStatus per(int pipelineId) {
            return this.perPipeline.get(pipelineId);
        }

        @GuardedBy(value="this")
        private PerLifespanStatus per(Lifespan lifespan) {
            if (this.perLifespan.containsKey(lifespan)) {
                return this.perLifespan.get(lifespan);
            }
            PerLifespanStatus result = new PerLifespanStatus();
            this.perLifespan.put(lifespan, result);
            return result;
        }
    }

    private class DriverSplitRunnerFactory {
        private final DriverFactory driverFactory;
        private final PipelineContext pipelineContext;
        private boolean closed;

        private DriverSplitRunnerFactory(DriverFactory driverFactory, boolean partitioned) {
            this.driverFactory = driverFactory;
            this.pipelineContext = SqlTaskExecution.this.taskContext.addPipelineContext(driverFactory.getPipelineId(), driverFactory.isInputDriver(), driverFactory.isOutputDriver(), partitioned);
        }

        public DriverSplitRunner createDriverRunner(@Nullable ScheduledSplit partitionedSplit, Lifespan lifespan) {
            SqlTaskExecution.this.checkLifespan(this.driverFactory.getPipelineExecutionStrategy(), lifespan);
            SqlTaskExecution.this.status.incrementPendingCreation(this.pipelineContext.getPipelineId(), lifespan);
            long splitWeight = partitionedSplit == null ? 0L : partitionedSplit.getSplit().getSplitWeight().getRawValue();
            DriverContext driverContext = this.pipelineContext.addDriverContext(splitWeight, lifespan, this.driverFactory.getFragmentResultCacheContext());
            return new DriverSplitRunner(this, driverContext, partitionedSplit, lifespan);
        }

        public Driver createDriver(DriverContext driverContext, @Nullable ScheduledSplit partitionedSplit) {
            TaskSource taskSource;
            Optional<PlanNodeId> sourceId;
            Driver driver = this.driverFactory.createDriver(driverContext);
            SqlTaskExecution.this.drivers.add(new WeakReference<Driver>(driver));
            if (partitionedSplit != null) {
                driver.updateSource(new TaskSource(partitionedSplit.getPlanNodeId(), (Set<ScheduledSplit>)ImmutableSet.of((Object)partitionedSplit), true));
            }
            if ((sourceId = driver.getSourceId()).isPresent() && (taskSource = (TaskSource)SqlTaskExecution.this.remoteSources.get(sourceId.get())) != null) {
                driver.updateSource(taskSource);
            }
            SqlTaskExecution.this.status.decrementPendingCreation(this.pipelineContext.getPipelineId(), driverContext.getLifespan());
            this.closeDriverFactoryIfFullyCreated();
            return driver;
        }

        public void noMoreDriverRunner(Iterable<Lifespan> lifespans) {
            for (Lifespan lifespan : lifespans) {
                SqlTaskExecution.this.status.setNoMoreDriverRunner(this.pipelineContext.getPipelineId(), lifespan);
            }
            this.closeDriverFactoryIfFullyCreated();
        }

        public boolean isNoMoreDriverRunner() {
            return SqlTaskExecution.this.status.isNoMoreDriverRunners(this.pipelineContext.getPipelineId());
        }

        public void closeDriverFactoryIfFullyCreated() {
            if (this.closed) {
                return;
            }
            for (Lifespan lifespan : SqlTaskExecution.this.status.getAndAcknowledgeLifespansWithNoMoreDrivers(this.pipelineContext.getPipelineId())) {
                this.driverFactory.noMoreDrivers(lifespan);
            }
            if (!this.isNoMoreDriverRunner() || SqlTaskExecution.this.status.getPendingCreation(this.pipelineContext.getPipelineId()) != 0) {
                return;
            }
            this.driverFactory.noMoreDrivers();
            this.closed = true;
        }

        public PipelineExecutionStrategy getPipelineExecutionStrategy() {
            return this.driverFactory.getPipelineExecutionStrategy();
        }

        public OptionalInt getDriverInstances() {
            return this.driverFactory.getDriverInstances();
        }

        public void splitsAdded(int count, long weightSum) {
            this.pipelineContext.splitsAdded(count, weightSum);
        }
    }

    private static class SchedulingLifespanManager {
        private final List<PlanNodeId> sourceStartOrder;
        private final StageExecutionDescriptor stageExecutionDescriptor;
        private final Status status;
        private final Map<Lifespan, SchedulingLifespan> lifespans = new HashMap<Lifespan, SchedulingLifespan>();
        private final Set<Lifespan> completedLifespans = new HashSet<Lifespan>();
        private final Set<PlanNodeId> noMoreSplits = new HashSet<PlanNodeId>();
        private int maxScheduledPlanNodeOrdinal;

        public SchedulingLifespanManager(List<PlanNodeId> sourceStartOrder, StageExecutionDescriptor stageExecutionDescriptor, Status status) {
            this.sourceStartOrder = ImmutableList.copyOf(sourceStartOrder);
            this.stageExecutionDescriptor = stageExecutionDescriptor;
            this.status = Objects.requireNonNull(status, "status is null");
        }

        public int getMaxScheduledPlanNodeOrdinal() {
            return this.maxScheduledPlanNodeOrdinal;
        }

        public void updateMaxScheduledPlanNodeOrdinalIfNecessary(int scheduledPlanNodeOrdinal) {
            if (this.maxScheduledPlanNodeOrdinal < scheduledPlanNodeOrdinal) {
                this.maxScheduledPlanNodeOrdinal = scheduledPlanNodeOrdinal;
            }
        }

        public void noMoreSplits(PlanNodeId planNodeId) {
            if (this.noMoreSplits.contains(planNodeId)) {
                return;
            }
            this.noMoreSplits.add(planNodeId);
            if (this.noMoreSplits.size() < this.sourceStartOrder.size()) {
                return;
            }
            Preconditions.checkState((this.noMoreSplits.size() == this.sourceStartOrder.size() ? 1 : 0) != 0);
            Preconditions.checkState((boolean)this.noMoreSplits.containsAll(this.sourceStartOrder));
            this.status.setNoMoreLifespans();
        }

        public void addLifespanIfAbsent(Lifespan lifespan) {
            if (this.completedLifespans.contains(lifespan) || this.lifespans.containsKey(lifespan)) {
                return;
            }
            Preconditions.checkState((!this.status.isNoMoreLifespans() ? 1 : 0) != 0);
            Preconditions.checkState((!this.sourceStartOrder.isEmpty() ? 1 : 0) != 0);
            this.lifespans.put(lifespan, new SchedulingLifespan(lifespan, this));
        }

        public Iterator<SchedulingLifespan> getActiveLifespans() {
            final Iterator<SchedulingLifespan> lifespansIterator = this.lifespans.values().iterator();
            return new AbstractIterator<SchedulingLifespan>(){
                SchedulingLifespan lastSchedulingLifespan;

                protected SchedulingLifespan computeNext() {
                    if (this.lastSchedulingLifespan != null && this.lastSchedulingLifespan.isDone()) {
                        completedLifespans.add(this.lastSchedulingLifespan.getLifespan());
                        lifespansIterator.remove();
                    }
                    if (!lifespansIterator.hasNext()) {
                        return (SchedulingLifespan)this.endOfData();
                    }
                    this.lastSchedulingLifespan = (SchedulingLifespan)lifespansIterator.next();
                    return this.lastSchedulingLifespan;
                }
            };
        }
    }

    @NotThreadSafe
    private static class PendingSplitsForPlanNode {
        private final Map<Lifespan, PendingSplits> splitsByLifespan = new HashMap<Lifespan, PendingSplits>();
        private boolean noMoreSplits;

        private PendingSplitsForPlanNode() {
        }

        public PendingSplits getLifespan(Lifespan lifespan) {
            return this.splitsByLifespan.computeIfAbsent(lifespan, ignored -> new PendingSplits());
        }

        public void setNoMoreSplits() {
            if (this.noMoreSplits) {
                return;
            }
            this.noMoreSplits = true;
            for (PendingSplits splitsForLifespan : this.splitsByLifespan.values()) {
                splitsForLifespan.noMoreSplits();
            }
        }
    }

    @NotThreadSafe
    private static class PendingSplits {
        private Set<ScheduledSplit> splits = new HashSet<ScheduledSplit>();
        private SplitsState state = SplitsState.ADDING_SPLITS;

        private PendingSplits() {
        }

        public SplitsState getState() {
            return this.state;
        }

        public void addSplit(ScheduledSplit scheduledSplit) {
            Preconditions.checkState((this.state == SplitsState.ADDING_SPLITS ? 1 : 0) != 0);
            this.splits.add(scheduledSplit);
        }

        public Set<ScheduledSplit> removeAllSplits() {
            Preconditions.checkState((this.state == SplitsState.ADDING_SPLITS || this.state == SplitsState.NO_MORE_SPLITS ? 1 : 0) != 0);
            Set<ScheduledSplit> result = this.splits;
            this.splits = new HashSet<ScheduledSplit>();
            return result;
        }

        public void noMoreSplits() {
            if (this.state == SplitsState.ADDING_SPLITS) {
                this.state = SplitsState.NO_MORE_SPLITS;
            }
        }

        public void markAsCleanedUp() {
            Preconditions.checkState((boolean)this.splits.isEmpty());
            Preconditions.checkState((this.state == SplitsState.NO_MORE_SPLITS ? 1 : 0) != 0);
            this.state = SplitsState.FINISHED;
        }
    }

    private static final class CheckTaskCompletionOnBufferFinish
    implements StateMachine.StateChangeListener<BufferState> {
        private final WeakReference<SqlTaskExecution> sqlTaskExecutionReference;

        public CheckTaskCompletionOnBufferFinish(SqlTaskExecution sqlTaskExecution) {
            this.sqlTaskExecutionReference = new WeakReference<SqlTaskExecution>(sqlTaskExecution);
        }

        @Override
        public void stateChanged(BufferState newState) {
            SqlTaskExecution sqlTaskExecution;
            if (newState == BufferState.FINISHED && (sqlTaskExecution = (SqlTaskExecution)this.sqlTaskExecutionReference.get()) != null) {
                sqlTaskExecution.checkTaskCompletion();
            }
        }
    }

    private static class SchedulingLifespan {
        private final Lifespan lifespan;
        private final SchedulingLifespanManager manager;
        private int schedulingPlanNodeOrdinal;
        private boolean unpartitionedDriversScheduled;

        public SchedulingLifespan(Lifespan lifespan, SchedulingLifespanManager manager) {
            this.lifespan = Objects.requireNonNull(lifespan, "lifespan is null");
            this.manager = Objects.requireNonNull(manager, "manager is null");
        }

        public Lifespan getLifespan() {
            return this.lifespan;
        }

        public Optional<PlanNodeId> getSchedulingPlanNode() {
            Preconditions.checkState((!this.isDone() ? 1 : 0) != 0);
            while (!this.isDone()) {
                if (this.manager.stageExecutionDescriptor.isScanGroupedExecution((PlanNodeId)this.manager.sourceStartOrder.get(this.schedulingPlanNodeOrdinal)) != this.lifespan.isTaskWide()) {
                    return Optional.of((PlanNodeId)this.manager.sourceStartOrder.get(this.schedulingPlanNodeOrdinal));
                }
                if (this.manager.getMaxScheduledPlanNodeOrdinal() == this.schedulingPlanNodeOrdinal) {
                    return Optional.empty();
                }
                Verify.verify((this.manager.getMaxScheduledPlanNodeOrdinal() > this.schedulingPlanNodeOrdinal ? 1 : 0) != 0);
                this.nextPlanNode();
            }
            return Optional.empty();
        }

        public void nextPlanNode() {
            Preconditions.checkState((!this.isDone() ? 1 : 0) != 0);
            ++this.schedulingPlanNodeOrdinal;
            this.manager.updateMaxScheduledPlanNodeOrdinalIfNecessary(this.schedulingPlanNodeOrdinal);
        }

        public boolean isDone() {
            return this.schedulingPlanNodeOrdinal >= this.manager.sourceStartOrder.size();
        }

        public boolean getAndSetDriversForDriverGroupLifeCycleScheduled() {
            if (this.unpartitionedDriversScheduled) {
                return true;
            }
            this.unpartitionedDriversScheduled = true;
            return false;
        }
    }

    private static class DriverSplitRunner
    implements SplitRunner {
        private final DriverSplitRunnerFactory driverSplitRunnerFactory;
        private final DriverContext driverContext;
        private final Lifespan lifespan;
        @GuardedBy(value="this")
        private boolean closed;
        @Nullable
        private final ScheduledSplit partitionedSplit;
        @GuardedBy(value="this")
        private Driver driver;

        private DriverSplitRunner(DriverSplitRunnerFactory driverSplitRunnerFactory, DriverContext driverContext, @Nullable ScheduledSplit partitionedSplit, Lifespan lifespan) {
            this.driverSplitRunnerFactory = Objects.requireNonNull(driverSplitRunnerFactory, "driverFactory is null");
            this.driverContext = Objects.requireNonNull(driverContext, "driverContext is null");
            this.partitionedSplit = partitionedSplit;
            this.lifespan = Objects.requireNonNull(lifespan, "lifespan is null");
        }

        public synchronized DriverContext getDriverContext() {
            if (this.driver == null) {
                return null;
            }
            return this.driver.getDriverContext();
        }

        public Lifespan getLifespan() {
            return this.lifespan;
        }

        @Override
        public synchronized boolean isFinished() {
            if (this.closed) {
                return true;
            }
            return this.driver != null && this.driver.isFinished();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListenableFuture<?> processFor(Duration duration) {
            Driver driver;
            DriverSplitRunner driverSplitRunner = this;
            synchronized (driverSplitRunner) {
                if (this.closed) {
                    return Futures.immediateFuture(null);
                }
                if (this.driver == null) {
                    this.driver = this.driverSplitRunnerFactory.createDriver(this.driverContext, this.partitionedSplit);
                }
                driver = this.driver;
            }
            return driver.processFor(duration);
        }

        @Override
        public String getInfo() {
            return this.partitionedSplit == null ? "" : this.partitionedSplit.getSplit().getInfo().toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Driver driver;
            DriverSplitRunner driverSplitRunner = this;
            synchronized (driverSplitRunner) {
                this.closed = true;
                driver = this.driver;
            }
            if (driver != null) {
                driver.close();
            }
        }
    }

    static enum SplitsState {
        ADDING_SPLITS,
        NO_MORE_SPLITS,
        FINISHED;

    }

    private static class PerPipelineAndLifespanStatus {
        int pendingCreation;
        boolean noMoreDriverRunner;

        private PerPipelineAndLifespanStatus() {
        }
    }

    private static class PerLifespanStatus {
        int remainingDriver;
        int pipelinesWithNoMoreDriverRunners;

        private PerLifespanStatus() {
        }
    }

    private static class PerPipelineStatus {
        final PipelineExecutionStrategy executionStrategy;
        int pendingCreation;
        int lifespansWithNoMoreDriverRunners;
        final List<Lifespan> unacknowledgedLifespansWithNoMoreDrivers = new ArrayList<Lifespan>();

        public PerPipelineStatus(PipelineExecutionStrategy executionStrategy) {
            this.executionStrategy = Objects.requireNonNull(executionStrategy, "executionStrategy is null");
        }
    }
}

