/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.execution.DDLDefinitionTask;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.NodeUtils;
import com.facebook.presto.sql.analyzer.utils.ParameterUtils;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.SetProperties;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SetPropertiesTask
implements DDLDefinitionTask<SetProperties> {
    @Override
    public String getName() {
        return "SET PROPERTIES";
    }

    @Override
    public ListenableFuture<?> execute(SetProperties statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, Session session, List<Expression> parameters, WarningCollector warningCollector, String query) {
        QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getTableName(), metadata);
        Map<String, Expression> sqlProperties = NodeUtils.mapFromProperties(statement.getProperties());
        if (statement.getType() != SetProperties.Type.TABLE) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported target type: %s", statement.getType()));
        }
        ImmutableMap properties = metadata.getTablePropertyManager().getUserSpecifiedProperties(MetadataUtil.getConnectorIdOrThrow(session, metadata, tableName.getCatalogName()), tableName.getCatalogName(), sqlProperties, session, metadata, ParameterUtils.parameterExtractor((Statement)statement, parameters)).build();
        this.setTableProperties(statement, tableName, metadata, accessControl, session, (Map<String, Object>)properties);
        return Futures.immediateFuture(null);
    }

    private void setTableProperties(SetProperties statement, QualifiedObjectName tableName, Metadata metadata, AccessControl accessControl, Session session, Map<String, Object> properties) {
        if (metadata.getMetadataResolver(session).getMaterializedView(tableName).isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot set table properties to a materialized view");
        }
        if (metadata.getMetadataResolver(session).getView(tableName).isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot set table properties to a view");
        }
        Optional tableHandle = metadata.getMetadataResolver(session).getTableHandle(tableName);
        if (!tableHandle.isPresent()) {
            if (!statement.isTableExists()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Table does not exist: %s", tableName));
            }
            return;
        }
        accessControl.checkCanSetTableProperties(session.getRequiredTransactionId(), session.getIdentity(), session.getAccessControlContext(), tableName, properties);
        metadata.setTableProperties(session, (TableHandle)tableHandle.get(), properties);
    }
}

