/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.execution.SchedulerStatsTracker;
import com.sun.management.ThreadMXBean;
import io.netty.channel.DefaultEventLoop;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class SafeEventLoopGroup
extends DefaultEventLoopGroup {
    private static final Logger log = Logger.get(SafeEventLoopGroup.class);
    private static final ThreadMXBean THREAD_MX_BEAN = (ThreadMXBean)ManagementFactory.getThreadMXBean();
    private static final List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
    private final long slowMethodThresholdOnEventLoopInNanos;

    public SafeEventLoopGroup(int nThreads, ThreadFactory threadFactory, long slowMethodThresholdOnEventLoopInNanos) {
        super(nThreads, threadFactory);
        this.slowMethodThresholdOnEventLoopInNanos = slowMethodThresholdOnEventLoopInNanos;
    }

    protected EventLoop newChild(Executor executor, Object ... args) {
        return new SafeEventLoop((EventLoopGroup)this, executor);
    }

    public class SafeEventLoop
    extends DefaultEventLoop {
        public SafeEventLoop(EventLoopGroup parent, Executor executor) {
            super(parent, executor);
        }

        protected void run() {
            do {
                Runnable task;
                if ((task = this.takeTask()) == null) continue;
                try {
                    SafeEventLoop.runTask((Runnable)task);
                }
                catch (Throwable t) {
                    log.error(t, "Error executing task on event loop");
                }
                this.updateLastExecutionTime();
            } while (!this.confirmShutdown());
        }

        public void execute(Runnable task, Consumer<Throwable> failureHandler, SchedulerStatsTracker statsTracker, String methodSignature) {
            Objects.requireNonNull(task, "task is null");
            this.execute(() -> {
                long start = THREAD_MX_BEAN.getCurrentThreadCpuTime();
                try {
                    task.run();
                }
                catch (Throwable t) {
                    block7: {
                        try {
                            log.error(t, "Error executing method %s on event loop.", new Object[]{methodSignature});
                            if (failureHandler == null) break block7;
                            failureHandler.accept(t);
                        }
                        catch (Throwable throwable) {
                            long cpuTimeInNanos = THREAD_MX_BEAN.getCurrentThreadCpuTime() - start;
                            statsTracker.recordEventLoopMethodExecutionCpuTime(cpuTimeInNanos);
                            if (SafeEventLoopGroup.this.slowMethodThresholdOnEventLoopInNanos > 0L && cpuTimeInNanos > SafeEventLoopGroup.this.slowMethodThresholdOnEventLoopInNanos) {
                                log.warn("Slow method execution on event loop: %s took %s milliseconds", new Object[]{methodSignature, TimeUnit.NANOSECONDS.toMillis(cpuTimeInNanos)});
                            }
                            throw throwable;
                        }
                    }
                    long cpuTimeInNanos = THREAD_MX_BEAN.getCurrentThreadCpuTime() - start;
                    statsTracker.recordEventLoopMethodExecutionCpuTime(cpuTimeInNanos);
                    if (SafeEventLoopGroup.this.slowMethodThresholdOnEventLoopInNanos > 0L && cpuTimeInNanos > SafeEventLoopGroup.this.slowMethodThresholdOnEventLoopInNanos) {
                        log.warn("Slow method execution on event loop: %s took %s milliseconds", new Object[]{methodSignature, TimeUnit.NANOSECONDS.toMillis(cpuTimeInNanos)});
                    }
                }
                long cpuTimeInNanos = THREAD_MX_BEAN.getCurrentThreadCpuTime() - start;
                statsTracker.recordEventLoopMethodExecutionCpuTime(cpuTimeInNanos);
                if (SafeEventLoopGroup.this.slowMethodThresholdOnEventLoopInNanos > 0L && cpuTimeInNanos > SafeEventLoopGroup.this.slowMethodThresholdOnEventLoopInNanos) {
                    log.warn("Slow method execution on event loop: %s took %s milliseconds", new Object[]{methodSignature, TimeUnit.NANOSECONDS.toMillis(cpuTimeInNanos)});
                }
            });
        }
    }
}

