/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.DDLDefinitionTask;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.PrincipalType;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.RevokeRoles;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;

public class RevokeRolesTask
implements DDLDefinitionTask<RevokeRoles> {
    @Override
    public String getName() {
        return "GRANT ROLE";
    }

    @Override
    public ListenableFuture<?> execute(RevokeRoles statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, Session session, List<Expression> parameters, WarningCollector warningCollector, String query) {
        Set roles = (Set)statement.getRoles().stream().map(role -> role.getValue().toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet());
        Set grantees = (Set)statement.getGrantees().stream().map(MetadataUtil::createPrincipal).collect(ImmutableSet.toImmutableSet());
        boolean adminOptionFor = statement.isAdminOptionFor();
        Optional<PrestoPrincipal> grantor = statement.getGrantor().map(specification -> MetadataUtil.createPrincipal(session, specification));
        String catalog = MetadataUtil.createCatalogName(session, (Node)statement);
        Set<String> availableRoles = metadata.listRoles(session, catalog);
        LinkedHashSet<String> specifiedRoles = new LinkedHashSet<String>();
        specifiedRoles.addAll(roles);
        grantees.stream().filter(principal -> principal.getType() == PrincipalType.ROLE).map(PrestoPrincipal::getName).forEach(specifiedRoles::add);
        if (grantor.isPresent() && grantor.get().getType() == PrincipalType.ROLE) {
            specifiedRoles.add(grantor.get().getName());
        }
        for (String role2 : specifiedRoles) {
            if (availableRoles.contains(role2)) continue;
            throw new SemanticException(SemanticErrorCode.MISSING_ROLE, (Node)statement, "Role '%s' does not exist", new Object[]{role2});
        }
        accessControl.checkCanRevokeRoles(session.getRequiredTransactionId(), session.getIdentity(), session.getAccessControlContext(), roles, grantees, adminOptionFor, grantor, catalog);
        metadata.revokeRoles(session, roles, grantees, adminOptionFor, grantor, catalog);
        return Futures.immediateFuture(null);
    }
}

