/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.execution.DDLDefinitionTask;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.RenameView;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Optional;

public class RenameViewTask
implements DDLDefinitionTask<RenameView> {
    @Override
    public String getName() {
        return "RENAME VIEW";
    }

    @Override
    public ListenableFuture<?> execute(RenameView statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, Session session, List<Expression> parameters, WarningCollector warningCollector, String query) {
        QualifiedObjectName viewName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getSource(), metadata);
        Optional view = metadata.getMetadataResolver(session).getView(viewName);
        if (!view.isPresent()) {
            if (!statement.isExists()) {
                throw new SemanticException(SemanticErrorCode.MISSING_VIEW, (Node)statement, "View '%s' does not exist", new Object[]{viewName});
            }
            return Futures.immediateFuture(null);
        }
        QualifiedObjectName target = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getTarget(), metadata);
        if (!metadata.getCatalogHandle(session, target.getCatalogName()).isPresent()) {
            throw new SemanticException(SemanticErrorCode.MISSING_CATALOG, (Node)statement, "Target catalog '%s' does not exist", new Object[]{target.getCatalogName()});
        }
        if (metadata.getMetadataResolver(session).getView(target).isPresent()) {
            throw new SemanticException(SemanticErrorCode.VIEW_ALREADY_EXISTS, (Node)statement, "Target view '%s' already exists", new Object[]{target});
        }
        if (!viewName.getSchemaName().equals(target.getSchemaName())) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)statement, "View rename across schemas is not supported", new Object[0]);
        }
        if (!viewName.getCatalogName().equals(target.getCatalogName())) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)statement, "View rename across catalogs is not supported", new Object[0]);
        }
        accessControl.checkCanRenameView(session.getRequiredTransactionId(), session.getIdentity(), session.getAccessControlContext(), viewName, target);
        metadata.renameView(session, viewName, target);
        return Futures.immediateFuture(null);
    }
}

