/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.execution.DDLDefinitionTask;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.analyzer.MetadataResolver;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.RenameSchema;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Optional;

public class RenameSchemaTask
implements DDLDefinitionTask<RenameSchema> {
    @Override
    public String getName() {
        return "RENAME SCHEMA";
    }

    @Override
    public ListenableFuture<?> execute(RenameSchema statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, Session session, List<Expression> parameters, WarningCollector warningCollector, String query) {
        CatalogSchemaName source = MetadataUtil.createCatalogSchemaName(session, (Node)statement, Optional.of(statement.getSource()), metadata);
        CatalogSchemaName target = new CatalogSchemaName(source.getCatalogName(), statement.getTarget().getValue());
        MetadataResolver metadataResolver = metadata.getMetadataResolver(session);
        if (!metadataResolver.schemaExists(source)) {
            throw new SemanticException(SemanticErrorCode.MISSING_SCHEMA, (Node)statement, "Schema '%s' does not exist", new Object[]{source});
        }
        if (metadataResolver.schemaExists(target)) {
            throw new SemanticException(SemanticErrorCode.SCHEMA_ALREADY_EXISTS, (Node)statement, "Target schema '%s' already exists", new Object[]{target});
        }
        accessControl.checkCanRenameSchema(session.getRequiredTransactionId(), session.getIdentity(), session.getAccessControlContext(), source, statement.getTarget().getValue());
        metadata.renameSchema(session, source, statement.getTarget().getValue());
        return Futures.immediateFuture(null);
    }
}

