/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.Column;
import com.facebook.presto.spi.ConnectorId;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Output {
    private final ConnectorId connectorId;
    private final String schema;
    private final String table;
    private final String serializedCommitOutput;
    private final Optional<List<Column>> columns;

    @JsonCreator
    public Output(@JsonProperty(value="connectorId") ConnectorId connectorId, @JsonProperty(value="schema") String schema, @JsonProperty(value="table") String table, @JsonProperty(value="serializedCommitOutput") String serializedCommitOutput, @JsonProperty(value="columns") Optional<List<Column>> columns) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.table = Objects.requireNonNull(table, "table is null");
        this.serializedCommitOutput = Objects.requireNonNull(serializedCommitOutput, "connectorCommitOutput is null");
        this.columns = columns.map(ImmutableList::copyOf);
    }

    @JsonProperty
    public ConnectorId getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public String getTable() {
        return this.table;
    }

    @JsonProperty
    public String getSerializedCommitOutput() {
        return this.serializedCommitOutput;
    }

    @JsonProperty
    public Optional<List<Column>> getColumns() {
        return this.columns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Output output = (Output)o;
        return Objects.equals(this.connectorId, output.connectorId) && Objects.equals(this.schema, output.schema) && Objects.equals(this.table, output.table) && Objects.equals(this.serializedCommitOutput, output.serializedCommitOutput) && Objects.equals(this.columns, output.columns);
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.schema, this.table, this.serializedCommitOutput, this.columns);
    }
}

