/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.common.analyzer.PreparedQuery;
import com.facebook.presto.common.resourceGroups.QueryType;
import com.facebook.presto.execution.DDLDefinitionTask;
import com.facebook.presto.execution.DataDefinitionExecution;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.analyzer.AnalyzerProvider;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.analyzer.BuiltInQueryPreparer;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class DDLDefinitionExecution<T extends Statement>
extends DataDefinitionExecution<T> {
    private final DDLDefinitionTask<T> task;
    private final String query;

    private DDLDefinitionExecution(DDLDefinitionTask<T> task, T statement, String slug, int retryCount, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters, String query) {
        super(statement, slug, retryCount, transactionManager, metadata, accessControl, stateMachine, parameters);
        this.task = Objects.requireNonNull(task, "task is null");
        this.query = Objects.requireNonNull(query, "query is null");
    }

    @Override
    protected ListenableFuture<?> executeTask() {
        return this.task.execute(this.statement, this.transactionManager, this.metadata, this.accessControl, this.stateMachine.getSession(), this.parameters, this.stateMachine.getWarningCollector(), this.query);
    }

    /* synthetic */ DDLDefinitionExecution(DDLDefinitionTask x0, Statement x1, String x2, int x3, TransactionManager x4, Metadata x5, AccessControl x6, QueryStateMachine x7, List x8, String x9, 1 x10) {
        this(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9);
    }

    public static class DDLDefinitionExecutionFactory
    implements QueryExecution.QueryExecutionFactory<DDLDefinitionExecution<?>> {
        private final TransactionManager transactionManager;
        private final Metadata metadata;
        private final AccessControl accessControl;
        private final Map<Class<? extends Statement>, DataDefinitionTask<?>> tasks;

        @Inject
        public DDLDefinitionExecutionFactory(TransactionManager transactionManager, MetadataManager metadata, AccessControl accessControl, Map<Class<? extends Statement>, DataDefinitionTask<?>> tasks) {
            this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
            this.tasks = Objects.requireNonNull(tasks, "tasks is null");
        }

        @Override
        public DDLDefinitionExecution<?> createQueryExecution(AnalyzerProvider analyzerProvider, PreparedQuery preparedQuery, QueryStateMachine stateMachine, String slug, int retryCount, WarningCollector warningCollector, Optional<QueryType> queryType, AccessControl accessControl, String query) {
            Preconditions.checkState((boolean)(preparedQuery instanceof BuiltInQueryPreparer.BuiltInPreparedQuery), (String)"Unsupported prepared query type: %s", (Object)preparedQuery.getClass().getSimpleName());
            BuiltInQueryPreparer.BuiltInPreparedQuery builtInQueryPreparer = (BuiltInQueryPreparer.BuiltInPreparedQuery)preparedQuery;
            return this.createDDLDefinitionExecution(builtInQueryPreparer.getStatement(), builtInQueryPreparer.getParameters(), stateMachine, slug, retryCount, query);
        }

        private <T extends Statement> DDLDefinitionExecution<T> createDDLDefinitionExecution(T statement, List<Expression> parameters, QueryStateMachine stateMachine, String slug, int retryCount, String query) {
            DDLDefinitionTask task = (DDLDefinitionTask)this.tasks.get(statement.getClass());
            Preconditions.checkArgument((task != null ? 1 : 0) != 0, (String)"no task for statement: %s", (Object)statement.getClass().getSimpleName());
            stateMachine.setUpdateType(task.getName());
            return new DDLDefinitionExecution(task, statement, slug, retryCount, this.transactionManager, this.metadata, this.accessControl, stateMachine, parameters, query, null);
        }
    }
}

