/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.UnknownTypeException;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.execution.AddConstraintTask;
import com.facebook.presto.execution.DDLDefinitionTask;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.TableMetadata;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorCapabilities;
import com.facebook.presto.spi.constraints.PrimaryKeyConstraint;
import com.facebook.presto.spi.constraints.TableConstraint;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.NodeUtils;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.utils.ParameterUtils;
import com.facebook.presto.sql.tree.ColumnDefinition;
import com.facebook.presto.sql.tree.ConstraintSpecification;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.LikeClause;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.TableElement;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class CreateTableTask
implements DDLDefinitionTask<CreateTable> {
    @Override
    public String getName() {
        return "CREATE TABLE";
    }

    @Override
    public String explain(CreateTable statement, List<Expression> parameters) {
        return "CREATE TABLE " + statement.getName();
    }

    @Override
    public ListenableFuture<?> execute(CreateTable statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, Session session, List<Expression> parameters, WarningCollector warningCollector, String query) {
        return this.internalExecute(statement, metadata, accessControl, session, parameters, warningCollector, query);
    }

    @VisibleForTesting
    public ListenableFuture<?> internalExecute(CreateTable statement, Metadata metadata, AccessControl accessControl, Session session, List<Expression> parameters, WarningCollector warningCollector, String query) {
        block17: {
            Preconditions.checkArgument((!statement.getElements().isEmpty() ? 1 : 0) != 0, (Object)"no columns for table");
            Map parameterLookup = ParameterUtils.parameterExtractor((Statement)statement, parameters);
            QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName(), metadata);
            Optional tableHandle = metadata.getMetadataResolver(session).getTableHandle(tableName);
            if (tableHandle.isPresent()) {
                if (!statement.isNotExists()) {
                    throw new SemanticException(SemanticErrorCode.TABLE_ALREADY_EXISTS, (Node)statement, "Table '%s' already exists", new Object[]{tableName});
                }
                return Futures.immediateFuture(null);
            }
            ConnectorId connectorId = MetadataUtil.getConnectorIdOrThrow(session, metadata, tableName.getCatalogName());
            LinkedHashMap<String, ColumnMetadata> columns = new LinkedHashMap<String, ColumnMetadata>();
            Object inheritedProperties = ImmutableMap.of();
            boolean includingProperties = false;
            ArrayList<TableConstraint<String>> constraints = new ArrayList<TableConstraint<String>>();
            for (TableElement element : statement.getElements()) {
                if (element instanceof ColumnDefinition) {
                    Type type;
                    ColumnDefinition column2 = (ColumnDefinition)element;
                    String columnName = column2.getName().getValue();
                    String name = metadata.normalizeIdentifier(session, tableName.getCatalogName(), columnName);
                    try {
                        type = metadata.getType(TypeSignature.parseTypeSignature((String)column2.getType()));
                    }
                    catch (UnknownTypeException | IllegalArgumentException e) {
                        throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)element, "Unknown type '%s' for column '%s'", new Object[]{column2.getType(), column2.getName()});
                    }
                    if (type.equals(UnknownType.UNKNOWN)) {
                        throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)element, "Unknown type '%s' for column '%s'", new Object[]{column2.getType(), column2.getName()});
                    }
                    if (columns.containsKey(name)) {
                        throw new SemanticException(SemanticErrorCode.DUPLICATE_COLUMN_NAME, (Node)column2, "Column name '%s' specified more than once", new Object[]{column2.getName()});
                    }
                    if (!column2.isNullable() && !metadata.getConnectorCapabilities(session, connectorId).contains(ConnectorCapabilities.NOT_NULL_COLUMN_CONSTRAINT)) {
                        throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)column2, "Catalog '%s' does not support non-null column for column name '%s'", new Object[]{connectorId.getCatalogName(), column2.getName()});
                    }
                    Map<String, Expression> sqlProperties = NodeUtils.mapFromProperties(column2.getProperties());
                    Map<String, Object> columnProperties = metadata.getColumnPropertyManager().getProperties(connectorId, tableName.getCatalogName(), sqlProperties, session, metadata, parameterLookup);
                    columns.put(name, ColumnMetadata.builder().setName(name).setType(type).setNullable(column2.isNullable()).setComment((String)column2.getComment().orElse(null)).setProperties(columnProperties).build());
                    continue;
                }
                if (element instanceof LikeClause) {
                    LikeClause likeClause = (LikeClause)element;
                    QualifiedObjectName likeTableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, likeClause.getTableName(), metadata);
                    MetadataUtil.getConnectorIdOrThrow(session, metadata, likeTableName.getCatalogName(), (Statement)statement, "LIKE table catalog '%s' does not exist");
                    if (!tableName.getCatalogName().equals(likeTableName.getCatalogName())) {
                        throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)statement, "LIKE table across catalogs is not supported", new Object[0]);
                    }
                    TableHandle likeTable = (TableHandle)metadata.getMetadataResolver(session).getTableHandle(likeTableName).orElseThrow(() -> new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)statement, "LIKE table '%s' does not exist", new Object[]{likeTableName}));
                    TableMetadata likeTableMetadata = metadata.getTableMetadata(session, likeTable);
                    Optional propertiesOption = likeClause.getPropertiesOption();
                    if (propertiesOption.isPresent() && ((LikeClause.PropertiesOption)propertiesOption.get()).equals((Object)LikeClause.PropertiesOption.INCLUDING)) {
                        if (includingProperties) {
                            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)statement, "Only one LIKE clause can specify INCLUDING PROPERTIES", new Object[0]);
                        }
                        includingProperties = true;
                        inheritedProperties = likeTableMetadata.getMetadata().getProperties();
                    }
                    likeTableMetadata.getColumns().stream().filter(column -> !column.isHidden()).forEach(column -> {
                        if (columns.containsKey(column.getName())) {
                            throw new SemanticException(SemanticErrorCode.DUPLICATE_COLUMN_NAME, (Node)element, "Column name '%s' specified more than once", new Object[]{column.getName()});
                        }
                        columns.put(column.getName(), (ColumnMetadata)column);
                    });
                    continue;
                }
                if (element instanceof ConstraintSpecification) {
                    accessControl.checkCanAddConstraints(session.getRequiredTransactionId(), session.getIdentity(), session.getAccessControlContext(), tableName);
                    constraints.add(AddConstraintTask.convertToTableConstraint(metadata, session, connectorId, (ConstraintSpecification)element, warningCollector, query));
                    continue;
                }
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Invalid TableElement: " + element.getClass().getName());
            }
            accessControl.checkCanCreateTable(session.getRequiredTransactionId(), session.getIdentity(), session.getAccessControlContext(), tableName);
            constraints.stream().filter(c -> c.getName().isPresent()).collect(Collectors.groupingBy(c -> (String)c.getName().get(), Collectors.counting())).forEach((constraintName, count) -> {
                if (count > 1L) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR, String.format("Constraint name '%s' specified more than once", constraintName));
                }
            });
            if (constraints.stream().filter(PrimaryKeyConstraint.class::isInstance).collect(Collectors.groupingBy(c -> c.getName().orElse(""), Collectors.counting())).size() > 1) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR, "Multiple primary key constraints are not allowed");
            }
            Map<String, Expression> sqlProperties = NodeUtils.mapFromProperties(statement.getProperties());
            Map<String, Object> properties = metadata.getTablePropertyManager().getProperties(connectorId, tableName.getCatalogName(), sqlProperties, session, metadata, parameterLookup);
            Map<String, Object> finalProperties = CreateTableTask.combineProperties(sqlProperties.keySet(), properties, (Map<String, Object>)inheritedProperties);
            ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(MetadataUtil.toSchemaTableName(tableName), (List)ImmutableList.copyOf(columns.values()), finalProperties, statement.getComment(), constraints, Collections.emptyMap());
            try {
                metadata.createTable(session, tableName.getCatalogName(), tableMetadata, statement.isNotExists());
            }
            catch (PrestoException e) {
                if (e.getErrorCode().equals((Object)StandardErrorCode.ALREADY_EXISTS.toErrorCode()) && statement.isNotExists()) break block17;
                throw e;
            }
        }
        return Futures.immediateFuture(null);
    }

    private static Map<String, Object> combineProperties(Set<String> specifiedPropertyKeys, Map<String, Object> defaultProperties, Map<String, Object> inheritedProperties) {
        HashMap<String, Object> finalProperties = new HashMap<String, Object>(inheritedProperties);
        for (Map.Entry<String, Object> entry : defaultProperties.entrySet()) {
            if (!specifiedPropertyKeys.contains(entry.getKey()) && finalProperties.containsKey(entry.getKey())) continue;
            finalProperties.put(entry.getKey(), entry.getValue());
        }
        return finalProperties;
    }
}

