/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.SessionTransactionControlTask;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.SessionFunctionHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.FunctionVersion;
import com.facebook.presto.spi.function.Parameter;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.facebook.presto.spi.function.SqlFunctionHandle;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.SqlFormatter;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.utils.ParameterUtils;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CreateFunction;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Return;
import com.facebook.presto.sql.tree.RoutineBody;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class CreateFunctionTask
implements SessionTransactionControlTask<CreateFunction> {
    private final SqlParser sqlParser;

    @Inject
    public CreateFunctionTask(SqlParser sqlParser) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
    }

    @Override
    public String getName() {
        return "CREATE FUNCTION";
    }

    @Override
    public String explain(CreateFunction statement, List<Expression> parameters) {
        return String.format("CREATE %sFUNCTION %s", statement.isTemporary() ? "TEMPORARY " : "", statement.getFunctionName());
    }

    @Override
    public ListenableFuture<?> execute(CreateFunction statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters, String query) {
        Map parameterLookup = ParameterUtils.parameterExtractor((Statement)statement, parameters);
        Session session = stateMachine.getSession();
        Analyzer analyzer = new Analyzer(session, metadata, this.sqlParser, accessControl, Optional.empty(), parameters, parameterLookup, stateMachine.getWarningCollector(), query);
        Analysis analysis = analyzer.analyze((Statement)statement);
        if (analysis.getFunctionHandles().values().stream().anyMatch(SqlFunctionHandle.class::isInstance)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Invoking a dynamically registered function in SQL function body is not supported");
        }
        SqlInvokedFunction function = this.createSqlInvokedFunction(statement, metadata, analysis);
        if (statement.isTemporary()) {
            stateMachine.addSessionFunction(new SqlFunctionId(function.getSignature().getName(), function.getSignature().getArgumentTypes()), function);
        } else {
            metadata.getFunctionAndTypeManager().createFunction(function, statement.isReplace());
        }
        return Futures.immediateFuture(null);
    }

    private SqlInvokedFunction createSqlInvokedFunction(CreateFunction statement, Metadata metadata, final Analysis analysis) {
        QualifiedObjectName functionName = statement.isTemporary() ? QualifiedObjectName.valueOf((CatalogSchemaName)SessionFunctionHandle.SESSION_NAMESPACE, (String)statement.getFunctionName().getSuffix()) : metadata.getFunctionAndTypeManager().getFunctionAndTypeResolver().qualifyObjectName(statement.getFunctionName());
        List parameters = (List)statement.getParameters().stream().map(parameter -> new Parameter(parameter.getName().toString(), TypeSignature.parseTypeSignature((String)parameter.getType()))).collect(ImmutableList.toImmutableList());
        TypeSignature returnType = TypeSignature.parseTypeSignature((String)statement.getReturnType());
        String description = statement.getComment().orElse("");
        RoutineCharacteristics routineCharacteristics = RoutineCharacteristics.builder().setLanguage(new RoutineCharacteristics.Language(statement.getCharacteristics().getLanguage().getLanguage())).setDeterminism(RoutineCharacteristics.Determinism.valueOf((String)statement.getCharacteristics().getDeterminism().name())).setNullCallClause(RoutineCharacteristics.NullCallClause.valueOf((String)statement.getCharacteristics().getNullCallClause().name())).build();
        RoutineBody body = statement.getBody();
        if (statement.getBody() instanceof Return) {
            Expression bodyExpression = ((Return)statement.getBody()).getExpression();
            Type bodyType = analysis.getType(bodyExpression);
            bodyExpression = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

                public Expression rewriteExpression(Expression expression, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                    Expression rewritten = treeRewriter.defaultRewrite(expression, null);
                    Type coercion = analysis.getCoercion(expression);
                    if (coercion != null) {
                        return new Cast(rewritten, coercion.getTypeSignature().toString(), false, analysis.isTypeOnlyCoercion(expression));
                    }
                    return rewritten;
                }
            }, (Expression)bodyExpression, null);
            if (!bodyType.equals(metadata.getType(returnType))) {
                bodyExpression = new Cast(bodyExpression, statement.getReturnType());
            }
            body = new Return(bodyExpression);
        }
        return new SqlInvokedFunction(functionName, parameters, returnType, description, routineCharacteristics, SqlFormatter.formatSql((Node)body, Optional.empty()), FunctionVersion.notVersioned());
    }
}

