/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.execution.DDLDefinitionTask;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.procedure.Procedure;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.utils.ParameterUtils;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.ParameterRewriter;
import com.facebook.presto.sql.tree.Call;
import com.facebook.presto.sql.tree.CallArgument;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.util.Failures;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class CallTask
implements DDLDefinitionTask<Call> {
    @Override
    public String getName() {
        return "CALL";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ListenableFuture<?> execute(Call call, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, Session session, List<Expression> parameters, WarningCollector warningCollector, String query) {
        void var20_28;
        if (!transactionManager.getTransactionInfo(session.getRequiredTransactionId()).isAutoCommitContext()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Procedures cannot be called within a transaction (use autocommit mode)");
        }
        QualifiedObjectName procedureName = MetadataUtil.createQualifiedObjectName(session, (Node)call, call.getName(), metadata);
        ConnectorId connectorId = MetadataUtil.getConnectorIdOrThrow(session, metadata, procedureName.getCatalogName(), (Statement)call, "Catalog %s does not exist");
        Procedure procedure = metadata.getProcedureRegistry().resolve(connectorId, MetadataUtil.toSchemaTableName(procedureName));
        HashMap<String, Integer> positions = new HashMap<String, Integer>();
        for (int i = 0; i < procedure.getArguments().size(); ++i) {
            positions.put(((Procedure.Argument)procedure.getArguments().get(i)).getName(), i);
        }
        Predicate<CallArgument> hasName = argument -> argument.getName().isPresent();
        boolean anyNamed = call.getArguments().stream().anyMatch(hasName);
        boolean allNamed = call.getArguments().stream().allMatch(hasName);
        if (anyNamed && !allNamed) {
            throw new SemanticException(SemanticErrorCode.INVALID_PROCEDURE_ARGUMENTS, (Node)call, "Named and positional arguments cannot be mixed", new Object[0]);
        }
        LinkedHashMap<String, CallArgument> names = new LinkedHashMap<String, CallArgument>();
        for (int i = 0; i < call.getArguments().size(); ++i) {
            CallArgument argument2 = (CallArgument)call.getArguments().get(i);
            if (argument2.getName().isPresent()) {
                String name = (String)argument2.getName().get();
                if (names.put(name, argument2) != null) {
                    throw new SemanticException(SemanticErrorCode.INVALID_PROCEDURE_ARGUMENTS, (Node)argument2, "Duplicate procedure argument: %s", new Object[]{name});
                }
                if (positions.containsKey(name)) continue;
                throw new SemanticException(SemanticErrorCode.INVALID_PROCEDURE_ARGUMENTS, (Node)argument2, "Unknown argument name: %s", new Object[]{name});
            }
            if (i < procedure.getArguments().size()) {
                names.put(((Procedure.Argument)procedure.getArguments().get(i)).getName(), argument2);
                continue;
            }
            throw new SemanticException(SemanticErrorCode.INVALID_PROCEDURE_ARGUMENTS, (Node)call, "Too many arguments for procedure", new Object[0]);
        }
        procedure.getArguments().stream().filter(Procedure.Argument::isRequired).filter(argument -> !names.containsKey(argument.getName())).map(Procedure.Argument::getName).findFirst().ifPresent(argument -> {
            throw new SemanticException(SemanticErrorCode.INVALID_PROCEDURE_ARGUMENTS, (Node)call, String.format("Required procedure argument '%s' is missing", argument), new Object[0]);
        });
        Object[] values = new Object[procedure.getArguments().size()];
        Map parameterLookup = ParameterUtils.parameterExtractor((Statement)call, parameters);
        for (Map.Entry entry : names.entrySet()) {
            CallArgument callArgument = (CallArgument)entry.getValue();
            int index = (Integer)positions.get(entry.getKey());
            Procedure.Argument argument3 = (Procedure.Argument)procedure.getArguments().get(index);
            Expression expression = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(parameterLookup), (Expression)callArgument.getValue());
            Type type = metadata.getType(argument3.getType());
            Failures.checkCondition(type != null, (ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_DEFINITION, "Unknown procedure argument type: %s", argument3.getType());
            Object value = ExpressionInterpreter.evaluateConstantExpression(expression, type, metadata, session, parameterLookup);
            values[index] = CallTask.toTypeObjectValue(session, type, value);
        }
        for (int i = 0; i < procedure.getArguments().size(); ++i) {
            Procedure.Argument argument2 = (Procedure.Argument)procedure.getArguments().get(i);
            if (names.containsKey(argument2.getName())) continue;
            Verify.verify((boolean)argument2.isOptional());
            values[i] = CallTask.toTypeObjectValue(session, metadata.getType(argument2.getType()), argument2.getDefaultValue());
        }
        MethodType methodType = procedure.getMethodHandle().type();
        boolean bl = false;
        while (var20_28 < procedure.getArguments().size()) {
            if (values[var20_28] == null && ((Class)methodType.parameterType((int)var20_28)).isPrimitive()) {
                String name = ((Procedure.Argument)procedure.getArguments().get((int)var20_28)).getName();
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Procedure argument cannot be null: " + name);
            }
            ++var20_28;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator<Object> valuesIterator = Arrays.asList(values).iterator();
        for (Class<?> type : methodType.parameterList()) {
            if (ConnectorSession.class.isAssignableFrom(type)) {
                arrayList.add(session.toConnectorSession(connectorId));
                continue;
            }
            arrayList.add(valuesIterator.next());
        }
        try {
            procedure.getMethodHandle().invokeWithArguments(arrayList);
        }
        catch (Throwable t) {
            if (t instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            Throwables.throwIfInstanceOf((Throwable)t, PrestoException.class);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.PROCEDURE_CALL_FAILED, t);
        }
        return Futures.immediateFuture(null);
    }

    private static Object toTypeObjectValue(Session session, Type type, Object value) {
        BlockBuilder blockBuilder = type.createBlockBuilder(null, 1);
        TypeUtils.writeNativeValue((Type)type, (BlockBuilder)blockBuilder, (Object)value);
        return type.getObjectValue(session.getSqlFunctionProperties(), (Block)blockBuilder, 0);
    }
}

