/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.execution.DDLDefinitionTask;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.function.AlterRoutineCharacteristics;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.utils.ParameterUtils;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.AlterFunction;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class AlterFunctionTask
implements DDLDefinitionTask<AlterFunction> {
    private final SqlParser sqlParser;

    @Inject
    public AlterFunctionTask(SqlParser sqlParser) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
    }

    @Override
    public String getName() {
        return "ALTER FUNCTION";
    }

    @Override
    public String explain(AlterFunction statement, List<Expression> parameters) {
        return "ALTER FUNCTION " + statement.getFunctionName();
    }

    @Override
    public ListenableFuture<?> execute(AlterFunction statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, Session session, List<Expression> parameters, WarningCollector warningCollector, String query) {
        Map parameterLookup = ParameterUtils.parameterExtractor((Statement)statement, parameters);
        Analyzer analyzer = new Analyzer(session, metadata, this.sqlParser, accessControl, Optional.empty(), parameters, parameterLookup, warningCollector, query);
        analyzer.analyze((Statement)statement);
        QualifiedObjectName functionName = metadata.getFunctionAndTypeManager().getFunctionAndTypeResolver().qualifyObjectName(statement.getFunctionName());
        AlterRoutineCharacteristics alterRoutineCharacteristics = new AlterRoutineCharacteristics(statement.getCharacteristics().getNullCallClause().map(Enum::name).map(RoutineCharacteristics.NullCallClause::valueOf));
        metadata.getFunctionAndTypeManager().alterFunction(functionName, statement.getParameterTypes().map(types -> (List)types.stream().map(TypeSignature::parseTypeSignature).collect(ImmutableList.toImmutableList())), alterRoutineCharacteristics);
        return Futures.immediateFuture(null);
    }
}

