/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.execution.DDLDefinitionTask;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.StandardWarningCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.WarningCodeSupplier;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorCapabilities;
import com.facebook.presto.spi.constraints.PrimaryKeyConstraint;
import com.facebook.presto.spi.constraints.TableConstraint;
import com.facebook.presto.spi.constraints.UniqueConstraint;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.AddConstraint;
import com.facebook.presto.sql.tree.ConstraintSpecification;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class AddConstraintTask
implements DDLDefinitionTask<AddConstraint> {
    public static TableConstraint<String> convertToTableConstraint(Metadata metadata, Session session, ConnectorId connectorId, ConstraintSpecification node, WarningCollector warningCollector, String query) {
        UniqueConstraint tableConstraint;
        LinkedHashSet constraintColumns = node.getColumns().stream().collect(Collectors.toCollection(LinkedHashSet::new));
        switch (node.getConstraintType()) {
            case UNIQUE: {
                if (!metadata.getConnectorCapabilities(session, connectorId).contains(ConnectorCapabilities.UNIQUE_CONSTRAINT)) {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Catalog %s does not support Unique constraints", new Object[]{connectorId.getCatalogName()});
                }
                tableConstraint = new UniqueConstraint(node.getConstraintName(), constraintColumns, node.isEnabled(), node.isRely(), node.isEnforced());
                break;
            }
            case PRIMARY_KEY: {
                if (!metadata.getConnectorCapabilities(session, connectorId).contains(ConnectorCapabilities.PRIMARY_KEY_CONSTRAINT)) {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Catalog %s does not support Primary Key constraints", new Object[]{connectorId.getCatalogName()});
                }
                tableConstraint = new PrimaryKeyConstraint(node.getConstraintName(), constraintColumns, node.isEnabled(), node.isRely(), node.isEnforced());
                break;
            }
            default: {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Given constraint type %s is not supported", new Object[]{node.getConstraintType().toString()});
            }
        }
        if (!metadata.getConnectorCapabilities(session, connectorId).contains(ConnectorCapabilities.ENFORCE_CONSTRAINTS) && node.isEnforced()) {
            warningCollector.add(new PrestoWarning((WarningCodeSupplier)StandardWarningCode.SEMANTIC_WARNING, String.format("Constraint %s is set to ENFORCED. This connector does not support enforcement of table constraints", node.getConstraintName().orElse(""))));
        }
        return tableConstraint;
    }

    @Override
    public String getName() {
        return "ADD CONSTRAINT";
    }

    @Override
    public ListenableFuture<?> execute(AddConstraint statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, Session session, List<Expression> parameters, WarningCollector warningCollector, String query) {
        QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getTableName(), metadata);
        Optional tableHandle = metadata.getMetadataResolver(session).getTableHandle(tableName);
        if (!tableHandle.isPresent()) {
            if (!statement.isTableExists()) {
                throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)statement, "Table '%s' does not exist", new Object[]{tableName});
            }
            return Futures.immediateFuture(null);
        }
        Optional optionalMaterializedView = metadata.getMetadataResolver(session).getMaterializedView(tableName);
        if (optionalMaterializedView.isPresent()) {
            if (!statement.isTableExists()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)statement, "'%s' is a materialized view, and add constraint is not supported", new Object[]{tableName});
            }
            return Futures.immediateFuture(null);
        }
        ConnectorId connectorId = metadata.getCatalogHandle(session, tableName.getCatalogName()).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog does not exist: " + tableName.getCatalogName()));
        accessControl.checkCanAddConstraints(session.getRequiredTransactionId(), session.getIdentity(), session.getAccessControlContext(), tableName);
        metadata.addConstraint(session, (TableHandle)tableHandle.get(), AddConstraintTask.convertToTableConstraint(metadata, session, connectorId, statement.getConstraintSpecification(), warningCollector, query));
        return Futures.immediateFuture(null);
    }
}

