/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.UnknownTypeException;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.execution.DDLDefinitionTask;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorCapabilities;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.NodeUtils;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.utils.ParameterUtils;
import com.facebook.presto.sql.tree.AddColumn;
import com.facebook.presto.sql.tree.ColumnDefinition;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AddColumnTask
implements DDLDefinitionTask<AddColumn> {
    @Override
    public String getName() {
        return "ADD COLUMN";
    }

    @Override
    public ListenableFuture<?> execute(AddColumn statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, Session session, List<Expression> parameters, WarningCollector warningCollector, String query) {
        Type type;
        QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName(), metadata);
        Optional tableHandle = metadata.getMetadataResolver(session).getTableHandle(tableName);
        if (!tableHandle.isPresent()) {
            if (!statement.isTableExists()) {
                throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)statement, "Table '%s' does not exist", new Object[]{tableName});
            }
            return Futures.immediateFuture(null);
        }
        Optional optionalMaterializedView = metadata.getMetadataResolver(session).getMaterializedView(tableName);
        if (optionalMaterializedView.isPresent()) {
            if (!statement.isTableExists()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)statement, "'%s' is a materialized view, and add column is not supported", new Object[]{tableName});
            }
            return Futures.immediateFuture(null);
        }
        ConnectorId connectorId = MetadataUtil.getConnectorIdOrThrow(session, metadata, tableName.getCatalogName());
        accessControl.checkCanAddColumns(session.getRequiredTransactionId(), session.getIdentity(), session.getAccessControlContext(), tableName);
        Map<String, ColumnHandle> columnHandles = metadata.getColumnHandles(session, (TableHandle)tableHandle.get());
        ColumnDefinition element = statement.getColumn();
        try {
            type = metadata.getType(TypeSignature.parseTypeSignature((String)element.getType()));
        }
        catch (UnknownTypeException | IllegalArgumentException e) {
            throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)element, "Unknown type '%s' for column '%s'", new Object[]{element.getType(), element.getName()});
        }
        if (type.equals(UnknownType.UNKNOWN)) {
            throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)element, "Unknown type '%s' for column '%s'", new Object[]{element.getType(), element.getName()});
        }
        if (columnHandles.containsKey(element.getName().getValueLowerCase())) {
            if (!statement.isColumnNotExists()) {
                throw new SemanticException(SemanticErrorCode.COLUMN_ALREADY_EXISTS, (Node)statement, "Column '%s' already exists", new Object[]{element.getName()});
            }
            return Futures.immediateFuture(null);
        }
        if (!element.isNullable() && !metadata.getConnectorCapabilities(session, connectorId).contains(ConnectorCapabilities.NOT_NULL_COLUMN_CONSTRAINT)) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)element, "Catalog '%s' does not support NOT NULL for column '%s'", new Object[]{connectorId.getCatalogName(), element.getName()});
        }
        Map<String, Expression> sqlProperties = NodeUtils.mapFromProperties(element.getProperties());
        Map<String, Object> columnProperties = metadata.getColumnPropertyManager().getProperties(connectorId, tableName.getCatalogName(), sqlProperties, session, metadata, ParameterUtils.parameterExtractor((Statement)statement, parameters));
        Identifier columnIdentifier = element.getName();
        String name = metadata.normalizeIdentifier(session, tableName.getCatalogName(), columnIdentifier.getValue());
        ColumnMetadata column = ColumnMetadata.builder().setName(name).setType(type).setNullable(element.isNullable()).setComment((String)element.getComment().orElse(null)).setProperties(columnProperties).build();
        metadata.addColumn(session, (TableHandle)tableHandle.get(), column);
        return Futures.immediateFuture(null);
    }
}

