/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.eventlistener;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.eventlistener.EventListenerConfig;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.spi.eventlistener.EventListener;
import com.facebook.presto.spi.eventlistener.EventListenerFactory;
import com.facebook.presto.spi.eventlistener.QueryCompletedEvent;
import com.facebook.presto.spi.eventlistener.QueryCreatedEvent;
import com.facebook.presto.spi.eventlistener.QueryProgressEvent;
import com.facebook.presto.spi.eventlistener.QueryUpdatedEvent;
import com.facebook.presto.spi.eventlistener.SplitCompletedEvent;
import com.facebook.presto.util.PropertiesUtil;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class EventListenerManager {
    private static final Logger log = Logger.get(EventListenerManager.class);
    private static final File EVENT_LISTENER_CONFIGURATION = new File("etc/event-listener.properties");
    private static final String EVENT_LISTENER_PROPERTY_NAME = "event-listener.name";
    private final List<File> configFiles;
    private final Map<String, EventListenerFactory> eventListenerFactories = new ConcurrentHashMap<String, EventListenerFactory>();
    private final AtomicReference<List<EventListener>> configuredEventListeners = new AtomicReference<ImmutableList>(ImmutableList.of());
    private final AtomicBoolean loading = new AtomicBoolean(false);

    @Inject
    public EventListenerManager(EventListenerConfig config) {
        this.configFiles = ImmutableList.copyOf(config.getEventListenerFiles());
    }

    public void addEventListenerFactory(EventListenerFactory eventListenerFactory) {
        Objects.requireNonNull(eventListenerFactory, "eventListenerFactory is null");
        if (this.eventListenerFactories.putIfAbsent(eventListenerFactory.getName(), eventListenerFactory) != null) {
            throw new IllegalArgumentException(String.format("Event listener '%s' is already registered", eventListenerFactory.getName()));
        }
    }

    public void loadConfiguredEventListeners() {
        Preconditions.checkState((boolean)this.loading.compareAndSet(false, true), (Object)"Event listeners already loaded");
        ImmutableList configFiles = this.configFiles;
        if (configFiles.isEmpty()) {
            if (!EVENT_LISTENER_CONFIGURATION.exists()) {
                return;
            }
            configFiles = ImmutableList.of((Object)EVENT_LISTENER_CONFIGURATION);
        }
        configFiles.forEach(this::createEventListener);
    }

    private void createEventListener(File configFile) {
        log.info("-- Loading event listener configuration file %s --", new Object[]{configFile});
        if (configFile.exists()) {
            configFile = configFile.getAbsoluteFile();
            log.info("-- Loading event listener configuration file : %s --", new Object[]{configFile});
            try {
                HashMap<String, String> properties = new HashMap<String, String>(PropertiesUtil.loadProperties(configFile));
                this.loadConfiguredEventListener(properties);
                log.info("-- Loaded event listener configuration file %s --", new Object[]{configFile});
            }
            catch (IOException e) {
                log.error((Throwable)e, "IOException while loading configuration file: " + configFile);
                throw new UncheckedIOException("Failed to read configuration file: " + configFile, e);
            }
        } else {
            log.info("Unable to locate configuration file %s --", new Object[]{configFile});
        }
    }

    private void setConfiguredEventListener(String name, Map<String, String> properties) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(properties, "properties is null");
        log.info("-- Loading event listener --");
        EventListenerFactory eventListenerFactory = this.eventListenerFactories.get(name);
        Preconditions.checkState((eventListenerFactory != null ? 1 : 0) != 0, (String)"Event listener %s is not registered", (Object)name);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(eventListenerFactory.getClass().getClassLoader());){
            EventListener eventListener = eventListenerFactory.create((Map)ImmutableMap.copyOf(properties));
            ImmutableList eventListeners = ImmutableList.builder().addAll((Iterable)this.configuredEventListeners.get()).add((Object)eventListener).build();
            this.configuredEventListeners.set((List<EventListener>)eventListeners);
        }
        log.info("-- Loaded event listener %s --", new Object[]{name});
    }

    public void loadConfiguredEventListener(Map<String, String> properties) {
        String eventListenerName = (properties = new HashMap<String, String>(properties)).remove(EVENT_LISTENER_PROPERTY_NAME);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)eventListenerName) ? 1 : 0) != 0, (Object)"event-listener.name property must be present");
        this.setConfiguredEventListener(eventListenerName, properties);
    }

    public void queryCompleted(QueryCompletedEvent queryCompletedEvent) {
        this.configuredEventListeners.get().forEach(eventListener -> eventListener.queryCompleted(queryCompletedEvent));
    }

    public void queryCreated(QueryCreatedEvent queryCreatedEvent) {
        this.configuredEventListeners.get().forEach(eventListener -> eventListener.queryCreated(queryCreatedEvent));
    }

    public void queryUpdated(QueryUpdatedEvent queryUpdatedEvent) {
        this.configuredEventListeners.get().forEach(eventListener -> eventListener.queryUpdated(queryUpdatedEvent));
    }

    public void publishQueryProgress(QueryProgressEvent queryProgressEvent) {
        this.configuredEventListeners.get().forEach(eventListener -> eventListener.publishQueryProgress(queryProgressEvent));
    }

    public void splitCompleted(SplitCompletedEvent splitCompletedEvent) {
        this.configuredEventListeners.get().forEach(eventListener -> eventListener.splitCompleted(splitCompletedEvent));
    }
}

