/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.event;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.eventlistener.EventListenerManager;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.operator.DriverStats;
import com.facebook.presto.spi.eventlistener.SplitCompletedEvent;
import com.facebook.presto.spi.eventlistener.SplitFailureInfo;
import com.facebook.presto.spi.eventlistener.SplitStatistics;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class SplitMonitor {
    private static final Logger log = Logger.get(SplitMonitor.class);
    private final ObjectMapper objectMapper;
    private final EventListenerManager eventListenerManager;

    @Inject
    public SplitMonitor(EventListenerManager eventListenerManager, ObjectMapper objectMapper) {
        this.eventListenerManager = Objects.requireNonNull(eventListenerManager, "eventListenerManager is null");
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper is null");
    }

    public void splitCompletedEvent(TaskId taskId, DriverStats driverStats) {
        this.splitCompletedEvent(taskId, driverStats, null, null);
    }

    public void splitFailedEvent(TaskId taskId, DriverStats driverStats, Throwable cause) {
        this.splitCompletedEvent(taskId, driverStats, cause.getClass().getName(), cause.getMessage());
    }

    private void splitCompletedEvent(TaskId taskId, DriverStats driverStats, @Nullable String failureType, @Nullable String failureMessage) {
        Optional<Object> timeToStart = Optional.empty();
        if (driverStats.getStartTimeInMillis() != 0L) {
            timeToStart = Optional.of(Duration.ofMillis(driverStats.getStartTimeInMillis() - driverStats.getCreateTimeInMillis()));
        }
        Optional<Object> timeToEnd = Optional.empty();
        if (driverStats.getEndTimeInMillis() != 0L) {
            timeToEnd = Optional.of(Duration.ofMillis(driverStats.getEndTimeInMillis() - driverStats.getCreateTimeInMillis()));
        }
        Optional<Object> splitFailureMetadata = Optional.empty();
        if (failureType != null) {
            splitFailureMetadata = Optional.of(new SplitFailureInfo(failureType, failureMessage != null ? failureMessage : ""));
        }
        try {
            this.eventListenerManager.splitCompleted(new SplitCompletedEvent(taskId.getQueryId().toString(), taskId.getStageExecutionId().getStageId().toString(), taskId.getStageExecutionId().toString(), Integer.toString(taskId.getId()), Instant.ofEpochMilli(driverStats.getCreateTimeInMillis()), Optional.ofNullable(Instant.ofEpochMilli(driverStats.getStartTimeInMillis())), Optional.ofNullable(Instant.ofEpochMilli(driverStats.getEndTimeInMillis())), new SplitStatistics(Duration.ofMillis(driverStats.getTotalCpuTime().toMillis()), Duration.ofMillis(driverStats.getElapsedTime().toMillis()), Duration.ofMillis(driverStats.getQueuedTime().toMillis()), Duration.ofMillis(driverStats.getRawInputReadTime().toMillis()), driverStats.getRawInputPositions(), driverStats.getRawInputDataSizeInBytes(), timeToStart, timeToEnd), splitFailureMetadata, this.objectMapper.writeValueAsString((Object)driverStats)));
        }
        catch (JsonProcessingException e) {
            log.error((Throwable)e, "Error processing split completion event for task %s", new Object[]{taskId});
        }
    }
}

