/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.event;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.dispatcher.DispatchManager;
import com.facebook.presto.event.QueryMonitor;
import com.facebook.presto.event.QueryMonitorConfig;
import com.facebook.presto.server.BasicQueryInfo;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;

public class QueryProgressMonitor {
    private final AtomicLong monotonicallyIncreasingEventId = new AtomicLong();
    private final QueryMonitor queryMonitor;
    private final DispatchManager dispatchManager;
    private final Duration queryProgressPublishInterval;
    @GuardedBy(value="this")
    private ScheduledExecutorService queryProgressMonitorExecutor;

    @Inject
    public QueryProgressMonitor(QueryMonitor queryMonitor, DispatchManager dispatchManager, QueryMonitorConfig queryMonitorConfig) {
        this.queryMonitor = Objects.requireNonNull(queryMonitor, "queryMonitor is null");
        this.dispatchManager = Objects.requireNonNull(dispatchManager, "dispatchManager is null");
        this.queryProgressPublishInterval = Objects.requireNonNull(queryMonitorConfig, "queryMonitorConfig is null").getQueryProgressPublishInterval();
    }

    @PostConstruct
    public synchronized void start() {
        if (this.queryProgressPublishInterval.getValue() > 0.0) {
            if (this.queryProgressMonitorExecutor == null) {
                this.queryProgressMonitorExecutor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"query-progress-monitor-executor"));
            }
            this.queryProgressMonitorExecutor.scheduleWithFixedDelay(this::publishQueryProgressEvent, (long)this.queryProgressPublishInterval.getValue(), (long)this.queryProgressPublishInterval.getValue(), this.queryProgressPublishInterval.getUnit());
        }
    }

    @PreDestroy
    public synchronized void stop() {
        if (this.queryProgressMonitorExecutor != null) {
            this.queryProgressMonitorExecutor.shutdown();
        }
    }

    private void publishQueryProgressEvent() {
        for (BasicQueryInfo basicQueryInfo : this.dispatchManager.getQueries()) {
            if (basicQueryInfo.getState().isDone()) continue;
            this.queryMonitor.publishQueryProgressEvent(this.monotonicallyIncreasingEventId.incrementAndGet(), basicQueryInfo);
        }
    }
}

