/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.event;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.node.NodeInfo;
import com.facebook.airlift.stats.Distribution;
import com.facebook.presto.SessionRepresentation;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.plan.PlanCanonicalizationStrategy;
import com.facebook.presto.common.transaction.TransactionId;
import com.facebook.presto.cost.HistoryBasedPlanStatisticsManager;
import com.facebook.presto.cost.HistoryBasedPlanStatisticsTracker;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.event.QueryMonitorConfig;
import com.facebook.presto.eventlistener.EventListenerManager;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.Input;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.execution.StageExecutionInfo;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.operator.OperatorInfo;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.TableFinishInfo;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.BasicQueryStats;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.eventlistener.Column;
import com.facebook.presto.spi.eventlistener.OperatorStatistics;
import com.facebook.presto.spi.eventlistener.QueryCompletedEvent;
import com.facebook.presto.spi.eventlistener.QueryContext;
import com.facebook.presto.spi.eventlistener.QueryCreatedEvent;
import com.facebook.presto.spi.eventlistener.QueryFailureInfo;
import com.facebook.presto.spi.eventlistener.QueryIOMetadata;
import com.facebook.presto.spi.eventlistener.QueryInputMetadata;
import com.facebook.presto.spi.eventlistener.QueryMetadata;
import com.facebook.presto.spi.eventlistener.QueryOutputMetadata;
import com.facebook.presto.spi.eventlistener.QueryProgressEvent;
import com.facebook.presto.spi.eventlistener.QueryStatistics;
import com.facebook.presto.spi.eventlistener.QueryUpdatedEvent;
import com.facebook.presto.spi.eventlistener.ResourceDistribution;
import com.facebook.presto.spi.eventlistener.StageStatistics;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.statistics.PlanStatisticsWithSourceInfo;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.CanonicalPlanWithInfo;
import com.facebook.presto.sql.planner.planPrinter.PlanPrinter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class QueryMonitor {
    private static final Logger log = Logger.get(QueryMonitor.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final JsonCodec<StageInfo> stageInfoCodec;
    private final JsonCodec<ExecutionFailureInfo> executionFailureInfoCodec;
    private final JsonCodec<OperatorInfo> operatorInfoCodec;
    private final EventListenerManager eventListenerManager;
    private final String serverVersion;
    private final String serverAddress;
    private final String environment;
    private final SessionPropertyManager sessionPropertyManager;
    private final FunctionAndTypeManager functionAndTypeManager;
    private final HistoryBasedPlanStatisticsTracker historyBasedPlanStatisticsTracker;
    private final int maxJsonLimit;
    private final String workerType;

    @Inject
    public QueryMonitor(JsonCodec<StageInfo> stageInfoCodec, JsonCodec<ExecutionFailureInfo> executionFailureInfoCodec, JsonCodec<OperatorInfo> operatorInfoCodec, EventListenerManager eventListenerManager, NodeInfo nodeInfo, NodeVersion nodeVersion, SessionPropertyManager sessionPropertyManager, Metadata metadata, QueryMonitorConfig config, HistoryBasedPlanStatisticsManager historyBasedPlanStatisticsManager, FeaturesConfig featuresConfig) {
        this.eventListenerManager = Objects.requireNonNull(eventListenerManager, "eventListenerManager is null");
        this.stageInfoCodec = Objects.requireNonNull(stageInfoCodec, "stageInfoCodec is null");
        this.operatorInfoCodec = Objects.requireNonNull(operatorInfoCodec, "operatorInfoCodec is null");
        this.executionFailureInfoCodec = Objects.requireNonNull(executionFailureInfoCodec, "executionFailureInfoCodec is null");
        this.serverVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null").toString();
        this.serverAddress = Objects.requireNonNull(nodeInfo, "nodeInfo is null").getExternalAddress();
        this.environment = Objects.requireNonNull(nodeInfo, "nodeInfo is null").getEnvironment();
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.functionAndTypeManager = Objects.requireNonNull(metadata, "metadata is null").getFunctionAndTypeManager();
        this.historyBasedPlanStatisticsTracker = Objects.requireNonNull(historyBasedPlanStatisticsManager, "historyBasedPlanStatisticsManager is null").getHistoryBasedPlanStatisticsTracker();
        this.maxJsonLimit = Math.toIntExact(Objects.requireNonNull(config, "config is null").getMaxOutputStageJsonSize().toBytes());
        this.workerType = Objects.requireNonNull(featuresConfig, "featuresConfig is null").isNativeExecutionEnabled() ? "Prestissimo" : "Presto";
    }

    public void queryCreatedEvent(BasicQueryInfo queryInfo) {
        this.eventListenerManager.queryCreated(new QueryCreatedEvent(queryInfo.getQueryStats().getCreateTime().toDate().toInstant(), this.createQueryContext(queryInfo.getSession(), queryInfo.getResourceGroupId()), new QueryMetadata(queryInfo.getQueryId().toString(), queryInfo.getSession().getTransactionId().map(TransactionId::toString), queryInfo.getQuery(), queryInfo.getQueryHash(), queryInfo.getPreparedQuery(), QueryState.QUEUED.toString(), queryInfo.getSelf(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), queryInfo.getSession().getTraceToken(), Optional.empty())));
    }

    public void queryUpdatedEvent(QueryInfo queryInfo) {
        this.eventListenerManager.queryUpdated(new QueryUpdatedEvent(this.createQueryMetadata(queryInfo)));
    }

    public void publishQueryProgressEvent(long monotonicallyIncreasingEventId, BasicQueryInfo queryInfo) {
        this.eventListenerManager.publishQueryProgress(new QueryProgressEvent(monotonicallyIncreasingEventId, new QueryMetadata(queryInfo.getQueryId().toString(), queryInfo.getSession().getTransactionId().map(TransactionId::toString), queryInfo.getQuery(), queryInfo.getQueryHash(), queryInfo.getPreparedQuery(), queryInfo.getState().toString(), queryInfo.getSelf(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), queryInfo.getSession().getTraceToken(), Optional.empty()), this.createQueryStatistics(queryInfo), this.createQueryContext(queryInfo.getSession(), queryInfo.getResourceGroupId()), queryInfo.getQueryType(), Instant.ofEpochMilli(queryInfo.getQueryStats().getCreateTime().getMillis())));
    }

    public void queryImmediateFailureEvent(BasicQueryInfo queryInfo, ExecutionFailureInfo failure) {
        this.eventListenerManager.queryCompleted(new QueryCompletedEvent(new QueryMetadata(queryInfo.getQueryId().toString(), queryInfo.getSession().getTransactionId().map(TransactionId::toString), queryInfo.getQuery(), queryInfo.getQueryHash(), queryInfo.getPreparedQuery(), queryInfo.getState().toString(), queryInfo.getSelf(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), queryInfo.getSession().getTraceToken(), Optional.empty()), new QueryStatistics(Duration.ofMillis(0L), Duration.ofMillis(0L), Duration.ofMillis(0L), Duration.ofMillis(queryInfo.getQueryStats().getWaitingForPrerequisitesTime().toMillis()), Duration.ofMillis(queryInfo.getQueryStats().getQueuedTime().toMillis()), Duration.ofMillis(0L), Duration.ofMillis(0L), Duration.ofMillis(0L), Duration.ofMillis(0L), Duration.ofMillis(0L), Optional.empty(), Duration.ofMillis(0L), 0, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0.0, 0.0, 0, true, new RuntimeStats()), this.createQueryContext(queryInfo.getSession(), queryInfo.getResourceGroupId()), new QueryIOMetadata((List)ImmutableList.of(), Optional.empty()), this.createQueryFailureInfo(failure, Optional.empty()), (List)ImmutableList.of(), queryInfo.getQueryType(), (List)ImmutableList.of(), Instant.ofEpochMilli(queryInfo.getQueryStats().getCreateTime().getMillis()), Instant.ofEpochMilli(queryInfo.getQueryStats().getEndTime().getMillis()), Instant.ofEpochMilli(queryInfo.getQueryStats().getEndTime().getMillis()), (List)ImmutableList.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), (List)ImmutableList.of(), (Set)ImmutableSet.of(), (Set)ImmutableSet.of(), (Set)ImmutableSet.of(), Optional.empty(), (Map)ImmutableMap.of(), Optional.empty()));
        QueryMonitor.logQueryTimeline(queryInfo);
    }

    public void queryCompletedEvent(QueryInfo queryInfo) {
        QueryStats queryStats = queryInfo.getQueryStats();
        ImmutableList.Builder stageStatisticsBuilder = ImmutableList.builder();
        if (queryInfo.getOutputStage().isPresent()) {
            QueryMonitor.computeStageStatistics(queryInfo.getOutputStage().get(), (ImmutableList.Builder<StageStatistics>)stageStatisticsBuilder);
        }
        this.eventListenerManager.queryCompleted(new QueryCompletedEvent(this.createQueryMetadata(queryInfo), this.createQueryStatistics(queryInfo), this.createQueryContext(queryInfo.getSession(), queryInfo.getResourceGroupId()), QueryMonitor.getQueryIOMetadata(queryInfo), this.createQueryFailureInfo(queryInfo.getFailureInfo(), queryInfo.getOutputStage()), queryInfo.getWarnings(), queryInfo.getQueryType(), (List)queryInfo.getFailedTasks().orElse((List<TaskId>)ImmutableList.of()).stream().map(TaskId::toString).collect(ImmutableList.toImmutableList()), Instant.ofEpochMilli(queryStats.getCreateTime().getMillis()), Instant.ofEpochMilli(queryStats.getExecutionStartTime().getMillis()), Instant.ofEpochMilli(queryStats.getEndTime() != null ? queryStats.getEndTime().getMillis() : 0L), (List)stageStatisticsBuilder.build(), this.createOperatorStatistics(queryInfo), this.createPlanStatistics(queryInfo.getPlanStatsAndCosts()), (List)this.historyBasedPlanStatisticsTracker.getQueryStats(queryInfo).values().stream().collect(ImmutableList.toImmutableList()), this.getPlanHash(queryInfo.getPlanCanonicalInfo()), this.historyBasedPlanStatisticsTracker.getCanonicalPlan(queryInfo.getQueryId()), SystemSessionProperties.logQueryPlansUsedInHistoryBasedOptimizer(queryInfo.getSession().toSession(this.sessionPropertyManager)) ? this.serializeStatsEquivalentPlan(this.historyBasedPlanStatisticsTracker.getStatsEquivalentPlanRootNode(queryInfo.getQueryId())) : Optional.empty(), queryInfo.getExpandedQuery(), queryInfo.getOptimizerInformation(), queryInfo.getCteInformationList(), queryInfo.getScalarFunctions(), queryInfo.getAggregateFunctions(), queryInfo.getWindowFunctions(), queryInfo.getPrestoSparkExecutionContext(), this.getPlanHash(queryInfo.getPlanCanonicalInfo(), this.historyBasedPlanStatisticsTracker.getStatsEquivalentPlanRootNode(queryInfo.getQueryId())), Optional.of(queryInfo.getPlanIdNodeMap())));
        QueryMonitor.logQueryTimeline(queryInfo);
    }

    private List<PlanStatisticsWithSourceInfo> createPlanStatistics(StatsAndCosts planStatsAndCosts) {
        return (List)planStatsAndCosts.getStats().entrySet().stream().map(entry -> ((PlanNodeStatsEstimate)entry.getValue()).toPlanStatisticsWithSourceInfo((PlanNodeId)entry.getKey())).collect(ImmutableList.toImmutableList());
    }

    private Map<PlanNodeId, Map<PlanCanonicalizationStrategy, String>> getPlanHash(List<CanonicalPlanWithInfo> canonicalPlanWithInfos) {
        HashMap<PlanNodeId, Map<PlanCanonicalizationStrategy, String>> planNodeIdStrategyHashMap = new HashMap<PlanNodeId, Map<PlanCanonicalizationStrategy, String>>();
        for (CanonicalPlanWithInfo canonicalPlanWithInfo : canonicalPlanWithInfos) {
            PlanCanonicalizationStrategy strategy = canonicalPlanWithInfo.getCanonicalPlan().getStrategy();
            PlanNodeId planNodeId = canonicalPlanWithInfo.getCanonicalPlan().getPlan().getId();
            String hash = canonicalPlanWithInfo.getInfo().getHash();
            if (!planNodeIdStrategyHashMap.containsKey(planNodeId)) {
                planNodeIdStrategyHashMap.put(planNodeId, new HashMap());
            }
            ((Map)planNodeIdStrategyHashMap.get(planNodeId)).put(strategy, hash);
        }
        return planNodeIdStrategyHashMap;
    }

    private QueryMetadata createQueryMetadata(QueryInfo queryInfo) {
        return new QueryMetadata(queryInfo.getQueryId().toString(), queryInfo.getSession().getTransactionId().map(TransactionId::toString), queryInfo.getQuery(), queryInfo.getQueryHash(), queryInfo.getPreparedQuery(), queryInfo.getState().toString(), queryInfo.getSelf(), this.createTextQueryPlan(queryInfo), this.createJsonQueryPlan(queryInfo), this.createGraphvizQueryPlan(queryInfo), queryInfo.getOutputStage().flatMap(stage -> this.stageInfoCodec.toJsonWithLengthLimit(stage, this.maxJsonLimit)), (List)queryInfo.getRuntimeOptimizedStages().orElse((List<StageId>)ImmutableList.of()).stream().map(stageId -> String.valueOf(stageId.getId())).collect(ImmutableList.toImmutableList()), queryInfo.getSession().getTraceToken(), Optional.ofNullable(queryInfo.getUpdateType()));
    }

    private List<OperatorStatistics> createOperatorStatistics(QueryInfo queryInfo) {
        Map<PlanNodeId, PlanNodeStatsEstimate> estimateMap = queryInfo.getPlanStatsAndCosts().getStats();
        Map<PlanNodeId, PlanNode> planNodeIdMap = queryInfo.getPlanIdNodeMap();
        return (List)queryInfo.getQueryStats().getOperatorSummaries().stream().map(operatorSummary -> new OperatorStatistics(operatorSummary.getStageId(), operatorSummary.getStageExecutionId(), operatorSummary.getPipelineId(), operatorSummary.getOperatorId(), operatorSummary.getPlanNodeId(), operatorSummary.getOperatorType(), operatorSummary.getTotalDrivers(), operatorSummary.getAddInputCalls(), operatorSummary.getAddInputWall(), operatorSummary.getAddInputCpu(), DataSize.succinctBytes((long)operatorSummary.getAddInputAllocationInBytes()), DataSize.succinctBytes((long)operatorSummary.getRawInputDataSizeInBytes()), operatorSummary.getRawInputPositions(), DataSize.succinctBytes((long)operatorSummary.getInputDataSizeInBytes()), operatorSummary.getInputPositions(), operatorSummary.getSumSquaredInputPositions(), operatorSummary.getGetOutputCalls(), operatorSummary.getGetOutputWall(), operatorSummary.getGetOutputCpu(), DataSize.succinctBytes((long)operatorSummary.getGetOutputAllocationInBytes()), DataSize.succinctBytes((long)operatorSummary.getOutputDataSizeInBytes()), operatorSummary.getOutputPositions(), DataSize.succinctBytes((long)operatorSummary.getPhysicalWrittenDataSizeInBytes()), operatorSummary.getBlockedWall(), operatorSummary.getFinishCalls(), operatorSummary.getFinishWall(), operatorSummary.getFinishCpu(), DataSize.succinctBytes((long)operatorSummary.getFinishAllocationInBytes()), DataSize.succinctBytes((long)operatorSummary.getUserMemoryReservationInBytes()), DataSize.succinctBytes((long)operatorSummary.getRevocableMemoryReservationInBytes()), DataSize.succinctBytes((long)operatorSummary.getSystemMemoryReservationInBytes()), DataSize.succinctBytes((long)operatorSummary.getPeakUserMemoryReservationInBytes()), DataSize.succinctBytes((long)operatorSummary.getPeakSystemMemoryReservationInBytes()), DataSize.succinctBytes((long)operatorSummary.getPeakTotalMemoryReservationInBytes()), DataSize.succinctBytes((long)operatorSummary.getSpilledDataSizeInBytes()), Optional.ofNullable(operatorSummary.getInfo()).map(arg_0 -> this.operatorInfoCodec.toJson(arg_0)), operatorSummary.getRuntimeStats(), this.getPlanNodeEstimateOutputSize(operatorSummary.getPlanNodeId(), estimateMap, planNodeIdMap), estimateMap.containsKey(operatorSummary.getPlanNodeId()) ? ((PlanNodeStatsEstimate)estimateMap.get(operatorSummary.getPlanNodeId())).getOutputRowCount() : Double.NaN)).collect(ImmutableList.toImmutableList());
    }

    private double getPlanNodeEstimateOutputSize(PlanNodeId nodeId, Map<PlanNodeId, PlanNodeStatsEstimate> estimateMap, Map<PlanNodeId, PlanNode> planNodeIdMap) {
        if (!estimateMap.containsKey(nodeId)) {
            return Double.NaN;
        }
        Preconditions.checkArgument((boolean)planNodeIdMap.containsKey(nodeId), (Object)"plan node does not exist in planNodeIdMap");
        return estimateMap.get(nodeId).getOutputSizeInBytes(planNodeIdMap.get(nodeId));
    }

    private QueryStatistics createQueryStatistics(QueryInfo queryInfo) {
        QueryStats queryStats = queryInfo.getQueryStats();
        return new QueryStatistics(Duration.ofMillis(queryStats.getTotalCpuTime().toMillis()), Duration.ofMillis(queryStats.getRetriedCpuTime().toMillis()), Duration.ofMillis(queryStats.getElapsedTime().toMillis()), Duration.ofMillis(queryStats.getWaitingForPrerequisitesTime().toMillis()), Duration.ofMillis(queryStats.getQueuedTime().toMillis()), Duration.ofMillis(queryStats.getResourceWaitingTime().toMillis()), Duration.ofMillis(queryStats.getSemanticAnalyzingTime().toMillis()), Duration.ofMillis(queryStats.getColumnAccessPermissionCheckingTime().toMillis()), Duration.ofMillis(queryStats.getDispatchingTime().toMillis()), Duration.ofMillis(queryStats.getTotalPlanningTime().toMillis()), Optional.of(Duration.ofMillis(queryStats.getAnalysisTime().toMillis())), Duration.ofMillis(queryStats.getExecutionTime().toMillis()), queryStats.getPeakRunningTasks(), queryStats.getPeakUserMemoryReservation().toBytes(), queryStats.getPeakTotalMemoryReservation().toBytes(), queryStats.getPeakTaskUserMemory().toBytes(), queryStats.getPeakTaskTotalMemory().toBytes(), queryStats.getPeakNodeTotalMemory().toBytes(), queryStats.getShuffledDataSize().toBytes(), queryStats.getShuffledPositions(), queryStats.getRawInputDataSize().toBytes(), queryStats.getRawInputPositions(), queryStats.getOutputDataSize().toBytes(), queryStats.getOutputPositions(), queryStats.getWrittenOutputLogicalDataSize().toBytes(), queryStats.getWrittenOutputPositions(), queryStats.getWrittenIntermediatePhysicalDataSize().toBytes(), queryStats.getSpilledDataSize().toBytes(), queryStats.getCumulativeUserMemory(), queryStats.getCumulativeTotalMemory(), queryStats.getCompletedDrivers(), queryInfo.isFinalQueryInfo(), queryStats.getRuntimeStats());
    }

    private QueryStatistics createQueryStatistics(BasicQueryInfo basicQueryInfo) {
        BasicQueryStats queryStats = basicQueryInfo.getQueryStats();
        return new QueryStatistics(Duration.ofMillis(queryStats.getTotalCpuTime().toMillis()), Duration.ofMillis(0L), Duration.ofMillis(queryStats.getElapsedTime().toMillis()), Duration.ofMillis(queryStats.getWaitingForPrerequisitesTime().toMillis()), Duration.ofMillis(queryStats.getQueuedTime().toMillis()), Duration.ofMillis(0L), Duration.ofMillis(0L), Duration.ofMillis(0L), Duration.ofMillis(0L), Duration.ofMillis(0L), Optional.of(Duration.ofMillis(0L)), Duration.ofMillis(queryStats.getExecutionTime().toMillis()), queryStats.getPeakRunningTasks(), queryStats.getPeakUserMemoryReservation().toBytes(), queryStats.getPeakTotalMemoryReservation().toBytes(), 0L, 0L, 0L, 0L, 0L, queryStats.getRawInputDataSize().toBytes(), queryStats.getRawInputPositions(), 0L, 0L, 0L, 0L, 0L, 0L, queryStats.getCumulativeUserMemory(), queryStats.getCumulativeTotalMemory(), queryStats.getCompletedDrivers(), false, new RuntimeStats());
    }

    private QueryContext createQueryContext(SessionRepresentation session, Optional<ResourceGroupId> resourceGroup) {
        return new QueryContext(session.getUser(), session.getPrincipal(), session.getRemoteUserAddress(), session.getUserAgent(), session.getClientInfo(), session.getClientTags(), session.getSource(), session.getCatalog(), session.getSchema(), resourceGroup, QueryMonitor.mergeSessionAndCatalogProperties(session), session.getResourceEstimates(), this.serverAddress, this.serverVersion, this.environment, this.workerType);
    }

    private Optional<String> createTextQueryPlan(QueryInfo queryInfo) {
        try {
            if (queryInfo.getOutputStage().isPresent()) {
                return Optional.of(PlanPrinter.textDistributedPlan(queryInfo.getOutputStage().get(), this.functionAndTypeManager, queryInfo.getSession().toSession(this.sessionPropertyManager), false));
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Error creating explain plan for query %s", new Object[]{queryInfo.getQueryId()});
        }
        return Optional.empty();
    }

    private Optional<String> createJsonQueryPlan(QueryInfo queryInfo) {
        try {
            if (queryInfo.getOutputStage().isPresent()) {
                return Optional.of(PlanPrinter.jsonDistributedPlan(queryInfo.getOutputStage().get(), this.functionAndTypeManager, queryInfo.getSession().toSession(this.sessionPropertyManager)));
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Error creating json plan for query %s: %s", new Object[]{queryInfo.getQueryId(), e});
        }
        return Optional.empty();
    }

    private Optional<String> createGraphvizQueryPlan(QueryInfo queryInfo) {
        try {
            if (queryInfo.getOutputStage().isPresent()) {
                return Optional.of(PlanPrinter.graphvizDistributedPlan(queryInfo.getOutputStage().get(), this.functionAndTypeManager, queryInfo.getSession().toSession(this.sessionPropertyManager)));
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Error creating graphviz plan for query %s: %s", new Object[]{queryInfo.getQueryId(), e});
        }
        return Optional.empty();
    }

    private static QueryIOMetadata getQueryIOMetadata(QueryInfo queryInfo) {
        ImmutableList.Builder inputs = ImmutableList.builder();
        for (Input input : queryInfo.getInputs()) {
            inputs.add((Object)new QueryInputMetadata(input.getConnectorId().getCatalogName(), input.getSchema(), input.getTable(), input.getColumns().stream().map(column -> new Column(column.getName(), column.getType())).collect(Collectors.toList()), input.getConnectorInfo(), input.getStatistics(), input.getSerializedCommitOutput()));
        }
        Optional<Object> output = Optional.empty();
        if (queryInfo.getOutput().isPresent()) {
            Optional<TableFinishInfo> tableFinishInfo = queryInfo.getQueryStats().getOperatorSummaries().stream().map(OperatorStats::getInfo).filter(TableFinishInfo.class::isInstance).map(TableFinishInfo.class::cast).findFirst();
            Optional<List> outputColumns = queryInfo.getOutput().get().getColumns().map(columns -> (List)columns.stream().map(column -> new Column(column.getName(), column.getType())).collect(ImmutableList.toImmutableList()));
            output = Optional.of(new QueryOutputMetadata(queryInfo.getOutput().get().getConnectorId().getCatalogName(), queryInfo.getOutput().get().getSchema(), queryInfo.getOutput().get().getTable(), tableFinishInfo.map(TableFinishInfo::getSerializedConnectorOutputMetadata), tableFinishInfo.map(TableFinishInfo::isJsonLengthLimitExceeded), queryInfo.getOutput().get().getSerializedCommitOutput(), outputColumns));
        }
        return new QueryIOMetadata((List)inputs.build(), output);
    }

    private Optional<QueryFailureInfo> createQueryFailureInfo(ExecutionFailureInfo failureInfo, Optional<StageInfo> outputStage) {
        if (failureInfo == null) {
            return Optional.empty();
        }
        Optional<String> failedTask = outputStage.flatMap(QueryMonitor::findFailedTask);
        return Optional.of(new QueryFailureInfo(failureInfo.getErrorCode(), Optional.ofNullable(failureInfo.getType()), Optional.ofNullable(failureInfo.getMessage()), failedTask.map(task -> task.getTaskId().toString()), failedTask.map(task -> task.getTaskStatus().getSelf().getHost()), this.executionFailureInfoCodec.toJson((Object)failureInfo)));
    }

    private static Optional<TaskInfo> findFailedTask(StageInfo stageInfo) {
        for (StageInfo subStage : stageInfo.getSubStages()) {
            Optional<TaskInfo> task = QueryMonitor.findFailedTask(subStage);
            if (!task.isPresent()) continue;
            return task;
        }
        return stageInfo.getLatestAttemptExecutionInfo().getTasks().stream().filter(taskInfo -> taskInfo.getTaskStatus().getState() == TaskState.FAILED).findFirst();
    }

    private static Map<String, String> mergeSessionAndCatalogProperties(SessionRepresentation session) {
        LinkedHashMap<String, String> mergedProperties = new LinkedHashMap<String, String>(session.getSystemProperties());
        for (Map.Entry<String, Map<String, String>> entry : session.getUnprocessedCatalogProperties().entrySet()) {
            for (Map.Entry<String, String> entry2 : entry.getValue().entrySet()) {
                mergedProperties.put(entry.getKey() + "." + entry2.getKey(), entry2.getValue());
            }
        }
        for (Map.Entry<String, Map<String, String>> entry : session.getCatalogProperties().entrySet()) {
            for (Map.Entry<String, String> entry2 : entry.getValue().entrySet()) {
                mergedProperties.put(((ConnectorId)entry.getKey()).getCatalogName() + "." + entry2.getKey(), entry2.getValue());
            }
        }
        return ImmutableMap.copyOf(mergedProperties);
    }

    private static void logQueryTimeline(QueryInfo queryInfo) {
        try {
            QueryStats queryStats = queryInfo.getQueryStats();
            long queryStartTime = queryStats.getCreateTimeInMillis();
            long queryEndTime = queryStats.getEndTimeInMillis();
            if (queryStartTime == 0L || queryEndTime == 0L) {
                return;
            }
            long planning = queryStats.getTotalPlanningTime().toMillis();
            List<StageInfo> stages = StageInfo.getAllStages(queryInfo.getOutputStage());
            long firstTaskStartTime = queryEndTime;
            long lastTaskStartTime = queryStartTime + planning;
            long lastTaskEndTime = queryStartTime + planning;
            for (StageInfo stage : stages) {
                if (!stage.getSubStages().isEmpty()) continue;
                for (TaskInfo taskInfo : stage.getLatestAttemptExecutionInfo().getTasks()) {
                    long endTimeInMillis;
                    long lastStartTimeInMillis;
                    TaskStats taskStats = taskInfo.getStats();
                    long firstStartTimeInMillis = taskStats.getFirstStartTimeInMillis();
                    if (firstStartTimeInMillis != 0L) {
                        firstTaskStartTime = Math.min(firstStartTimeInMillis, firstTaskStartTime);
                    }
                    if ((lastStartTimeInMillis = taskStats.getLastStartTimeInMillis()) != 0L) {
                        lastTaskStartTime = Math.max(lastStartTimeInMillis, lastTaskStartTime);
                    }
                    if ((endTimeInMillis = taskStats.getEndTimeInMillis()) == 0L) continue;
                    lastTaskEndTime = Math.max(endTimeInMillis, lastTaskEndTime);
                }
            }
            long elapsed = Math.max(queryEndTime - queryStartTime, 0L);
            long scheduling = Math.max(firstTaskStartTime - queryStartTime - planning, 0L);
            long running = Math.max(lastTaskEndTime - firstTaskStartTime, 0L);
            long finishing = Math.max(queryEndTime - lastTaskEndTime, 0L);
            QueryMonitor.logQueryTimeline(queryInfo.getQueryId(), queryInfo.getSession().getTransactionId().map(TransactionId::toString).orElse(""), elapsed, planning, scheduling, running, finishing, queryStartTime, queryEndTime);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error logging query timeline");
        }
    }

    private static void logQueryTimeline(BasicQueryInfo queryInfo) {
        long queryStartTimeInMillis = queryInfo.getQueryStats().getCreateTimeInMillis();
        long queryEndTimeInMillis = queryInfo.getQueryStats().getEndTimeInMillis();
        if (queryStartTimeInMillis == 0L || queryEndTimeInMillis == 0L) {
            return;
        }
        long elapsed = Math.max(queryEndTimeInMillis - queryStartTimeInMillis, 0L);
        QueryMonitor.logQueryTimeline(queryInfo.getQueryId(), queryInfo.getSession().getTransactionId().map(TransactionId::toString).orElse(""), elapsed, elapsed, 0L, 0L, 0L, queryStartTimeInMillis, queryEndTimeInMillis);
    }

    private static void logQueryTimeline(QueryId queryId, String transactionId, long elapsedMillis, long planningMillis, long schedulingMillis, long runningMillis, long finishingMillis, long queryStartTimeInMillis, long queryEndTimeInMillis) {
        log.info("TIMELINE: Query %s :: Transaction:[%s] :: elapsed %sms :: planning %sms :: scheduling %sms :: running %sms :: finishing %sms :: begin %sms :: end %sms", new Object[]{queryId, transactionId, elapsedMillis, planningMillis, schedulingMillis, runningMillis, finishingMillis, queryStartTimeInMillis, queryEndTimeInMillis});
    }

    private static ResourceDistribution createResourceDistribution(Distribution.DistributionSnapshot distributionSnapshot) {
        return new ResourceDistribution(distributionSnapshot.getP25(), distributionSnapshot.getP50(), distributionSnapshot.getP75(), distributionSnapshot.getP90(), distributionSnapshot.getP95(), distributionSnapshot.getP99(), distributionSnapshot.getMin(), distributionSnapshot.getMax(), (long)distributionSnapshot.getTotal(), distributionSnapshot.getTotal() / distributionSnapshot.getCount());
    }

    private static void computeStageStatistics(StageInfo stageInfo, ImmutableList.Builder<StageStatistics> stageStatisticsBuilder) {
        Distribution cpuDistribution = new Distribution();
        Distribution memoryDistribution = new Distribution();
        StageExecutionInfo executionInfo = stageInfo.getLatestAttemptExecutionInfo();
        for (TaskInfo taskInfo : executionInfo.getTasks()) {
            cpuDistribution.add(TimeUnit.NANOSECONDS.toMillis(taskInfo.getStats().getTotalCpuTimeInNanos()));
            memoryDistribution.add(taskInfo.getStats().getPeakTotalMemoryInBytes());
        }
        stageStatisticsBuilder.add((Object)new StageStatistics(stageInfo.getStageId().getId(), executionInfo.getStats().getGcInfo().getStageExecutionId(), executionInfo.getTasks().size(), executionInfo.getStats().getTotalScheduledTime(), executionInfo.getStats().getTotalCpuTime(), executionInfo.getStats().getRetriedCpuTime(), executionInfo.getStats().getTotalBlockedTime(), DataSize.succinctBytes((long)executionInfo.getStats().getRawInputDataSizeInBytes()), DataSize.succinctBytes((long)executionInfo.getStats().getProcessedInputDataSizeInBytes()), DataSize.succinctBytes((long)executionInfo.getStats().getPhysicalWrittenDataSizeInBytes()), executionInfo.getStats().getGcInfo(), QueryMonitor.createResourceDistribution(cpuDistribution.snapshot()), QueryMonitor.createResourceDistribution(memoryDistribution.snapshot())));
        stageInfo.getSubStages().forEach(subStage -> QueryMonitor.computeStageStatistics(subStage, stageStatisticsBuilder));
    }

    private Map<PlanCanonicalizationStrategy, String> getPlanHash(List<CanonicalPlanWithInfo> canonicalPlanWithInfos, Optional<PlanNode> root) {
        if (root.isPresent()) {
            return (Map)canonicalPlanWithInfos.stream().filter(x -> x.getCanonicalPlan().getPlan().equals(root.get())).collect(ImmutableMap.toImmutableMap(x -> x.getCanonicalPlan().getStrategy(), x -> x.getInfo().getHash(), (a, b) -> a));
        }
        return ImmutableMap.of();
    }

    private Optional<String> serializeStatsEquivalentPlan(Optional<PlanNode> root) {
        if (root.isPresent()) {
            try {
                return Optional.of(OBJECT_MAPPER.writeValueAsString(root));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }
}

