/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.SimpleStatsRule;
import com.facebook.presto.cost.StatsNormalizer;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.cost.StatsUtil;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.statistics.ColumnStatistics;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TableScanStatsRule
extends SimpleStatsRule<TableScanNode> {
    private static final Pattern<TableScanNode> PATTERN = Patterns.tableScan();
    private final Metadata metadata;

    public TableScanStatsRule(Metadata metadata, StatsNormalizer normalizer) {
        super(normalizer);
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public Pattern<TableScanNode> getPattern() {
        return PATTERN;
    }

    @Override
    protected Optional<PlanNodeStatsEstimate> doCalculate(TableScanNode node, StatsProvider sourceStats, Lookup lookup, Session session, TypeProvider types) {
        Constraint constraint = new Constraint(node.getCurrentConstraint());
        TableStatistics tableStatistics = this.metadata.getTableStatistics(session, node.getTable(), (List<ColumnHandle>)ImmutableList.copyOf(node.getAssignments().values()), (Constraint<ColumnHandle>)constraint);
        HashMap<VariableReferenceExpression, VariableStatsEstimate> outputVariableStats = new HashMap<VariableReferenceExpression, VariableStatsEstimate>();
        for (Map.Entry entry : node.getAssignments().entrySet()) {
            Optional<ColumnStatistics> columnStatistics = Optional.ofNullable((ColumnStatistics)tableStatistics.getColumnStatistics().get(entry.getValue()));
            outputVariableStats.put((VariableReferenceExpression)entry.getKey(), columnStatistics.map(statistics -> StatsUtil.toVariableStatsEstimate(tableStatistics, statistics)).orElse(VariableStatsEstimate.unknown()));
        }
        return Optional.of(PlanNodeStatsEstimate.builder().setOutputRowCount(tableStatistics.getRowCount().getValue()).setTotalSize(tableStatistics.getTotalSize().getValue()).setConfidence(tableStatistics.getConfidence()).addVariableStatistics(outputVariableStats).build());
    }
}

