/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.statistics.ColumnStatistics;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.facebook.presto.sql.InterpretedFunctionInvoker;
import java.util.Collections;
import java.util.Objects;
import java.util.OptionalDouble;

final class StatsUtil {
    private StatsUtil() {
    }

    static OptionalDouble toStatsRepresentation(Metadata metadata, Session session, Type type, Object value) {
        return StatsUtil.toStatsRepresentation(metadata.getFunctionAndTypeManager(), session.toConnectorSession(), type, value);
    }

    static OptionalDouble toStatsRepresentation(FunctionAndTypeManager functionAndTypeManager, ConnectorSession session, Type type, Object value) {
        Objects.requireNonNull(value, "value is null");
        if (StatsUtil.convertibleToDoubleWithCast(type)) {
            InterpretedFunctionInvoker functionInvoker = new InterpretedFunctionInvoker(functionAndTypeManager);
            FunctionHandle cast = functionAndTypeManager.lookupCast(CastType.CAST, type, (Type)DoubleType.DOUBLE);
            return OptionalDouble.of((Double)functionInvoker.invoke(cast, session.getSqlFunctionProperties(), Collections.singletonList(value)));
        }
        if (DateType.DATE.equals((Object)type)) {
            return OptionalDouble.of(((Long)value).doubleValue());
        }
        return OptionalDouble.empty();
    }

    private static boolean convertibleToDoubleWithCast(Type type) {
        return type instanceof DecimalType || DoubleType.DOUBLE.equals((Object)type) || RealType.REAL.equals((Object)type) || BigintType.BIGINT.equals((Object)type) || IntegerType.INTEGER.equals((Object)type) || SmallintType.SMALLINT.equals((Object)type) || TinyintType.TINYINT.equals((Object)type) || BooleanType.BOOLEAN.equals((Object)type);
    }

    public static VariableStatsEstimate toVariableStatsEstimate(TableStatistics tableStatistics, ColumnStatistics columnStatistics) {
        double nullsFraction = columnStatistics.getNullsFraction().getValue();
        double nonNullRowsCount = tableStatistics.getRowCount().getValue() * (1.0 - nullsFraction);
        double averageRowSize = nonNullRowsCount == 0.0 ? 0.0 : columnStatistics.getDataSize().getValue() / nonNullRowsCount;
        VariableStatsEstimate.Builder result = VariableStatsEstimate.builder();
        result.setNullsFraction(nullsFraction);
        result.setDistinctValuesCount(columnStatistics.getDistinctValuesCount().getValue());
        result.setAverageRowSize(averageRowSize);
        columnStatistics.getRange().ifPresent(range -> {
            result.setLowValue(range.getMin());
            result.setHighValue(range.getMax());
        });
        result.setHistogram(columnStatistics.getHistogram());
        return result.build();
    }
}

