/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import java.util.function.BiFunction;

public final class SemiJoinStatsCalculator {
    private static final double MIN_ANTI_JOIN_FILTER_COEFFICIENT = 0.5;

    private SemiJoinStatsCalculator() {
    }

    public static PlanNodeStatsEstimate computeSemiJoin(PlanNodeStatsEstimate sourceStats, PlanNodeStatsEstimate filteringSourceStats, VariableReferenceExpression sourceJoinVariable, VariableReferenceExpression filteringSourceJoinVariable) {
        return SemiJoinStatsCalculator.compute(sourceStats, filteringSourceStats, sourceJoinVariable, filteringSourceJoinVariable, (sourceJoinSymbolStats, filteringSourceJoinSymbolStats) -> Double.min(filteringSourceJoinSymbolStats.getDistinctValuesCount(), sourceJoinSymbolStats.getDistinctValuesCount()));
    }

    public static PlanNodeStatsEstimate computeAntiJoin(PlanNodeStatsEstimate sourceStats, PlanNodeStatsEstimate filteringSourceStats, VariableReferenceExpression sourceJoinVariable, VariableReferenceExpression filteringSourceJoinVariable) {
        return SemiJoinStatsCalculator.compute(sourceStats, filteringSourceStats, sourceJoinVariable, filteringSourceJoinVariable, (sourceJoinSymbolStats, filteringSourceJoinSymbolStats) -> Double.max(sourceJoinSymbolStats.getDistinctValuesCount() * 0.5, sourceJoinSymbolStats.getDistinctValuesCount() - filteringSourceJoinSymbolStats.getDistinctValuesCount()));
    }

    private static PlanNodeStatsEstimate compute(PlanNodeStatsEstimate sourceStats, PlanNodeStatsEstimate filteringSourceStats, VariableReferenceExpression sourceJoinVariable, VariableReferenceExpression filteringSourceJoinVariable, BiFunction<VariableStatsEstimate, VariableStatsEstimate, Double> retainedNdvProvider) {
        VariableStatsEstimate sourceJoinSymbolStats = sourceStats.getVariableStatistics(sourceJoinVariable);
        VariableStatsEstimate filteringSourceJoinSymbolStats = filteringSourceStats.getVariableStatistics(filteringSourceJoinVariable);
        double retainedNdv = retainedNdvProvider.apply(sourceJoinSymbolStats, filteringSourceJoinSymbolStats);
        VariableStatsEstimate newSourceJoinSymbolStats = VariableStatsEstimate.buildFrom(sourceJoinSymbolStats).setNullsFraction(0.0).setDistinctValuesCount(retainedNdv).build();
        double sourceDistinctValuesCount = sourceJoinSymbolStats.getDistinctValuesCount();
        if (sourceDistinctValuesCount == 0.0) {
            return PlanNodeStatsEstimate.buildFrom(sourceStats).addVariableStatistics(sourceJoinVariable, newSourceJoinSymbolStats).setOutputRowCount(0.0).build();
        }
        double filterFactor = sourceJoinSymbolStats.getValuesFraction() * retainedNdv / sourceDistinctValuesCount;
        double outputRowCount = sourceStats.getOutputRowCount() * filterFactor;
        return PlanNodeStatsEstimate.buildFrom(sourceStats).addVariableStatistics(sourceJoinVariable, newSourceJoinSymbolStats).setOutputRowCount(outputRowCount).build();
    }
}

