/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.cost.PlanCostEstimate;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.stream.Stream;

public class LocalCostEstimate {
    private final double cpuCost;
    private final double maxMemory;
    private final double networkCost;

    public static LocalCostEstimate unknown() {
        return LocalCostEstimate.of(Double.NaN, Double.NaN, Double.NaN);
    }

    public static LocalCostEstimate zero() {
        return LocalCostEstimate.of(0.0, 0.0, 0.0);
    }

    public static LocalCostEstimate ofCpu(double cpuCost) {
        return LocalCostEstimate.of(cpuCost, 0.0, 0.0);
    }

    public static LocalCostEstimate ofNetwork(double networkCost) {
        return LocalCostEstimate.of(0.0, 0.0, networkCost);
    }

    public static LocalCostEstimate of(double cpuCost, double maxMemory, double networkCost) {
        return new LocalCostEstimate(cpuCost, maxMemory, networkCost);
    }

    private LocalCostEstimate(double cpuCost, double maxMemory, double networkCost) {
        this.cpuCost = cpuCost;
        this.maxMemory = maxMemory;
        this.networkCost = networkCost;
    }

    public double getCpuCost() {
        return this.cpuCost;
    }

    public double getMaxMemory() {
        return this.maxMemory;
    }

    public double getNetworkCost() {
        return this.networkCost;
    }

    @Deprecated
    public PlanCostEstimate toPlanCost() {
        return new PlanCostEstimate(this.cpuCost, this.maxMemory, this.maxMemory, this.networkCost);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("cpuCost", this.cpuCost).add("maxMemory", this.maxMemory).add("networkCost", this.networkCost).toString();
    }

    public static LocalCostEstimate addPartialComponents(LocalCostEstimate one, LocalCostEstimate two, LocalCostEstimate ... more) {
        return Stream.concat(Stream.of(one, two), Stream.of(more)).reduce(LocalCostEstimate.zero(), (a, b) -> new LocalCostEstimate(a.cpuCost + b.cpuCost, a.maxMemory + b.maxMemory, a.networkCost + b.networkCost));
    }

    public static LocalCostEstimate addPartialComponents(List<LocalCostEstimate> planList) {
        return planList.stream().reduce(LocalCostEstimate.zero(), (a, b) -> new LocalCostEstimate(a.cpuCost + b.cpuCost, a.maxMemory + b.maxMemory, a.networkCost + b.networkCost));
    }
}

