/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.common.plan.PlanCanonicalizationStrategy;
import com.facebook.presto.cost.HistoryBasedOptimizationConfig;
import com.facebook.presto.cost.HistoryBasedPlanStatisticsCalculator;
import com.facebook.presto.cost.HistoryBasedPlanStatisticsTracker;
import com.facebook.presto.cost.HistoryBasedStatisticsCacheManager;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.spi.statistics.EmptyPlanStatisticsProvider;
import com.facebook.presto.spi.statistics.HistoryBasedPlanStatisticsProvider;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.CachingPlanCanonicalInfoProvider;
import com.facebook.presto.sql.planner.PlanCanonicalInfoProvider;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.inject.Inject;
import java.util.List;
import java.util.Objects;

public class HistoryBasedPlanStatisticsManager {
    private final SessionPropertyManager sessionPropertyManager;
    private final HistoryBasedStatisticsCacheManager historyBasedStatisticsCacheManager;
    private final PlanCanonicalInfoProvider planCanonicalInfoProvider;
    private final HistoryBasedOptimizationConfig config;
    private HistoryBasedPlanStatisticsProvider historyBasedPlanStatisticsProvider = EmptyPlanStatisticsProvider.getInstance();
    private boolean statisticsProviderAdded;
    private final boolean isNativeExecution;
    private final String serverVersion;

    @Inject
    public HistoryBasedPlanStatisticsManager(ObjectMapper objectMapper, SessionPropertyManager sessionPropertyManager, Metadata metadata, HistoryBasedOptimizationConfig config, FeaturesConfig featuresConfig, NodeVersion nodeVersion) {
        Objects.requireNonNull(objectMapper, "objectMapper is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.historyBasedStatisticsCacheManager = new HistoryBasedStatisticsCacheManager();
        ObjectMapper newObjectMapper = objectMapper.copy().configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true).configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        this.planCanonicalInfoProvider = new CachingPlanCanonicalInfoProvider(this.historyBasedStatisticsCacheManager, newObjectMapper, metadata);
        this.config = Objects.requireNonNull(config, "config is null");
        this.isNativeExecution = featuresConfig.isNativeExecutionEnabled();
        this.serverVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null").toString();
    }

    public void addHistoryBasedPlanStatisticsProviderFactory(HistoryBasedPlanStatisticsProvider historyBasedPlanStatisticsProvider) {
        if (this.statisticsProviderAdded) {
            throw new IllegalStateException("historyBasedPlanStatisticsProvider can only be set once");
        }
        this.historyBasedPlanStatisticsProvider = historyBasedPlanStatisticsProvider;
        this.statisticsProviderAdded = true;
    }

    public HistoryBasedPlanStatisticsCalculator getHistoryBasedPlanStatisticsCalculator(StatsCalculator delegate) {
        return new HistoryBasedPlanStatisticsCalculator(() -> this.historyBasedPlanStatisticsProvider, this.historyBasedStatisticsCacheManager, delegate, this.planCanonicalInfoProvider);
    }

    public HistoryBasedPlanStatisticsTracker getHistoryBasedPlanStatisticsTracker() {
        return new HistoryBasedPlanStatisticsTracker(() -> this.historyBasedPlanStatisticsProvider, this.historyBasedStatisticsCacheManager, this.sessionPropertyManager, this.config, this.isNativeExecution, this.serverVersion);
    }

    public PlanCanonicalInfoProvider getPlanCanonicalInfoProvider() {
        return this.planCanonicalInfoProvider;
    }

    public static List<PlanCanonicalizationStrategy> historyBasedPlanCanonicalizationStrategyList(Session session) {
        return SystemSessionProperties.getHistoryOptimizationPlanCanonicalizationStrategies(session);
    }
}

