/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.SimpleStatsRule;
import com.facebook.presto.cost.StatsNormalizer;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.statistics.SourceInfo;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.plan.Patterns;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AggregationStatsRule
extends SimpleStatsRule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation();

    public AggregationStatsRule(StatsNormalizer normalizer) {
        super(normalizer);
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    protected Optional<PlanNodeStatsEstimate> doCalculate(AggregationNode node, StatsProvider statsProvider, Lookup lookup, Session session, TypeProvider types) {
        if (node.getGroupingSetCount() != 1) {
            return Optional.empty();
        }
        if (node.getStep() != AggregationNode.Step.SINGLE) {
            return Optional.empty();
        }
        return Optional.of(AggregationStatsRule.groupBy(statsProvider.getStats(node.getSource()), node.getGroupingKeys(), node.getAggregations()));
    }

    public static PlanNodeStatsEstimate groupBy(PlanNodeStatsEstimate sourceStats, Collection<VariableReferenceExpression> groupByVariables, Map<VariableReferenceExpression, AggregationNode.Aggregation> aggregations) {
        PlanNodeStatsEstimate.Builder result = PlanNodeStatsEstimate.builder();
        if (AggregationStatsRule.isGlobalAggregation(groupByVariables)) {
            result.setConfidence(SourceInfo.ConfidenceLevel.FACT);
        }
        for (VariableReferenceExpression groupByVariable : groupByVariables) {
            VariableStatsEstimate symbolStatistics = sourceStats.getVariableStatistics(groupByVariable);
            result.addVariableStatistics(groupByVariable, symbolStatistics.mapNullsFraction(nullsFraction -> {
                if (nullsFraction == 0.0) {
                    return 0.0;
                }
                return 1.0 / (symbolStatistics.getDistinctValuesCount() + 1.0);
            }));
        }
        double rowsCount = 1.0;
        for (VariableReferenceExpression variableReferenceExpression : groupByVariables) {
            VariableStatsEstimate symbolStatistics = sourceStats.getVariableStatistics(variableReferenceExpression);
            boolean nullRow = symbolStatistics.getNullsFraction() != 0.0;
            rowsCount *= symbolStatistics.getDistinctValuesCount() + (double)nullRow;
        }
        result.setOutputRowCount(Math.min(rowsCount, sourceStats.getOutputRowCount()));
        for (Map.Entry entry : aggregations.entrySet()) {
            result.addVariableStatistics((VariableReferenceExpression)entry.getKey(), AggregationStatsRule.estimateAggregationStats((AggregationNode.Aggregation)entry.getValue(), sourceStats));
        }
        return result.build();
    }

    private static VariableStatsEstimate estimateAggregationStats(AggregationNode.Aggregation aggregation, PlanNodeStatsEstimate sourceStats) {
        Objects.requireNonNull(aggregation, "aggregation is null");
        Objects.requireNonNull(sourceStats, "sourceStats is null");
        return VariableStatsEstimate.unknown();
    }

    private static boolean isGlobalAggregation(Collection<VariableReferenceExpression> groupingKeys) {
        return groupingKeys.isEmpty();
    }
}

