/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.catalogserver;

import com.facebook.drift.annotations.ThriftMethod;
import com.facebook.drift.annotations.ThriftService;
import com.facebook.presto.SessionRepresentation;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.spi.analyzer.ViewDefinition;
import com.facebook.presto.transaction.TransactionInfo;
import com.facebook.presto.transaction.TransactionManager;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

@ThriftService(value="presto-catalog-server", idlName="PrestoCatalogServer")
public class CatalogServer {
    private static final String EMPTY_STRING = "";
    private final Metadata metadata;
    private final SessionPropertyManager sessionPropertyManager;
    private final TransactionManager transactionManager;
    private final ObjectMapper objectMapper;

    @Inject
    public CatalogServer(MetadataManager metadata, SessionPropertyManager sessionPropertyManager, TransactionManager transactionManager, ObjectMapper objectMapper) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.objectMapper = Objects.requireNonNull(objectMapper, "handleResolver is null");
    }

    @ThriftMethod
    public boolean schemaExists(TransactionInfo transactionInfo, SessionRepresentation session, CatalogSchemaName schema) {
        this.transactionManager.tryRegisterTransaction(transactionInfo);
        return this.metadata.getMetadataResolver(session.toSession(this.sessionPropertyManager)).schemaExists(schema);
    }

    @ThriftMethod
    public boolean catalogExists(TransactionInfo transactionInfo, SessionRepresentation session, String catalogName) {
        this.transactionManager.tryRegisterTransaction(transactionInfo);
        return this.metadata.getMetadataResolver(session.toSession(this.sessionPropertyManager)).catalogExists(catalogName);
    }

    @ThriftMethod
    public String listSchemaNames(TransactionInfo transactionInfo, SessionRepresentation session, String catalogName) {
        this.transactionManager.tryRegisterTransaction(transactionInfo);
        List<String> schemaNames = this.metadata.listSchemaNames(session.toSession(this.sessionPropertyManager), catalogName);
        if (!schemaNames.isEmpty()) {
            return CatalogServer.writeValueAsString(schemaNames, this.objectMapper);
        }
        return EMPTY_STRING;
    }

    @ThriftMethod
    public String getTableHandle(TransactionInfo transactionInfo, SessionRepresentation session, QualifiedObjectName table) {
        this.transactionManager.tryRegisterTransaction(transactionInfo);
        Optional tableHandle = this.metadata.getMetadataResolver(session.toSession(this.sessionPropertyManager)).getTableHandle(table);
        return tableHandle.map(handle -> CatalogServer.writeValueAsString(handle, this.objectMapper)).orElse(EMPTY_STRING);
    }

    @ThriftMethod
    public String listTables(TransactionInfo transactionInfo, SessionRepresentation session, QualifiedTablePrefix prefix) {
        this.transactionManager.tryRegisterTransaction(transactionInfo);
        List<QualifiedObjectName> tableList = this.metadata.listTables(session.toSession(this.sessionPropertyManager), prefix);
        if (!tableList.isEmpty()) {
            return CatalogServer.writeValueAsString(tableList, this.objectMapper);
        }
        return EMPTY_STRING;
    }

    @ThriftMethod
    public String listViews(TransactionInfo transactionInfo, SessionRepresentation session, QualifiedTablePrefix prefix) {
        this.transactionManager.tryRegisterTransaction(transactionInfo);
        List<QualifiedObjectName> viewsList = this.metadata.listViews(session.toSession(this.sessionPropertyManager), prefix);
        if (!viewsList.isEmpty()) {
            CatalogServer.writeValueAsString(viewsList, this.objectMapper);
        }
        return EMPTY_STRING;
    }

    @ThriftMethod
    public String getViews(TransactionInfo transactionInfo, SessionRepresentation session, QualifiedTablePrefix prefix) {
        this.transactionManager.tryRegisterTransaction(transactionInfo);
        Map<QualifiedObjectName, ViewDefinition> viewsMap = this.metadata.getViews(session.toSession(this.sessionPropertyManager), prefix);
        if (!viewsMap.isEmpty()) {
            return CatalogServer.writeValueAsString(viewsMap, this.objectMapper);
        }
        return EMPTY_STRING;
    }

    @ThriftMethod
    public String getView(TransactionInfo transactionInfo, SessionRepresentation session, QualifiedObjectName viewName) {
        this.transactionManager.tryRegisterTransaction(transactionInfo);
        Optional viewDefinition = this.metadata.getMetadataResolver(session.toSession(this.sessionPropertyManager)).getView(viewName);
        return viewDefinition.map(view -> CatalogServer.writeValueAsString(view, this.objectMapper)).orElse(EMPTY_STRING);
    }

    @ThriftMethod
    public String getMaterializedView(TransactionInfo transactionInfo, SessionRepresentation session, QualifiedObjectName viewName) {
        this.transactionManager.tryRegisterTransaction(transactionInfo);
        Optional connectorMaterializedViewDefinition = this.metadata.getMetadataResolver(session.toSession(this.sessionPropertyManager)).getMaterializedView(viewName);
        return connectorMaterializedViewDefinition.map(materializedView -> CatalogServer.writeValueAsString(materializedView, this.objectMapper)).orElse(EMPTY_STRING);
    }

    @ThriftMethod
    public String getReferencedMaterializedViews(TransactionInfo transactionInfo, SessionRepresentation session, QualifiedObjectName tableName) {
        this.transactionManager.tryRegisterTransaction(transactionInfo);
        List<QualifiedObjectName> referencedMaterializedViewsList = this.metadata.getReferencedMaterializedViews(session.toSession(this.sessionPropertyManager), tableName);
        if (!referencedMaterializedViewsList.isEmpty()) {
            return CatalogServer.writeValueAsString(referencedMaterializedViewsList, this.objectMapper);
        }
        return EMPTY_STRING;
    }

    private static String writeValueAsString(Object value, ObjectMapper objectMapper) {
        try {
            return objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

