/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.spi.ClientRequestFilter;
import com.facebook.presto.spi.ClientRequestFilterFactory;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ClientRequestFilterManager {
    private Map<String, ClientRequestFilterFactory> factories = new ConcurrentHashMap<String, ClientRequestFilterFactory>();
    @GuardedBy(value="this")
    private volatile List<ClientRequestFilter> filters = ImmutableList.of();
    private final AtomicBoolean loaded = new AtomicBoolean();

    public void registerClientRequestFilterFactory(ClientRequestFilterFactory factory) {
        if (this.loaded.get()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, "Cannot register factories after filters are loaded.");
        }
        String name = factory.getName();
        if (this.factories.putIfAbsent(name, factory) != null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "A factory with the name '" + name + "' is already registered.");
        }
    }

    public void loadClientRequestFilters() {
        if (!this.loaded.compareAndSet(false, true)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.CONFIGURATION_INVALID, "loadClientRequestFilters can only be called once.");
        }
        this.filters = (List)this.factories.values().stream().map(factory -> factory.create()).collect(ImmutableList.toImmutableList());
        this.factories = null;
    }

    public List<ClientRequestFilter> getClientRequestFilters() {
        return this.filters;
    }
}

