/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.functions.aggregation;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.functions.aggregation.HiveAccumulatorFunctions;
import com.facebook.presto.hive.functions.aggregation.HiveAccumulatorInvoker;
import com.facebook.presto.hive.functions.aggregation.HiveAccumulatorMethodHandles;
import com.facebook.presto.hive.functions.aggregation.HiveAccumulatorState;
import com.facebook.presto.hive.functions.aggregation.HiveAccumulatorStateDescription;
import com.facebook.presto.hive.functions.aggregation.HiveAccumulatorStateFactory;
import com.facebook.presto.hive.functions.aggregation.HiveAccumulatorStateSerializer;
import com.facebook.presto.hive.functions.aggregation.HiveAggregationFunctionDescription;
import com.facebook.presto.hive.functions.aggregation.HiveAggregationFunctionImplementation;
import com.facebook.presto.hive.functions.type.BlockInputDecoder;
import com.facebook.presto.hive.functions.type.BlockInputDecoders;
import com.facebook.presto.hive.functions.type.ObjectEncoders;
import com.facebook.presto.spi.function.Signature;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public class HiveAggregationFunctionImplementationFactory {
    private final Signature signature;
    private final List<Type> inputTypes;
    private final Type intermediateType;
    private final Type outputType;
    private final Supplier<GenericUDAFEvaluator> partialEvaluatorSupplier;
    private final Supplier<GenericUDAFEvaluator> finalEvaluatorSupplier;
    private final ObjectInspector[] inputInspectors;
    private final ObjectInspector intermediateInspector;
    private final ObjectInspector outputInspector;

    public HiveAggregationFunctionImplementationFactory(Signature signature, List<Type> inputTypes, Type intermediateType, Type outputType, Supplier<GenericUDAFEvaluator> partialEvaluatorSupplier, Supplier<GenericUDAFEvaluator> finalEvaluatorSupplier, ObjectInspector[] inputInspectors, ObjectInspector intermediateInspector, ObjectInspector outputInspector) {
        this.signature = Objects.requireNonNull(signature);
        this.inputTypes = Objects.requireNonNull(inputTypes);
        this.intermediateType = Objects.requireNonNull(intermediateType);
        this.outputType = Objects.requireNonNull(outputType);
        this.partialEvaluatorSupplier = partialEvaluatorSupplier;
        this.finalEvaluatorSupplier = finalEvaluatorSupplier;
        this.inputInspectors = Objects.requireNonNull(inputInspectors);
        this.intermediateInspector = Objects.requireNonNull(intermediateInspector);
        this.outputInspector = Objects.requireNonNull(outputInspector);
    }

    public HiveAggregationFunctionImplementation create() {
        HiveAggregationFunctionDescription metadata = new HiveAggregationFunctionDescription(this.signature.getName(), this.inputTypes, (List<Type>)ImmutableList.of((Object)this.intermediateType), this.outputType, true, false);
        HiveAccumulatorInvoker invocationContext = new HiveAccumulatorInvoker(this.partialEvaluatorSupplier, this.finalEvaluatorSupplier, ObjectEncoders.createEncoder(this.outputType, this.outputInspector), this.outputType);
        List<BlockInputDecoder> inputDecoders = Streams.zip(this.inputTypes.stream(), Stream.of(this.inputInspectors), (type, inspector) -> BlockInputDecoders.createBlockInputDecoder(inspector, type)).collect(Collectors.toList());
        HiveAccumulatorFunctions methods = new HiveAccumulatorFunctions(HiveAccumulatorMethodHandles.getInputFunction(invocationContext, inputDecoders), HiveAccumulatorMethodHandles.getCombineFunction(invocationContext), HiveAccumulatorMethodHandles.getOutputFunction(invocationContext));
        HiveAccumulatorStateDescription stateMetadata = new HiveAccumulatorStateDescription(HiveAccumulatorState.class, new HiveAccumulatorStateSerializer(this.partialEvaluatorSupplier, this.finalEvaluatorSupplier, this.intermediateType, this.intermediateInspector), new HiveAccumulatorStateFactory(invocationContext::newAggregationBuffer));
        return new HiveAggregationFunctionImplementation(metadata, methods, stateMetadata);
    }
}

