/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.functions.scalar;

import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.hive.functions.HiveFunction;
import com.facebook.presto.hive.functions.gen.ScalarMethodHandles;
import com.facebook.presto.hive.functions.scalar.HiveScalarFunctionInvoker;
import com.facebook.presto.spi.function.FunctionImplementationType;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.InvocationConvention;
import com.facebook.presto.spi.function.JavaScalarFunctionImplementation;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;

public class HiveScalarFunction
extends HiveFunction {
    private final JavaScalarFunctionImplementation implementation;
    private final FunctionMetadata functionMetadata;

    private HiveScalarFunction(FunctionMetadata metadata, Signature signature, String description, JavaScalarFunctionImplementation implementation) {
        super(metadata.getName(), signature, false, metadata.isDeterministic(), metadata.isCalledOnNullInput(), description);
        this.functionMetadata = Objects.requireNonNull(metadata, "metadata is null");
        this.implementation = Objects.requireNonNull(implementation, "implementation is null");
    }

    public static HiveScalarFunction createHiveScalarFunction(Class<?> cls, QualifiedObjectName name, List<TypeSignature> argumentTypes, TypeManager typeManager) {
        HiveScalarFunctionInvoker invoker = HiveScalarFunctionInvoker.createFunctionInvoker(cls, name, argumentTypes, typeManager);
        MethodHandle methodHandle = ScalarMethodHandles.generateUnbound(invoker.getSignature(), typeManager).bindTo(invoker);
        Signature signature = invoker.getSignature();
        FunctionMetadata functionMetadata = new FunctionMetadata(name, signature.getArgumentTypes(), signature.getReturnType(), FunctionKind.SCALAR, FunctionImplementationType.JAVA, true, true);
        InvocationConvention invocationConvention = new InvocationConvention((List)signature.getArgumentTypes().stream().map(t -> InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE).collect(ImmutableList.toImmutableList()), InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, false);
        HiveScalarFunctionImplementation implementation = new HiveScalarFunctionImplementation(methodHandle, invocationConvention);
        return new HiveScalarFunction(functionMetadata, signature, name.getObjectName(), implementation);
    }

    @Override
    public FunctionMetadata getFunctionMetadata() {
        return this.functionMetadata;
    }

    public JavaScalarFunctionImplementation getJavaScalarFunctionImplementation() {
        return this.implementation;
    }

    public SqlFunctionVisibility getVisibility() {
        return SqlFunctionVisibility.PUBLIC;
    }

    private static class HiveScalarFunctionImplementation
    implements JavaScalarFunctionImplementation {
        private final MethodHandle methodHandle;
        private final InvocationConvention invocationConvention;

        private HiveScalarFunctionImplementation(MethodHandle methodHandle, InvocationConvention invocationConvention) {
            this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
            this.invocationConvention = Objects.requireNonNull(invocationConvention, "invocationConvention is null");
        }

        public InvocationConvention getInvocationConvention() {
            return this.invocationConvention;
        }

        public MethodHandle getMethodHandle() {
            return this.methodHandle;
        }
    }
}

