/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.functions.type;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.functions.HiveFunctionErrorCode;
import com.facebook.presto.hive.functions.type.BlockInputDecoder;
import com.facebook.presto.hive.functions.type.BlockInputDecoders;
import com.facebook.presto.hive.functions.type.DateTimeUtils;
import com.facebook.presto.hive.functions.type.ObjectInputDecoder;
import com.facebook.presto.hive.functions.type.ObjectInspectors;
import io.airlift.slice.Slice;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.common.type.HiveDecimal;

public final class ObjectInputDecoders {
    private ObjectInputDecoders() {
    }

    public static ObjectInputDecoder createDecoder(Type type, TypeManager typeManager) {
        String base;
        switch (base = type.getTypeSignature().getBase()) {
            case "unknown": {
                return o -> o;
            }
            case "bigint": {
                return o -> (Long)o;
            }
            case "integer": {
                return o -> ((Long)o).intValue();
            }
            case "smallint": {
                return o -> ((Long)o).shortValue();
            }
            case "tinyint": {
                return o -> ((Long)o).byteValue();
            }
            case "boolean": {
                return o -> (Boolean)o;
            }
            case "date": {
                return DateTimeUtils::createDate;
            }
            case "decimal": {
                if (Decimals.isShortDecimal((Type)type)) {
                    int scale = ((DecimalType)type).getScale();
                    return o -> HiveDecimal.create((BigInteger)BigInteger.valueOf((Long)o), (int)scale);
                }
                if (!Decimals.isLongDecimal((Type)type)) break;
                int scale = ((DecimalType)type).getScale();
                return o -> HiveDecimal.create((BigInteger)Decimals.decodeUnscaledValue((Slice)((Slice)o)), (int)scale);
            }
            case "real": {
                return o -> Float.valueOf(Float.intBitsToFloat(((Number)o).intValue()));
            }
            case "double": {
                return o -> (Double)o;
            }
            case "timestamp": {
                return o -> new Timestamp((Long)o);
            }
            case "varbinary": {
                return o -> ((Slice)o).getBytes();
            }
            case "varchar": {
                return o -> ((Slice)o).toStringUtf8();
            }
            case "char": {
                return o -> ((Slice)o).toStringUtf8();
            }
            case "row": {
                return RowObjectInputDecoder.create((RowType)type, typeManager);
            }
            case "array": {
                return ArrayObjectInputDecoder.create((ArrayType)type, typeManager);
            }
            case "map": {
                return MapObjectInputDecoder.create((MapType)type, typeManager);
            }
        }
        throw HiveFunctionErrorCode.unsupportedType(type);
    }

    public static BlockInputDecoder createBlockInputDecoder(Type type, TypeManager typeManager) {
        return BlockInputDecoders.createBlockInputDecoder(ObjectInspectors.create(type, typeManager), type);
    }

    public static class MapObjectInputDecoder
    implements ObjectInputDecoder {
        private final BlockInputDecoder keyDecoder;
        private final BlockInputDecoder valueDecoder;

        private static MapObjectInputDecoder create(MapType type, TypeManager typeManager) {
            return new MapObjectInputDecoder(ObjectInputDecoders.createBlockInputDecoder(type.getKeyType(), typeManager), ObjectInputDecoders.createBlockInputDecoder(type.getValueType(), typeManager));
        }

        private MapObjectInputDecoder(BlockInputDecoder keyDecoder, BlockInputDecoder valueDecoder) {
            this.keyDecoder = Objects.requireNonNull(keyDecoder, "keyDecoder is null");
            this.valueDecoder = Objects.requireNonNull(valueDecoder, "valueDecoder is null");
        }

        @Override
        public Object decode(Object object) {
            if (object == null) {
                return null;
            }
            Block block = (Block)object;
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (int i = 0; i < block.getPositionCount(); i += 2) {
                Object key = this.keyDecoder.decode(block, i);
                if (key == null) continue;
                Object value = this.valueDecoder.decode(block, i + 1);
                map.put(key, value);
            }
            return map;
        }
    }

    public static class ArrayObjectInputDecoder
    implements ObjectInputDecoder {
        private final BlockInputDecoder elementDecoder;

        private static ArrayObjectInputDecoder create(ArrayType type, TypeManager typeManager) {
            return new ArrayObjectInputDecoder(ObjectInputDecoders.createBlockInputDecoder(type.getElementType(), typeManager));
        }

        private ArrayObjectInputDecoder(BlockInputDecoder elementDecoder) {
            this.elementDecoder = Objects.requireNonNull(elementDecoder, "elementDecoder is null");
        }

        @Override
        public Object decode(Object object) {
            if (object == null) {
                return null;
            }
            Block block = (Block)object;
            int count = block.getPositionCount();
            ArrayList<Object> list = new ArrayList<Object>(count);
            for (int i = 0; i < count; ++i) {
                list.add(this.elementDecoder.decode(block, i));
            }
            return list;
        }
    }

    public static class RowObjectInputDecoder
    implements ObjectInputDecoder {
        private final List<BlockInputDecoder> fieldDecoders;

        private static RowObjectInputDecoder create(RowType type, TypeManager typeManager) {
            List<BlockInputDecoder> fieldDecoders = type.getFields().stream().map(f -> ObjectInputDecoders.createBlockInputDecoder(f.getType(), typeManager)).collect(Collectors.toList());
            return new RowObjectInputDecoder(fieldDecoders);
        }

        private RowObjectInputDecoder(List<BlockInputDecoder> fieldDecoders) {
            this.fieldDecoders = Objects.requireNonNull(fieldDecoders, "fieldDecoders is null");
        }

        @Override
        public Object decode(Object object) {
            if (object == null) {
                return null;
            }
            Block block = (Block)object;
            ArrayList<Object> list = new ArrayList<Object>(this.fieldDecoders.size());
            int numField = this.fieldDecoders.size();
            for (int i = 0; i < numField; ++i) {
                list.add(this.fieldDecoders.get(i).decode(block, i));
            }
            return list;
        }
    }
}

