/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.functions.gen;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.hive.functions.gen.CompilerOperations;
import com.facebook.presto.spi.function.aggregation.AggregationMetadata;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;

public class AggregationUtils {
    private AggregationUtils() {
    }

    public static String generateAggregationName(String baseName, TypeSignature outputType, List<TypeSignature> inputTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, AggregationUtils.getAbbreviatedTypeName(outputType)));
        for (TypeSignature inputType : inputTypes) {
            sb.append(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, AggregationUtils.getAbbreviatedTypeName(inputType)));
        }
        sb.append(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, baseName.toLowerCase(Locale.ENGLISH)));
        return sb.toString();
    }

    private static String getAbbreviatedTypeName(TypeSignature type) {
        String typeName = type.toString();
        if (typeName.length() > 10) {
            return typeName.substring(0, 10);
        }
        return typeName;
    }

    public static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(List<Type> inputTypes) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.add((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE));
        for (Type inputType : inputTypes) {
            builder.add((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.NULLABLE_BLOCK_INPUT_CHANNEL, inputType));
        }
        builder.add((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
        return builder.build();
    }

    public static Block extractMaskBlock(int maskChannel, Page page) {
        if (maskChannel < 0) {
            return null;
        }
        Block maskBlock = page.getBlock(maskChannel);
        if (page.getPositionCount() > 0 && maskBlock instanceof RunLengthEncodedBlock && CompilerOperations.testMask(maskBlock, 0)) {
            return null;
        }
        return maskBlock;
    }
}

