/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.udf.grpc;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.udf.grpc.EchoFirstInputGrpcUdfService;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.IOException;

public class TestingGrpcUdfServer {
    Logger log = Logger.get(EchoFirstInputGrpcUdfService.class);
    private static int port = 50051;
    private static Server server;

    private TestingGrpcUdfServer() {
        server = ServerBuilder.forPort((int)port).addService((BindableService)new EchoFirstInputGrpcUdfService((BlockEncodingSerde)new BlockEncodingManager())).build();
    }

    private void startGrpcServer() throws IOException {
        server.start();
        this.log.info("======== SERVER STARTED ========");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                TestingGrpcUdfServer.this.log.info("======== shutting down gRPC server since JVM is shutting down ========");
                TestingGrpcUdfServer.this.stopGrpcServer();
                TestingGrpcUdfServer.this.log.info("======== server shut down ========");
            }
        });
    }

    private void stopGrpcServer() {
        if (server != null) {
            server.shutdown();
        }
    }

    private void blockUntilShutdown() throws InterruptedException {
        if (server != null) {
            server.awaitTermination();
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        TestingGrpcUdfServer testingGrpcUdfServer = new TestingGrpcUdfServer();
        testingGrpcUdfServer.startGrpcServer();
        testingGrpcUdfServer.blockUntilShutdown();
    }
}

