/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.google.sheets;

import com.facebook.presto.common.type.Type;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;

public class SheetsColumn {
    private final String name;
    private final Type type;

    @JsonCreator
    public SheetsColumn(@JsonProperty(value="name") String name, @JsonProperty(value="type") Type type) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or is empty");
        this.name = name;
        this.type = Objects.requireNonNull(type, "type is null");
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SheetsColumn other = (SheetsColumn)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type);
    }

    public String toString() {
        return this.name + ":" + this.type;
    }
}

