/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.google.sheets;

import com.facebook.presto.google.sheets.SheetsClient;
import com.facebook.presto.google.sheets.SheetsColumnHandle;
import com.facebook.presto.google.sheets.SheetsErrorCode;
import com.facebook.presto.google.sheets.SheetsTable;
import com.facebook.presto.google.sheets.SheetsTableHandle;
import com.facebook.presto.google.sheets.SheetsTableLayoutHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class SheetsMetadata
implements ConnectorMetadata {
    private final SheetsClient sheetsClient;
    private static final List<String> SCHEMAS = ImmutableList.of((Object)"default");

    @Inject
    public SheetsMetadata(SheetsClient sheetsClient) {
        this.sheetsClient = Objects.requireNonNull(sheetsClient, "sheetsClient is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.listSchemaNames();
    }

    public List<String> listSchemaNames() {
        return SCHEMAS;
    }

    public SheetsTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        if (!this.listSchemaNames(session).contains(tableName.getSchemaName())) {
            return null;
        }
        Optional<SheetsTable> table = this.sheetsClient.getTable(tableName.getTableName());
        if (!table.isPresent()) {
            return null;
        }
        return new SheetsTableHandle(tableName.getSchemaName(), tableName.getTableName());
    }

    public ConnectorTableLayoutResult getTableLayoutForConstraint(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        SheetsTableHandle tableHandle = (SheetsTableHandle)table;
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new SheetsTableLayoutHandle(tableHandle));
        return new ConnectorTableLayoutResult(layout, constraint.getSummary());
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        Optional<ConnectorTableMetadata> connectorTableMetadata = this.getTableMetadata(session, ((SheetsTableHandle)table).toSchemaTableName());
        if (!connectorTableMetadata.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)SheetsErrorCode.SHEETS_UNKNOWN_TABLE_ERROR, "Metadata not found for table " + ((SheetsTableHandle)table).getTableName());
        }
        return connectorTableMetadata.get();
    }

    private Optional<ConnectorTableMetadata> getTableMetadata(ConnectorSession session, SchemaTableName tableName) {
        if (!this.listSchemaNames().contains(tableName.getSchemaName())) {
            return Optional.empty();
        }
        Optional<SheetsTable> table = this.sheetsClient.getTable(tableName.getTableName());
        if (table.isPresent()) {
            List columns = (List)table.get().getColumnsMetadata().stream().map(column -> column.toBuilder().setName(this.normalizeIdentifier(session, column.getName())).build()).collect(ImmutableList.toImmutableList());
            return Optional.of(new ConnectorTableMetadata(tableName, columns));
        }
        return Optional.empty();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        SheetsTableHandle sheetsTableHandle = (SheetsTableHandle)tableHandle;
        Optional<SheetsTable> table = this.sheetsClient.getTable(sheetsTableHandle.getTableName());
        if (!table.isPresent()) {
            throw new TableNotFoundException(sheetsTableHandle.toSchemaTableName());
        }
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        int index = 0;
        List columns = (List)table.get().getColumnsMetadata().stream().map(column -> column.toBuilder().setName(this.normalizeIdentifier(session, column.getName())).build()).collect(ImmutableList.toImmutableList());
        for (ColumnMetadata column2 : columns) {
            columnHandles.put((Object)column2.getName(), (Object)new SheetsColumnHandle(column2.getName(), column2.getType(), index));
            ++index;
        }
        return columnHandles.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((SheetsColumnHandle)columnHandle).getColumnMetadata();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, Optional.ofNullable(prefix.getSchemaName()))) {
            Optional<ConnectorTableMetadata> tableMetadata = this.getTableMetadata(session, tableName);
            if (!tableMetadata.isPresent()) continue;
            columns.put((Object)tableName, (Object)tableMetadata.get().getColumns());
        }
        return columns.build();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        String schema = schemaName.orElseGet(() -> (String)Iterables.getOnlyElement(SCHEMAS));
        if (this.listSchemaNames().contains(schema)) {
            return (List)this.sheetsClient.getTableNames().stream().map(tableName -> new SchemaTableName(schema, tableName)).collect(ImmutableList.toImmutableList());
        }
        return ImmutableList.of();
    }
}

