/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.google.sheets;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.google.sheets.SheetsColumn;
import com.facebook.presto.google.sheets.SheetsConfig;
import com.facebook.presto.google.sheets.SheetsErrorCode;
import com.facebook.presto.google.sheets.SheetsTable;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.model.ValueRange;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class SheetsClient {
    private static final Logger log = Logger.get(SheetsClient.class);
    private static final String APPLICATION_NAME = "Presto google sheets integration";
    private static final JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
    private static final List<String> SCOPES = ImmutableList.of((Object)"https://www.googleapis.com/auth/spreadsheets.readonly");
    private final LoadingCache<String, Optional<String>> tableSheetMappingCache;
    private final LoadingCache<String, List<List<Object>>> sheetDataCache;
    private final String metadataSheetId;
    private final String credentialsFilePath;
    private final Sheets sheetsService;

    @Inject
    public SheetsClient(SheetsConfig config, JsonCodec<Map<String, List<SheetsTable>>> catalogCodec) {
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(catalogCodec, "catalogCodec is null");
        this.metadataSheetId = config.getMetadataSheetId();
        this.credentialsFilePath = config.getCredentialsFilePath();
        try {
            this.sheetsService = new Sheets.Builder((HttpTransport)GoogleNetHttpTransport.newTrustedTransport(), JSON_FACTORY, (HttpRequestInitializer)this.getCredentials()).setApplicationName(APPLICATION_NAME).build();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new PrestoException((ErrorCodeSupplier)SheetsErrorCode.SHEETS_BAD_CREDENTIALS_ERROR, (Throwable)e);
        }
        long expiresAfterWriteMillis = config.getSheetsDataExpireAfterWrite().toMillis();
        long maxCacheSize = config.getSheetsDataMaxCacheSize();
        this.tableSheetMappingCache = SheetsClient.newCacheBuilder(expiresAfterWriteMillis, maxCacheSize).build((CacheLoader)new CacheLoader<String, Optional<String>>(){

            public Optional<String> load(String tableName) {
                return SheetsClient.this.getSheetExpressionForTable(tableName);
            }
        });
        this.sheetDataCache = SheetsClient.newCacheBuilder(expiresAfterWriteMillis, maxCacheSize).build(CacheLoader.from(this::readAllValuesFromSheetExpression));
    }

    public Optional<SheetsTable> getTable(String tableName) {
        List<List<Object>> values = this.readAllValues(tableName);
        if (values.size() > 0) {
            ImmutableList.Builder columns = ImmutableList.builder();
            HashSet<String> columnNames = new HashSet<String>();
            List<Object> header = values.get(0);
            int count = 0;
            for (Object column : header) {
                String columnValue = column.toString().toLowerCase(Locale.ENGLISH);
                if (columnValue.isEmpty() || columnNames.contains(columnValue)) {
                    columnValue = "column_" + ++count;
                }
                columnNames.add(columnValue);
                columns.add((Object)new SheetsColumn(columnValue, (Type)VarcharType.VARCHAR));
            }
            List<List<Object>> dataValues = values.subList(1, values.size());
            return Optional.of(new SheetsTable(tableName, (List<SheetsColumn>)columns.build(), dataValues));
        }
        return Optional.empty();
    }

    public Set<String> getTableNames() {
        ImmutableSet.Builder tables = ImmutableSet.builder();
        try {
            List tableMetadata = (List)this.sheetDataCache.getUnchecked((Object)this.metadataSheetId);
            for (int i = 1; i < tableMetadata.size(); ++i) {
                if (((List)tableMetadata.get(i)).size() <= 0) continue;
                tables.add((Object)String.valueOf(((List)tableMetadata.get(i)).get(0)));
            }
            return tables.build();
        }
        catch (UncheckedExecutionException e) {
            SheetsClient.throwIfInstanceOf(e.getCause(), PrestoException.class);
            throw new PrestoException((ErrorCodeSupplier)SheetsErrorCode.SHEETS_METASTORE_ERROR, (Throwable)e);
        }
    }

    public List<List<Object>> readAllValues(String tableName) {
        try {
            Optional sheetExpression = (Optional)this.tableSheetMappingCache.getUnchecked((Object)tableName);
            if (!sheetExpression.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)SheetsErrorCode.SHEETS_UNKNOWN_TABLE_ERROR, "Sheet expression not found for table " + tableName);
            }
            return (List)this.sheetDataCache.getUnchecked(sheetExpression.get());
        }
        catch (UncheckedExecutionException e) {
            SheetsClient.throwIfInstanceOf(e.getCause(), PrestoException.class);
            throw new PrestoException((ErrorCodeSupplier)SheetsErrorCode.SHEETS_TABLE_LOAD_ERROR, "Error loading data for table: " + tableName, (Throwable)e);
        }
    }

    private Optional<String> getSheetExpressionForTable(String tableName) {
        Map<String, Optional<String>> tableSheetMap = this.getAllTableSheetExpressionMapping();
        if (!tableSheetMap.containsKey(tableName)) {
            return Optional.empty();
        }
        return tableSheetMap.get(tableName);
    }

    private Map<String, Optional<String>> getAllTableSheetExpressionMapping() {
        ImmutableMap.Builder tableSheetMap = ImmutableMap.builder();
        List<List<Object>> data = this.readAllValuesFromSheetExpression(this.metadataSheetId);
        for (int i = 1; i < data.size(); ++i) {
            if (data.get(i).size() < 2) continue;
            String tableId = String.valueOf(data.get(i).get(0));
            String sheetId = String.valueOf(data.get(i).get(1));
            tableSheetMap.put((Object)tableId.toLowerCase(Locale.ENGLISH), Optional.of(sheetId));
        }
        return tableSheetMap.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Credential getCredentials() {
        try (FileInputStream in = new FileInputStream(this.credentialsFilePath);){
            GoogleCredential googleCredential = GoogleCredential.fromStream((InputStream)in).createScoped(SCOPES);
            return googleCredential;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)SheetsErrorCode.SHEETS_BAD_CREDENTIALS_ERROR, (Throwable)e);
        }
    }

    private List<List<Object>> readAllValuesFromSheetExpression(String sheetExpression) {
        try {
            String defaultRange = "$1:$10000";
            String[] tableOptions = sheetExpression.split("#");
            String sheetId = tableOptions[0];
            if (tableOptions.length > 1) {
                defaultRange = tableOptions[1];
            }
            log.debug("Accessing sheet id [%s] with range [%s]", new Object[]{sheetId, defaultRange});
            return ((ValueRange)this.sheetsService.spreadsheets().values().get(sheetId, defaultRange).execute()).getValues();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)SheetsErrorCode.SHEETS_UNKNOWN_TABLE_ERROR, "Failed reading data from sheet: " + sheetExpression, (Throwable)e);
        }
    }

    private static CacheBuilder<Object, Object> newCacheBuilder(long expiresAfterWriteMillis, long maximumSize) {
        return CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).maximumSize(maximumSize);
    }

    private static <X extends Throwable> void throwIfInstanceOf(Throwable throwable, Class<X> declaredType) throws X {
        Objects.requireNonNull(throwable);
        if (declaredType.isInstance(throwable)) {
            throw (Throwable)declaredType.cast(throwable);
        }
    }
}

